<?php
/**
 * update_check.php – Versionscheck AJAX-Endpoint (INV)
 *
 * Gibt JSON zurück mit:
 *   installed  – aktuell installierte Version
 *   available  – neue Version (null wenn aktuell)
 *   changelog  – Changelog-Text der neuen Version
 *   up_to_date – boolean
 *
 * Zugriff: nur für eingeloggte Admins (Hub-Superuser oder Instanz-Admin)
 */

ini_set('display_errors', 0);
ob_start();

header('Content-Type: application/json; charset=utf-8');

// Session starten
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Auth-Prüfung: Hub-Superuser ODER eingeloggter Instanz-Admin
// (manage.php läuft im Kontext einer Instanz, setzt auth_<prefix> in der Session)
$inv_authorized = isset($_SESSION['hub_superuser']);
if (!$inv_authorized) {
    foreach ($_SESSION as $key => $val) {
        if (strpos($key, 'auth_') === 0 && is_array($val)) {
            $inv_authorized = true;
            break;
        }
    }
}
if (!$inv_authorized) {
    ob_end_clean();
    http_response_code(403);
    echo json_encode(['error' => 'Nicht autorisiert']);
    exit;
}

try {
    require_once __DIR__ . '/../hub_config.php';
    require_once __DIR__ . '/Updater.php';

    $pdo = new PDO(
        'mysql:host=' . HUB_DB_HOST . ';dbname=' . HUB_DB_NAME . ';charset=utf8mb4',
        HUB_DB_USER,
        HUB_DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    $installed = Updater::getInstalledVersion($pdo);
    $available = Updater::getAvailableUpdate($installed);

    ob_end_clean();
    echo json_encode([
        'installed'  => $installed,
        'available'  => $available ? $available['version'] : null,
        'changelog'  => $available ? ($available['changelog'] ?? '') : null,
        'released'   => $available ? ($available['released'] ?? '') : null,
        'up_to_date' => $available === null,
    ]);

} catch (Throwable $e) {
    ob_end_clean();
    http_response_code(500);
    echo json_encode([
        'error' => 'Interner Fehler: ' . $e->getMessage()
                    . ' [' . basename($e->getFile()) . ':' . $e->getLine() . ']',
    ]);
}
