<?php
// index.php - HUB (V3.0 Core-Architecture)
session_start();

// CSRF-Funktionen für Hub laden
require_once __DIR__ . '/core/functions.php';

// 1. Install Check
if (!file_exists('hub_config.php')) { header("Location: hub_install.php"); exit(); }
require_once 'hub_config.php';

// 2. DB Verbindung
try {
    $hubPdo = new PDO("mysql:host=".HUB_DB_HOST.";dbname=".HUB_DB_NAME.";charset=utf8mb4", HUB_DB_USER, HUB_DB_PASS);
    $hubPdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) { die("Hub DB Fehler: Bitte hub_config.php prüfen."); }

$error = '';
$hubName = "Inventar Hub";

// 3. LOGIN LOGIK
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['hub_user'])) {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $error = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
    } else {
    $user = trim($_POST['hub_user']);
    $pass = $_POST['hub_pass'] ?? '';
    $stmt = $hubPdo->prepare("SELECT * FROM hub_users WHERE username = ?");
    $stmt->execute([$user]);
    $u = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($u && password_verify($pass, $u['password'])) {
        $_SESSION['hub_superuser'] = true;
        $_SESSION['hub_username'] = $u['username'];
        header("Location: index.php"); exit();
    } else { $error = "Login fehlgeschlagen."; }
    } // Ende CSRF-Schutz
}

// LOGOUT
if (isset($_GET['logout'])) { session_destroy(); header("Location: index.php"); exit(); }

// 4. INSTALL LOGIK (Neue Instanz - V3.0 STUB GENERATOR)
if (isset($_SESSION['hub_superuser']) && isset($_POST['action']) && $_POST['action'] === 'create') {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $error = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
    } else {
    $folder = preg_replace('/[^a-z0-9_-]/', '', strtolower($_POST['folder']));
    $prefix = preg_replace('/[^a-z0-9_]/', '', strtolower($_POST['prefix'])); 
    
    // Zielordner
    $dst = __DIR__ . '/inventar/' . $folder;
    if (is_dir($dst)) {
        $error = "Ordner '$folder' existiert bereits.";
    } else {
        // Ordner erstellen
        if (!is_dir(__DIR__ . '/inventar')) mkdir(__DIR__ . '/inventar');
        mkdir($dst);

        // Liste aller Dateien, die als "Brücke" zum Core fungieren sollen
        $files = [
            'index.php', 'install.php', 'login.php', 'logout.php',
            'dashboard.php', 'scan.php', 'move.php', 'dispose.php',
            'inventur.php', 'list.php', 'report.php', 'manage.php',
            'users.php', 'locations_cats.php', 'import_export.php',
            'edit.php', 'themes.php', 'manifest.php', 'sw.php'
        ];

        // Stub-Content generieren
        foreach ($files as $file) {
            $content = "<?php\n";
            $content .= "define('INSTANCE_DIR', __DIR__);\n";
            // Index leitet nur weiter
            if ($file === 'index.php') {
                $content .= "header('Location: dashboard.php');\nexit();\n";
            } else {
                // Alle anderen laden ihr Gegenstück aus dem Core
                $content .= "require_once '../../core/$file';\n";
            }
            
            file_put_contents($dst . '/' . $file, $content);
        }

        // Weiterleitung zur Installation der neuen Instanz
        header("Location: inventar/$folder/install.php?prefix=" . $prefix);
        exit();
    }
    } // Ende CSRF-Schutz
}

// 5. PORTALE SCANNEN
$portals = [];
if (is_dir('inventar')) {
    foreach(glob('inventar/*', GLOB_ONLYDIR) as $dir) {
        if(file_exists($dir.'/dashboard.php')) {
            $id = basename($dir);
            $icon = '📦';
            if (strpos($id, 'edv')!==false) $icon = '💻';
            elseif (strpos($id, 'sport')!==false) $icon = '⚽';
            elseif (strpos($id, 'kueche')!==false) $icon = '🍳';
            elseif (strpos($id, 'musik')!==false) $icon = '🎵';
            elseif (strpos($id, 'chemie')!==false || strpos($id, 'physik')!==false) $icon = '⚡';
            $portals[] = ['id' => ucfirst($id), 'path' => $dir, 'icon' => $icon];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($hubName) ?></title>
    <link rel="stylesheet" href="css/base.css">
    <link id="theme-css" rel="stylesheet" href="css/themes/clean.css">
    
    <script>
        function updatePrefix() {
            const folder = document.getElementById('folderInput').value.toLowerCase().replace(/[^a-z0-9]/g, '');
            if(folder.length > 0) {
                let pre = "inv_" + folder.substring(0, 3) + "_";
                document.getElementById('prefixInput').value = pre;
            }
        }
        function openModal(id) { document.getElementById(id).classList.add('active'); }
        function closeModal(id) { document.getElementById(id).classList.remove('active'); }
        function filterPortals(q) {
            q = q.toLowerCase();
            document.querySelectorAll('.portal-card[data-name]').forEach(card => {
                card.style.display = (q === '' || card.dataset.name.includes(q)) ? '' : 'none';
            });
        }
        
        // Theme Logic (Lädt nur gespeichertes Theme, Umschalter entfernt)
        (function() {
            const savedTheme = localStorage.getItem('hub_theme');
            const sysTheme = 'clean'; 
            document.documentElement.setAttribute('data-theme', savedTheme || sysTheme);
        })();
    </script>
</head>
<body>

    <div style="position: absolute; top: 1rem; right: 1rem; z-index: 50;">
        <?php if(isset($_SESSION['hub_superuser'])): ?>
            <span class="text-muted" style="margin-right:15px;">
                👤 <?= htmlspecialchars($_SESSION['hub_username']) ?>
            </span>
            <a href="?logout=1" class="btn btn-danger btn-sm">Logout</a>
        <?php else: ?>
            <button onclick="openModal('loginModal')" class="btn btn-secondary btn-sm">Admin Login</button>
        <?php endif; ?>
    </div>
    
    <div class="container flex-center flex-col" style="min-height: 80vh;">
        <header class="text-center" style="margin-bottom: 3rem; margin-top: 4rem;">
            <h1 style="font-size: 3rem; margin-bottom: 0.5rem; background: -webkit-linear-gradient(45deg, var(--primary), #06b6d4); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?= htmlspecialchars($hubName) ?></h1>
            <p class="text-muted">Zentrale Verwaltung</p>
        </header>
        
        <?php if (count($portals) > 1): ?>
        <div style="margin-bottom: 1.5rem; width: 100%; max-width: 300px;">
            <input type="text" id="hubSearch" oninput="filterPortals(this.value)" placeholder="🔍 Instanz suchen..." style="width: 100%;">
        </div>
        <?php endif; ?>

        <div class="grid-responsive" style="width: 100%;">
            <?php foreach($portals as $p): ?>
                <a href="<?= $p['path'] ?>/dashboard.php" class="glass-panel portal-card" data-name="<?= htmlspecialchars(strtolower($p['id'])) ?>">
                    <span class="portal-icon"><?= $p['icon'] ?></span>
                    <div class="portal-title"><?= htmlspecialchars($p['id']) ?></div>
                    <div class="text-muted">Öffnen</div>
                </a>
            <?php endforeach; ?>

            <?php if(isset($_SESSION['hub_superuser'])): ?>
                <div onclick="openModal('installModal')" class="glass-panel portal-card" style="border-style:dashed; cursor:pointer; opacity:0.7;">
                    <span class="portal-icon text-muted">➕</span>
                    <div class="portal-title">Neues Inventar</div>
                    <div class="text-muted">Installation starten</div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div id="loginModal" class="modal <?= $error ? 'active' : '' ?>">
        <div class="glass-panel modal-content">
            <h2 class="text-center" style="margin-bottom: 2rem;">Hub Login</h2>
            <?php if($error) echo "<div class='alert alert-error text-center' style='margin-bottom:1.5rem;'>$error</div>"; ?>
            
            <form method="POST">
                <?= csrfField() ?>
                <div class="form-group" style="margin-bottom: 1.5rem;">
                    <input type="text" name="hub_user" placeholder="Benutzername" required autofocus>
                </div>
                <div class="form-group" style="margin-bottom: 2rem;">
                    <input type="password" name="hub_pass" placeholder="Passwort" required>
                </div>
                <div class="flex-row gap-2">
                    <button type="button" onclick="closeModal('loginModal')" class="btn btn-secondary" style="flex:1;">Abbruch</button>
                    <button class="btn" style="flex:1;">Login</button>
                </div>
            </form>
        </div>
    </div>

    <?php if(isset($_SESSION['hub_superuser'])): ?>
    <div id="installModal" class="modal">
        <div class="glass-panel modal-content">
            <h2 class="text-center" style="margin-bottom:1rem;">Neue Instanz</h2>
            <form method="POST">
                <?= csrfField() ?>
                <input type="hidden" name="action" value="create">
                
                <div class="form-group">
                    <label>Ordnername (URL)</label>
                    <input type="text" name="folder" id="folderInput" onkeyup="updatePrefix()" placeholder="z.B. sport" required pattern="[a-z0-9_-]+" title="Nur Kleinbuchstaben">
                </div>
                
                <div class="form-group">
                    <label>Tabellen-Präfix</label>
                    <input type="text" name="prefix" id="prefixInput" placeholder="inv_spo_" required class="font-mono">
                </div>
                
                <div class="flex-row gap-2" style="margin-top: 1.5rem;">
                    <button type="button" onclick="closeModal('installModal')" class="btn btn-secondary" style="flex:1;">Abbruch</button>
                    <button class="btn" style="flex:1;">Anlegen 🚀</button>
                </div>
            </form>
        </div>
    </div>
    <?php endif; ?>
<?php include 'footer.php'; ?>
</body>
</html>