<?php
// hub_install.php
session_start();
$msg = "";
$error = "";

// Default Werte
$defaultText = "Bereitgestellt von iT-Wilfinger";

if (file_exists('hub_config.php')) {
    header("Location: index.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $host = trim($_POST['host']);
    $db   = trim($_POST['db']);
    $user = trim($_POST['user']);
    $pass = trim($_POST['pass']);
    
    $su_user = trim($_POST['su_user']);
    $su_pass = $_POST['su_pass'] ?? '';
    $su_pass_confirm = $_POST['su_pass_confirm'] ?? '';

    // Footer Daten
    $footer_show = isset($_POST['footer_show']) ? 'true' : 'false';
    $footer_text = trim($_POST['footer_text']);
    
    // HIER GEÄNDERT: Links komplett leer gelassen
    $footer_links = ''; 

    if ($su_pass !== $su_pass_confirm) {
        $error = "Die SuperAdmin-Passwörter stimmen nicht überein.";
    } 
    elseif (empty($host) || empty($db) || empty($user) || empty($su_user) || empty($su_pass)) {
        $error = "Bitte alle Pflichtfelder ausfüllen.";
    }
    else {
        try {
            $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            // Tabelle erstellen
            $pdo->exec("CREATE TABLE IF NOT EXISTS hub_users (
                id INT AUTO_INCREMENT PRIMARY KEY,
                username VARCHAR(50) UNIQUE NOT NULL,
                password VARCHAR(255) NOT NULL,
                role ENUM('superuser') DEFAULT 'superuser',
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

            // User anlegen oder updaten
            $stmtCheck = $pdo->prepare("SELECT id FROM hub_users WHERE username = ?");
            $stmtCheck->execute([$su_user]);
            if($stmtCheck->fetch()) {
                $stmt = $pdo->prepare("UPDATE hub_users SET password = ? WHERE username = ?");
                $stmt->execute([password_hash($su_pass, PASSWORD_DEFAULT), $su_user]);
            } else {
                $stmt = $pdo->prepare("INSERT INTO hub_users (username, password) VALUES (?, ?)");
                $stmt->execute([$su_user, password_hash($su_pass, PASSWORD_DEFAULT)]);
            }

            // Config Datei schreiben
            $configContent = "<?php\n";
            $configContent .= "// Automatisch erstellt am " . date('Y-m-d H:i') . "\n";
            $configContent .= "define('HUB_DB_HOST', '" . addslashes($host) . "');\n";
            $configContent .= "define('HUB_DB_NAME', '" . addslashes($db) . "');\n";
            $configContent .= "define('HUB_DB_USER', '" . addslashes($user) . "');\n";
            $configContent .= "define('HUB_DB_PASS', '" . addslashes($pass) . "');\n\n";
            
            // Footer Konfiguration speichern
            $configContent .= "// Footer Konfiguration\n";
            $configContent .= "define('FOOTER_SHOW', " . $footer_show . ");\n";
            $configContent .= "define('FOOTER_TEXT', '" . addslashes($footer_text) . "');\n";
            $configContent .= "define('FOOTER_LINKS', '" . addslashes($footer_links) . "');\n";
            
            if(file_put_contents('hub_config.php', $configContent)) {
                header("Location: index.php");
                exit();
            } else {
                $error = "Konnte hub_config.php nicht schreiben. Schreibrechte prüfen!";
            }

        } catch (Exception $e) {
            $error = "Fehler: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hub Installation</title>
    <link rel="stylesheet" href="css/base.css">
    <link id="theme-css" rel="stylesheet" href="css/themes/light.css">
    <style>
        .password-wrapper { position: relative; display: flex; align-items: center; }
        .password-wrapper input { padding-right: 40px; }
        .toggle-password { position: absolute; right: 10px; cursor: pointer; color: var(--text-muted); }
        .checkbox-wrapper { display: flex; align-items: center; gap: 10px; margin-bottom: 1rem; }
    </style>
    <script>
        document.documentElement.setAttribute('data-theme', 'light');
        function togglePass(inputId) {
            const input = document.getElementById(inputId);
            input.type = input.type === "password" ? "text" : "password";
        }
        function toggleFooterFields(checkbox) {
            const fields = document.getElementById('footerFields');
            fields.style.display = checkbox.checked ? 'block' : 'none';
        }
    </script>
</head>
<body class="flex-center" style="min-height: 100vh;">
    
    <div class="glass-panel container-small">
        <h1 class="text-center text-primary" style="margin-bottom: 1.5rem;">Hub Setup 🚀</h1>
        
        <?php if($error): ?><div class="alert alert-error"><?= htmlspecialchars($error) ?></div><?php endif; ?>
        
        <form method="POST">
            <h3 class="text-muted uppercase font-bold" style="margin-bottom: 10px; border-bottom: 1px solid var(--glass-border); padding-bottom: 5px;">1. Datenbank Verbindung</h3>
            <div class="form-group"><input type="text" name="host" placeholder="Host (z.B. localhost)" value="localhost" required></div>
            <div class="form-group"><input type="text" name="db" placeholder="Datenbank Name" required></div>
            <div class="form-group"><input type="text" name="user" placeholder="DB Benutzer" required></div>
            <div class="form-group">
                <div class="password-wrapper">
                    <input type="password" name="pass" id="db_pass" placeholder="DB Passwort">
                    <span class="toggle-password" onclick="togglePass('db_pass')">👁️</span>
                </div>
            </div>

            <h3 class="text-muted uppercase font-bold" style="margin-top: 1.5rem; margin-bottom: 10px; border-bottom: 1px solid var(--glass-border); padding-bottom: 5px;">2. SuperAdmin Account</h3>
            <div class="form-group">
                <input type="text" name="su_user" placeholder="Benutzername" required autocomplete="username">
            </div>
            <div class="grid-2">
                <div class="form-group">
                    <div class="password-wrapper">
                        <input type="password" name="su_pass" id="su_pass" placeholder="Passwort" required autocomplete="new-password">
                        <span class="toggle-password" onclick="togglePass('su_pass')">👁️</span>
                    </div>
                </div>
                <div class="form-group">
                    <div class="password-wrapper">
                        <input type="password" name="su_pass_confirm" id="su_pass_confirm" placeholder="Wiederholen" required autocomplete="new-password">
                        <span class="toggle-password" onclick="togglePass('su_pass_confirm')">👁️</span>
                    </div>
                </div>
            </div>

            <h3 class="text-muted uppercase font-bold" style="margin-top: 1.5rem; margin-bottom: 10px; border-bottom: 1px solid var(--glass-border); padding-bottom: 5px;">3. Footer / Branding</h3>
            
            <div class="checkbox-wrapper">
                <input type="checkbox" name="footer_show" id="footer_show" value="1" checked onchange="toggleFooterFields(this)">
                <label for="footer_show">Footer anzeigen</label>
            </div>

            <div id="footerFields">
                <div class="form-group">
                    <label style="font-size: 0.8rem;">Anzeige-Text (Copyright)</label>
                    <input type="text" name="footer_text" value="<?= htmlspecialchars($defaultText) ?>" placeholder="z.B. IT Abteilung">
                </div>
            </div>

            <div class="text-center" style="margin-top: 2rem;">
                <button type="submit" class="btn btn-block" style="padding: 1rem; font-size: 1.1rem;">Hub installieren</button>
            </div>
            
        </form>
    </div>
</body>
</html>