<?php
// core/users.php
ob_start();
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/db.php';

$msgSuccess = [];
$msgError = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msgError[] = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
    } else {
    // 1. User Anlegen
    if (isset($_POST['action']) && $_POST['action'] === 'create') {
        $newUser = trim($_POST['new_username']);
        $newPass = $_POST['new_password'] ?? '';

        if (strlen($newPass) < 8) {
            $msgError[] = "Passwort muss mindestens 8 Zeichen lang sein.";
        } else {
            $checkStmt = $pdo->prepare("SELECT id FROM `{$table_prefix}users` WHERE username = ?");
            $checkStmt->execute([$newUser]);
            if ($checkStmt->fetch()) {
                $msgError[] = "User existiert bereits.";
            } else {
                $stmt = $pdo->prepare("INSERT INTO `{$table_prefix}users` (username, password, role) VALUES (?, ?, 'admin')");
                $stmt->execute([$newUser, password_hash($newPass, PASSWORD_DEFAULT)]);
                $msgSuccess[] = "User angelegt.";
            }
        }
    }
    
    // 2. User Löschen
    if (isset($_POST['action']) && $_POST['action'] === 'delete') {
        $targetId = $_POST['user_id'];
        if ($targetId == $_SESSION['auth_'.($table_prefix ?? 'default')]['user_id']) { 
            $msgError[] = "Selbstmord ist keine Lösung (Du kannst dich nicht selbst löschen).";
        } else {
            $pdo->prepare("DELETE FROM `{$table_prefix}users` WHERE id = ?")->execute([$targetId]);
            $msgSuccess[] = "User gelöscht.";
        }
    }

    // 3. NEU: Passwort Ändern
    if (isset($_POST['action']) && $_POST['action'] === 'change_pw') {
        $targetId = $_POST['user_id'];
        $newPass  = $_POST['new_password'] ?? '';

        if (strlen($newPass) < 8) {
            $msgError[] = "Passwort muss mindestens 8 Zeichen lang sein.";
        } else {
            $stmt = $pdo->prepare("UPDATE `{$table_prefix}users` SET password = ? WHERE id = ?");
            $stmt->execute([password_hash($newPass, PASSWORD_DEFAULT), $targetId]);
            $msgSuccess[] = "Passwort erfolgreich geändert.";
        }
    }
    } // Ende CSRF-Schutz
}

$users = $pdo->query("SELECT * FROM `{$table_prefix}users` ORDER BY username ASC")->fetchAll();
$pageTitle = "User Management";
require_once __DIR__ . '/header.php';
?>

<div class="container container-narrow">
    <?php if ($msgSuccess) echo '<div class="alert alert-success">'.implode('<br>', $msgSuccess).'</div>'; ?>
    <?php if ($msgError) echo '<div class="alert alert-error">'.implode('<br>', $msgError).'</div>'; ?>

    <div class="glass-panel">
        <h2 class="text-primary" style="margin-bottom: 1rem;">Neuen Admin anlegen</h2>
        <form method="POST">
            <?= csrfField() ?>
            <input type="hidden" name="action" value="create">
            <div class="grid-2">
                <input type="text" name="new_username" placeholder="Username" required autocomplete="off">
                <input type="password" name="new_password" placeholder="Passwort (min. 8 Zeichen)" required autocomplete="new-password" minlength="8">
            </div>
            <button type="submit" class="btn btn-block" style="margin-top: 1rem;">Anlegen</button>
        </form>
    </div>

    <div class="glass-panel">
        <h2>Vorhandene Benutzer</h2>
        <?php foreach ($users as $u): ?>
            <div class="flex-between" style="border-bottom: 1px solid var(--glass-border); padding: 10px 0;">
                <div>
                    <strong><?= h($u['username']) ?></strong>
                    <span class="text-muted" style="font-size:0.8rem;">(ID: <?= $u['id'] ?>)</span>
                    <br><span class="text-muted" style="font-size:0.75rem;">Login: <?= $u['last_login'] ? date('d.m.Y H:i', strtotime($u['last_login'])) : '—' ?></span>
                </div>
                
                <div class="flex-row gap-2">
                    <button type="button" class="btn btn-secondary btn-sm" onclick="openPwModal(<?= $u['id'] ?>, '<?= h($u['username']) ?>')">
                        🔑 PW Ändern
                    </button>

                    <?php if($u['id'] != ($currentUserId ?? 0)): ?>
                        <form method="POST" style="margin:0;">
                            <?= csrfField() ?>
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="user_id" value="<?= $u['id'] ?>">
                            <button class="btn btn-danger btn-sm" onclick="return confirm('Benutzer wirklich löschen?')">X</button>
                        </form>
                    <?php else: ?>
                        <span class="btn btn-sm btn-secondary" style="cursor: default; opacity: 0.5;">(Du)</span>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<div id="pwModal" class="modal">
    <div class="glass-panel modal-content">
        <h3 class="text-center" style="margin-bottom: 1rem;">Passwort ändern</h3>
        <p class="text-center text-muted" id="pwModalUserDisplay" style="margin-bottom: 1.5rem;">...</p>
        
        <form method="POST">
            <?= csrfField() ?>
            <input type="hidden" name="action" value="change_pw">
            <input type="hidden" name="user_id" id="pwModalUserId">
            
            <div class="form-group">
                <label>Neues Passwort</label>
                <input type="password" name="new_password" required placeholder="Min. 8 Zeichen" autofocus minlength="8">
            </div>
            
            <div class="flex-row gap-2" style="margin-top: 1.5rem;">
                <button type="button" onclick="closeModal('pwModal')" class="btn btn-secondary" style="flex:1;">Abbruch</button>
                <button type="submit" class="btn" style="flex:1;">Speichern</button>
            </div>
        </form>
    </div>
</div>

<script>
    // Funktion um das Modal mit den richtigen Daten zu füllen und zu öffnen
    function openPwModal(id, username) {
        // ID in das versteckte Feld setzen
        document.getElementById('pwModalUserId').value = id;
        // Username im Text anzeigen
        document.getElementById('pwModalUserDisplay').innerText = "Für Benutzer: " + username;
        // Modal öffnen (Funktion aus footer.php/base.css Logik)
        openModal('pwModal');
    }
</script>

<?php require_once __DIR__ . '/footer.php'; ?>