<?php
// core/themes.php
ob_start();
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/db.php';

$pageTitle = "Design wählen";
require_once __DIR__ . '/header.php';

// Verzeichnis definieren
$themeDir = __DIR__ . '/../css/themes';
$themeFiles = glob($themeDir . '/*.css');

// SORTIERUNG HINZUFÜGEN:
if ($themeFiles) {
    sort($themeFiles); // Sortiert das Array alphabetisch aufsteigend (A-Z)
}

// Metadaten für die Darstellung (ohne Cyber!)
$themeMeta = [
    'clean' => [
        'icon' => '✨',
        'title' => 'Clean',
        'desc' => 'Minimal & Klar',
        'style' => 'background: #ffffff; border: 2px solid #e5e5e5; color: #000000;'
    ],
    'dark' => [
        'icon' => '🌙',
        'title' => 'Dark Mode',
        'desc' => 'Elegant & Tief',
        'style' => 'background: linear-gradient(135deg, #0a0e27 0%, #1a1f3a 100%); border: 2px solid rgba(159, 168, 199, 0.3); color: #e8eaf6;'
    ],
    'light' => [
        'icon' => '☀️',
        'title' => 'Light Mode',
        'desc' => 'Hell & Modern',
        'style' => 'background: linear-gradient(135deg, #fafbfc 0%, #f0f4f8 100%); border: 2px solid #e2e8f0; color: #1a202c;'
    ],
    'liquid' => [
        'icon' => '🌊',
        'title' => 'Liquid Glass',
        'desc' => 'Glasmorphism ✨',
        'style' => 'background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border: 2px solid rgba(255, 255, 255, 0.4); color: #ffffff; box-shadow: 0 8px 32px rgba(31, 38, 135, 0.37);'
    ]
];
?>

<!-- Spezielle Styles nur für diese Seite -->
<style>
    /* Seite immer weiß, egal welches Theme aktiv */
    /*body {
        background: #f5f5f5 !important;
    }*/
    
    .container {
        background: transparent !important;
    }
    
    .glass-panel {
        background: #ffffff !important;
        border: 1px solid #e5e5e5 !important;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1) !important;
    }
    
    h2 {
        color: #1a202c !important;
    }
    
    .flex-between {
        border-bottom: 1px solid #e5e5e5 !important;
    }
    
    /* Theme-Karten Styling */
    .theme-card {
        /* Abrundung wie andere Karten */
        border-radius: 16px !important;
        
        /* Padding wie portal-cards */
        padding: 1.5rem !important;
        
        /* Display */
        display: flex !important;
        flex-direction: column !important;
        align-items: center !important;
        justify-content: center !important;
        text-align: center !important;
        
        /* Keine Outline */
        border: 2px solid;
        outline: none;
        
        /* Cursor */
        cursor: pointer;
        
        /* Transition */
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        
        /* Min-Height */
        min-height: 140px;
    }
    
    /* KEIN Hover-Effekt! */
    .theme-card:hover {
        transform: none !important;
        box-shadow: none !important;
    }
    
    /* Active-Effekt beim Klick */
    .theme-card:active {
        transform: scale(0.98);
    }
    
    /* Button-Reset */
    .theme-card {
        background: none;
        font-family: inherit;
        font-size: inherit;
    }
</style>

<div class="container container-narrow">

    <div class="glass-panel">
        <div class="flex-between" style="padding-bottom: 1rem; margin-bottom: 1.5rem;">
            <h2 style="margin:0;">Design wählen</h2>
            <a href="manage.php" class="btn btn-secondary btn-sm">Zurück</a>
        </div>

        <div class="manage-grid">

            <?php
            if ($themeFiles) {
                foreach ($themeFiles as $file) {
                    $key = basename($file, '.css');
                    
                    // Cyber-Theme ausblenden!
                    if ($key === 'cyber') {
                        continue;
                    }

                    // Nur bekannte Themes anzeigen
                    if (!isset($themeMeta[$key])) {
                        continue;
                    }
                    
                    $meta = $themeMeta[$key];
            ?>
                    <button onclick="setTheme('<?= h($key) ?>')" class="theme-card" style="<?= $meta['style'] ?>">
                        <span style="font-size: 3rem; display: block; margin-bottom: 0.5rem;">
                            <?= $meta['icon'] ?>
                        </span>
                        <div style="font-weight: 700;"><?= h($meta['title']) ?></div>
                        <div style="font-size: 0.8rem; opacity: 0.7;"><?= h($meta['desc']) ?></div>
                    </button>
            <?php
                }
            } else {
                echo '<div style="grid-column: 1/-1; text-align: center; color: #999;">Keine Themes gefunden in: ' . htmlspecialchars($themeDir) . '</div>';
            }
            ?>

        </div>
    </div>
</div>

<script>
    // Checkbox initialisieren
    document.addEventListener('DOMContentLoaded', () => {
        // Removed - jetzt in manage.php
    });
</script>

<?php require_once __DIR__ . '/footer.php'; ?>