<?php
// core/move.php
ob_start();
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/db.php';

$msg = "";
$msgClass = ""; 

$stmtLoc = $pdo->query("SELECT name FROM `{$table_prefix}locations` ORDER BY name ASC");
$locations = $stmtLoc->fetchAll(PDO::FETCH_COLUMN);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msg = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
        $msgClass = "alert-error";
    } else {
    $barcodesInput = trim($_POST['barcode']);
    $newLocation   = trim($_POST['new_location']);
    
    if (empty($newLocation) || !in_array($newLocation, $locations)) {
        $msg = "Ungültiger Standort.";
        $msgClass = "alert-error";
    } elseif (empty($barcodesInput)) {
        $msg = "Bitte Barcode eingeben.";
        $msgClass = "alert-error";
    } else {
        $barcodesInput = preg_replace('/[\t\n\r\s]+/', ',', $barcodesInput);
        $barcodeList = explode(',', $barcodesInput);
        $moveCount = 0;
        $errors = [];

        foreach ($barcodeList as $code) {
            $code = trim($code);
            if (empty($code)) continue;

            if (($_POST['remove_zeros'] ?? '1') === '1') {
                $code = preg_replace('/0000$/', '', $code);
            }

            $stmtCheck = $pdo->prepare("SELECT id, location, item_name FROM `{$table_prefix}inventory` WHERE barcode = ?");
            $stmtCheck->execute([$code]);
            $item = $stmtCheck->fetch();

            if ($item) {
                if ($item['location'] === $newLocation) {
                    $errors[] = "$code ist bereits dort.";
                    continue;
                }
                $stmtUpdate = $pdo->prepare("UPDATE `{$table_prefix}inventory` SET location = ? WHERE id = ?");
                if ($stmtUpdate->execute([$newLocation, $item['id']])) {
                    $historyStmt = $pdo->prepare("INSERT INTO `{$table_prefix}history` (inventory_id, user_id, username, action, old_value, new_value) VALUES (?, ?, ?, 'move', ?, ?)");
                    $historyStmt->execute([$item['id'], $currentUserId, $currentUser, $item['location'], $newLocation]);
                    $moveCount++;
                }
            } else {
                $errors[] = "Barcode $code nicht gefunden.";
            }
        }

        if ($moveCount > 0) {
            $msg = "$moveCount Artikel nach <b>$newLocation</b> verschoben.";
            if ($errors) $msg .= "<br><small>" . implode(', ', $errors) . "</small>";
            $msgClass = "alert-success";
        } else {
            $msg = "Keine Artikel verschoben.<br>" . implode('<br>', $errors);
            $msgClass = "alert-error";
        }
    }
    } // Ende CSRF-Schutz
}

$pageTitle = "Umlagern";
require_once __DIR__ . '/header.php';
?>

<div class="container container-form">
    <?php if ($msg): ?><div class="alert <?= $msgClass ?> alert-simple"><?= $msg ?></div><?php endif; ?>

    <div class="glass-panel mode-warning" style="border-top: 4px solid var(--warning);">
        <h2 class="text-center" style="color: var(--warning); margin-bottom: 2rem; border-bottom: 1px solid var(--glass-border); padding-bottom: 1rem;">Standort wechseln</h2>
        
        <form method="POST" id="moveForm">
            <?= csrfField() ?>
            <input type="hidden" name="remove_zeros" id="removeZerosInput" value="1">
            <div class="form-group">
                <label>Ziel-Standort</label>
                <select name="new_location" required style="width: 100%;">
                    <option value="">-- Ziel wählen --</option>
                    <?php foreach($locations as $l): ?>
                        <option value="<?= h($l) ?>" <?= (isset($_POST['new_location']) && $_POST['new_location'] == $l) ? 'selected' : '' ?>><?= h($l) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label class="font-bold uppercase" style="color: var(--warning);">Barcode(s)</label>
                <textarea name="barcode" id="barcodeInput" rows="4" required autofocus placeholder="Scannen..." class="font-mono" style="font-size: 1.2rem;"></textarea>
                <p class="text-muted" id="barcodeHint" style="font-size: 0.75rem; margin-top: 0.25rem;"></p>
            </div>

            <button type="submit" class="btn btn-block" style="background-color: var(--warning); color: #fff; padding: 1rem; font-size: 1.1rem; margin-top: 1.5rem;">Umlagern bestätigen</button>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const removeZeros = getBarcodeRemoveZeros();
        document.getElementById('removeZerosInput').value = removeZeros ? '1' : '0';
        const hint = document.getElementById('barcodeHint');
        if (hint) hint.textContent = removeZeros
            ? '(Scanner-Modus: 0000 am Ende werden entfernt.)'
            : '(Scanner-Modus: aktiv – Nullen werden NICHT entfernt.)';
        const input = document.getElementById('barcodeInput');
        if(input) {
            input.addEventListener('keydown', (e) => {
                if (e.key === 'Tab' || e.key === 'Enter') {
                    e.preventDefault();
                    let start = input.selectionStart; 
                    let end = input.selectionEnd; 
                    let val = input.value;
                    
                    let before = val.substring(0, start);
                    let after = val.substring(end);
                    
                    before = cleanBarcode(before);
                    
                    input.value = before + "," + after;
                    input.selectionStart = input.selectionEnd = before.length + 1;
                }
            });
        }
    });
</script>
<?php require_once __DIR__ . '/footer.php'; ?>