<?php
// core/manifest.php — Dynamisches PWA Web App Manifest
// Konfiguration laden (ohne Auth-Check, da manifest öffentlich sein muss)
if (defined('INSTANCE_DIR') && file_exists(INSTANCE_DIR . '/config.php')) {
    require_once INSTANCE_DIR . '/config.php';
}

$name = $site_name ?? 'Inventar';
header('Content-Type: application/manifest+json');
echo json_encode([
    'name'             => $name,
    'short_name'       => mb_substr($name, 0, 12),
    'start_url'        => 'dashboard.php',
    'scope'            => './',
    'display'          => 'standalone',
    'background_color' => '#0f172a',
    'theme_color'      => '#7c3aed',
    'icons'            => [
        [
            'src'     => '../../css/icon.svg',
            'sizes'   => 'any',
            'type'    => 'image/svg+xml',
            'purpose' => 'any maskable'
        ]
    ]
], JSON_UNESCAPED_UNICODE);
