<?php
// core/manage.php
ob_start();
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/db.php';

// Absoluter URL-Pfad zum update/-Verzeichnis.
// __DIR__ ist immer /…/inv/core – unabhängig davon, ob manage.php direkt oder
// via Stub (inventar/edv/manage.php) aufgerufen wurde. So löst der JS-Fetch
// immer auf /inv/update/ auf, egal wie tief die Browser-URL liegt.
$_inv_update_url = rtrim(
    str_replace($_SERVER['DOCUMENT_ROOT'], '', dirname(__DIR__)),
    '/'
) . '/update';

define('APP_VERSION', '5.0.0');

$pageTitle = "Einstellungen";
require_once __DIR__ . '/header.php';
?>

<div class="container">
    <div class="glass-panel text-center" style="margin-bottom: 2rem;">
        <h1>Einstellungen</h1>
        <a href="https://paypal.me/StefanWilfinger" target="_blank" class="btn btn-sm" style="background: #FFD700; color: #000 !important; text-decoration: none; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
            ☕ Spendier mir einen Kaffee
        </a>
        <div class="text-muted" style="font-size: 0.85rem; margin-top: 1rem;">
            Inventar Hub V<?= APP_VERSION ?> • <span id="inv-update-badge">Prüfe auf Updates…</span> • <a href="../../CHANGELOG.html" target="_blank" style="color: var(--primary); text-decoration: none; font-weight: 600;">Changelog</a>
        </div>
    </div>
    
    <div class="manage-grid">
        
        <a href="import_export.php" class="glass-panel admin-card">
            <span class="portal-icon">💾</span>
            <div class="portal-title">Backup</div>
            <div class="text-muted" style="font-size: 0.8rem;">Import / Export</div>
        </a>

        <a href="users.php" class="glass-panel admin-card">
            <span class="portal-icon">👥</span>
            <div class="portal-title">Benutzer</div>
            <div class="text-muted" style="font-size: 0.8rem;">Admins verwalten</div>
        </a>

        <a href="themes.php" class="glass-panel admin-card">
            <span class="portal-icon">🎨</span>
            <div class="portal-title">Design</div>
            <div class="text-muted" style="font-size: 0.8rem;">Farbschema</div>
        </a>

        <a href="locations_cats.php" class="glass-panel admin-card">
            <span class="portal-icon">🗂️</span>
            <div class="portal-title">Stammdaten</div>
            <div class="text-muted" style="font-size: 0.8rem;">Kategorien & Orte</div>
        </a>

        <a href="#" onclick="invOpenUpdateModal(); return false;" class="glass-panel admin-card" id="inv-update-card">
            <span class="portal-icon">🔄</span>
            <div class="portal-title">System-Update</div>
            <div class="text-muted" style="font-size: 0.8rem;" id="inv-update-card-status">Prüfe…</div>
        </a>
    </div>

    <!-- Update Modal -->
    <div id="invUpdateModal" style="display:none; position:fixed; inset:0; background:rgba(0,0,0,0.5); z-index:1000; align-items:center; justify-content:center;">
        <div class="glass-panel" style="max-width:520px; width:90%; padding:2rem; position:relative;">
            <h2 style="margin-top:0; text-align:center;">System-Update</h2>
            <div id="inv-update-modal-body" style="margin-bottom:1.5rem; color:var(--text-muted); font-size:0.9rem;">
                Lade Versionsinformationen…
            </div>
            <div id="inv-update-form-wrap" style="display:none;">
                <div style="background:rgba(255,200,0,0.1); border:1px solid rgba(255,200,0,0.4); border-radius:8px; padding:1rem; margin-bottom:1rem; font-size:0.85rem; color:var(--text-muted);">
                    Das Update überschreibt alle Programmdateien. Konfigurations-Dateien (<code>hub_config.php</code>, <code>inventar/*/config.php</code>) werden nicht verändert.
                </div>
                <input type="hidden" id="inv-target-version" value="">
                <div style="display:flex; gap:1rem; margin-top:1rem;">
                    <button onclick="invCloseUpdateModal()" class="btn btn-secondary" style="flex:1;">Abbrechen</button>
                    <button onclick="invDoUpdate()" class="btn" style="flex:1; background:var(--danger,#e53e3e); color:#fff;" id="inv-update-confirm-btn">
                        Jetzt aktualisieren
                    </button>
                </div>
            </div>
            <div id="inv-update-up-to-date" style="display:none; text-align:center;">
                <div style="font-size:2rem; margin-bottom:0.5rem;">✅</div>
                <div style="color:var(--text-muted);">Das System ist aktuell.</div>
                <button onclick="invCloseUpdateModal()" class="btn btn-secondary" style="margin-top:1rem;">Schließen</button>
            </div>
            <div id="inv-update-progress-wrap" style="display:none;">
                <pre id="inv-update-progress" style="max-height:200px; overflow-y:auto; font-size:0.75rem; background:rgba(0,0,0,0.1); padding:1rem; border-radius:8px; margin:0 0 1rem 0; white-space:pre-wrap;"></pre>
                <div id="inv-update-done-btn" style="display:none; text-align:center;">
                    <button onclick="location.reload()" class="btn">Seite neu laden</button>
                </div>
            </div>
            <button onclick="invCloseUpdateModal()" style="position:absolute; top:1rem; right:1rem; background:none; border:none; font-size:1.3rem; cursor:pointer; color:var(--text-muted);">✕</button>
        </div>
    </div>
    
    <!-- Weitere Einstellungen -->
    <div class="glass-panel" style="margin-top: 2rem;">
        <h3 style="margin-top: 0; margin-bottom: 1.5rem; padding-bottom: 0.75rem; border-bottom: 2px solid var(--glass-border); color: var(--text-main);">Weitere Einstellungen</h3>
        
        <!-- Scanner-Einstellungen -->
        <div style="margin-bottom: 1rem;">
            <label style="display: flex; align-items: flex-start; gap: 1rem; cursor: pointer;">
                <input type="checkbox" id="removeZerosCheckbox" style="width: 20px; height: 20px; margin-top: 2px; cursor: pointer; flex-shrink: 0;">
                <div style="flex: 1;">
                    <div style="font-weight: 600; color: var(--text-main); margin-bottom: 0.25rem;">📱 Scanner: Letzte 4 Nullen automatisch entfernen</div>
                    <div style="font-size: 0.85rem; color: var(--text-muted); line-height: 1.4;">
                        Die Barcodes haben physisch immer 4 Nullen am Ende. Beim manuellen Erfassen wurden diese Nullen historisch immer weggelassen. Diese Einstellung entfernt die Nullen auch beim Scannen.
                        [Beispiel: Barcode-Aufdruck <code>4000020502020000</code> → Erfasst als <code>400002050202</code>]
                    </div>
                </div>
            </label>
        </div>
        
        <!-- Platzhalter für zukünftige Einstellungen -->
        <!-- Hier können später weitere Einstellungen hinzugefügt werden -->
    </div>
</div>

<script>
    // ── Update-System ──────────────────────────────────────────────────────────
    let invUpdateData = null;
    const INV_CSRF       = '<?= h(generateCSRF()) ?>';
    const INV_UPDATE_BASE = '<?= htmlspecialchars($_inv_update_url, ENT_QUOTES, 'UTF-8') ?>';

    document.addEventListener('DOMContentLoaded', () => {
        // Versionscheck im Hintergrund beim Laden
        fetch(INV_UPDATE_BASE + '/update_check.php')
            .then(r => r.json())
            .then(data => {
                invUpdateData = data;
                const badge  = document.getElementById('inv-update-badge');
                const status = document.getElementById('inv-update-card-status');
                if (data.error) {
                    badge.textContent  = 'Update-Check fehlgeschlagen';
                    status.textContent = 'Fehler';
                } else if (data.up_to_date) {
                    badge.textContent  = 'System: Aktuell (v' + data.installed + ')';
                    status.textContent = 'Aktuell';
                } else {
                    badge.innerHTML    = '<span style="color:var(--danger,#e53e3e); font-weight:600;">Update: v' + data.available + ' verfügbar</span>';
                    status.innerHTML   = '<span style="color:var(--danger,#e53e3e); font-weight:700;">v' + data.available + ' verfügbar!</span>';
                    document.getElementById('inv-update-card').style.boxShadow = '0 0 0 2px var(--danger,#e53e3e)';
                }
            })
            .catch(() => {
                const badge = document.getElementById('inv-update-badge');
                if (badge) badge.textContent = 'Update-Check nicht verfügbar';
            });
    });

    function invOpenUpdateModal() {
        document.getElementById('invUpdateModal').style.display = 'flex';
        const body      = document.getElementById('inv-update-modal-body');
        const formWrap  = document.getElementById('inv-update-form-wrap');
        const upToDate  = document.getElementById('inv-update-up-to-date');
        const progress  = document.getElementById('inv-update-progress-wrap');

        formWrap.style.display = 'none';
        upToDate.style.display = 'none';
        progress.style.display = 'none';

        if (!invUpdateData) {
            body.textContent = 'Lade Versionsinformationen…';
            fetch(INV_UPDATE_BASE + '/update_check.php')
                .then(r => r.json())
                .then(data => { invUpdateData = data; invFillModal(); })
                .catch(() => { body.textContent = 'Update-Server nicht erreichbar.'; });
        } else {
            invFillModal();
        }
    }

    function invFillModal() {
        const body     = document.getElementById('inv-update-modal-body');
        const formWrap = document.getElementById('inv-update-form-wrap');
        const upToDate = document.getElementById('inv-update-up-to-date');
        const data     = invUpdateData;

        if (data.error) {
            body.textContent = 'Fehler: ' + data.error;
            return;
        }

        body.innerHTML = '<strong>Installiert:</strong> v' + data.installed + '<br>';

        if (data.up_to_date) {
            upToDate.style.display = 'block';
        } else {
            body.innerHTML += '<strong>Verfügbar:</strong> v' + data.available
                + (data.released ? ' (vom ' + data.released + ')' : '') + '<br>';
            if (data.changelog) {
                body.innerHTML += '<div style="margin-top:0.75rem; padding:0.75rem; background:rgba(0,0,0,0.08); border-radius:6px; font-size:0.82rem;">'
                    + '<strong>Changelog:</strong><br>' + invEscape(data.changelog) + '</div>';
            }
            document.getElementById('inv-target-version').value = data.available;
            formWrap.style.display = 'block';
        }
    }

    function invDoUpdate() {
        const btn      = document.getElementById('inv-update-confirm-btn');
        const formWrap = document.getElementById('inv-update-form-wrap');
        const progress = document.getElementById('inv-update-progress-wrap');
        const log      = document.getElementById('inv-update-progress');
        const doneBtn  = document.getElementById('inv-update-done-btn');
        const version  = document.getElementById('inv-target-version').value;

        btn.disabled   = true;
        btn.textContent = 'Aktualisiere…';
        formWrap.style.display = 'none';
        progress.style.display = 'block';
        log.textContent = 'Starte Update auf v' + version + '…\n';

        const fd = new FormData();
        fd.append('csrf_token',     INV_CSRF);
        fd.append('target_version', version);

        fetch(INV_UPDATE_BASE + '/update_apply.php', { method: 'POST', body: fd })
            .then(r => r.json())
            .then(data => {
                if (data.steps && data.steps.length) {
                    log.textContent += data.steps.join('\n') + '\n';
                }
                if (data.success) {
                    log.textContent += '\n✅ Update erfolgreich!';
                    doneBtn.style.display = 'block';
                } else {
                    log.textContent += '\n❌ Fehler: ' + (data.error || 'Unbekannter Fehler');
                }
            })
            .catch(err => {
                log.textContent += '\n❌ Netzwerkfehler: ' + err.message;
            });
    }

    function invCloseUpdateModal() {
        document.getElementById('invUpdateModal').style.display = 'none';
    }

    function invEscape(str) {
        return String(str).replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');
    }

    // ── Scanner-Einstellungen: Checkbox initialisieren ──────────────────────────
    document.addEventListener('DOMContentLoaded', () => {
        const checkbox = document.getElementById('removeZerosCheckbox');
        if (checkbox) {
            // Aktuellen Status laden (Standard: true)
            checkbox.checked = getBarcodeRemoveZeros();
            
            // Bei Änderung speichern
            checkbox.addEventListener('change', () => {
                setBarcodeRemoveZeros(checkbox.checked);
                
                // Visuelles Feedback (Label kurz hervorheben)
                const label = checkbox.closest('label');
                const originalOpacity = label.style.opacity;
                label.style.opacity = '0.6';
                setTimeout(() => {
                    label.style.opacity = originalOpacity || '1';
                }, 150);
            });
        }
    });
</script>

<?php require_once __DIR__ . '/footer.php'; ?>