<?php
// core/logout.php
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// 1. Instanz-Konfiguration laden, um den richtigen Prefix zu finden
$prefixToKill = 'default';

if (defined('INSTANCE_DIR') && file_exists(INSTANCE_DIR . '/config.php')) {
    require_once INSTANCE_DIR . '/config.php';
    if (isset($table_prefix)) {
        $prefixToKill = $table_prefix;
    }
}

// 2. Spezifische Instanz-Session löschen
$sessionKey = 'auth_' . $prefixToKill;
if (isset($_SESSION[$sessionKey])) {
    unset($_SESSION[$sessionKey]);
}

// 3. Falls keine andere Instanz (und kein SuperUser) mehr eingeloggt ist -> Session ganz zerstören
// Wir prüfen grob, ob noch Schlüssel mit "auth_" oder "hub_" da sind.
$hasOtherSessions = false;
foreach($_SESSION as $k => $v) {
    if ((strpos($k, 'auth_') === 0 && $k !== $sessionKey) || strpos($k, 'hub_') === 0) {
        $hasOtherSessions = true;
        break;
    }
}

if (!$hasOtherSessions) {
    // Session Cookie löschen
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    session_destroy();
}

// 4. Redirect
header("Location: login.php");
exit();
?>