<?php
// core/login.php
ob_start();
if (session_status() === PHP_SESSION_NONE) {
    if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') {
        ini_set('session.cookie_secure', 1);
    }
    session_start();
}

// Prüfen ob Config existiert und DB verbinden
if (defined('INSTANCE_DIR')) {
    $configFile = INSTANCE_DIR . '/config.php';
    if (file_exists($configFile)) {
        require_once $configFile;
        try {
            $pdo = new PDO("mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4", DB_USER, DB_PASS);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
            // Auto-Migration: login_attempts Tabelle
            $pdo->exec("CREATE TABLE IF NOT EXISTS `{$table_prefix}login_attempts` (
                `ip` VARCHAR(45) NOT NULL,
                `attempts` INT DEFAULT 0,
                `last_attempt` INT DEFAULT 0,
                PRIMARY KEY (`ip`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
        } catch(PDOException $e) { die("DB Error: Verbindung fehlgeschlagen."); }
    } else { die("Config missing"); }
}

// Session-Key basierend auf Prefix
$sessionKey = 'auth_' . ($table_prefix ?? 'default');

if (isset($_SESSION[$sessionKey])) {
    header("Location: dashboard.php");
    exit();
}

$error = '';

// Fehler-Parameter aus URL (z.B. session_invalid)
if (isset($_GET['error'])) {
    if ($_GET['error'] === 'session_invalid') {
        $error = 'Ihre Session ist abgelaufen oder wurde von einem anderen Gerät übernommen. Bitte melden Sie sich erneut an.';
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $ip = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    $lockout_time = 300; // 5 Minuten Sperrzeit

    // Rate-Limiting: IP-basiert aus Datenbank
    $stmtA = $pdo->prepare("SELECT attempts, last_attempt FROM `{$table_prefix}login_attempts` WHERE ip = ?");
    $stmtA->execute([$ip]);
    $attemptRow = $stmtA->fetch();
    $attempts    = $attemptRow ? (int)$attemptRow['attempts']    : 0;
    $last_attempt = $attemptRow ? (int)$attemptRow['last_attempt'] : 0;

    // Sperrzeit abgelaufen -> Eintrag löschen
    if ($attempts >= 5 && (time() - $last_attempt) >= $lockout_time) {
        $pdo->prepare("DELETE FROM `{$table_prefix}login_attempts` WHERE ip = ?")->execute([$ip]);
        $attempts = 0;
    }

    if ($attempts >= 5) {
        $remaining = ceil(($lockout_time - (time() - $last_attempt)) / 60);
        $error = "Zu viele fehlgeschlagene Login-Versuche. Bitte warten Sie $remaining Minute(n).";
    } else {
        $username = trim($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';

        try {
            $stmt = $pdo->prepare("SELECT * FROM `{$table_prefix}users` WHERE username = ?");
            $stmt->execute([$username]);
            $user = $stmt->fetch();

            if ($user && password_verify($password, $user['password'])) {
                // LOGIN ERFOLGREICH
                $pdo->prepare("DELETE FROM `{$table_prefix}login_attempts` WHERE ip = ?")->execute([$ip]);
                $pdo->prepare("UPDATE `{$table_prefix}users` SET last_login = NOW() WHERE id = ?")->execute([$user['id']]);

                // Session-Fixation verhindern
                session_regenerate_id(true);

                // Session-Fingerprint (nur User-Agent, keine IP)
                $_SESSION['security_fingerprint'] = hash('sha256', $_SERVER['HTTP_USER_AGENT'] ?? '');

                // Session füllen
                $_SESSION[$sessionKey] = [
                    'username' => $user['username'],
                    'user_id'  => $user['id'],
                    'role'     => $user['role'] ?? 'admin'
                ];

                header("Location: dashboard.php");
                exit();
            } else {
                // LOGIN FEHLGESCHLAGEN
                $newAttempts = $attempts + 1;
                $pdo->prepare("INSERT INTO `{$table_prefix}login_attempts` (ip, attempts, last_attempt)
                               VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE attempts = ?, last_attempt = ?")
                    ->execute([$ip, $newAttempts, time(), $newAttempts, time()]);
                $error = "Ungültige Zugangsdaten.";
            }
        } catch (PDOException $e) {
            error_log('Login DB error: ' . $e->getMessage());
            $error = "Ein interner Fehler ist aufgetreten. Bitte erneut versuchen.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?= htmlspecialchars($site_name ?? 'Inventar') ?></title>
    
    <link rel="stylesheet" href="../../css/base.css">
    
    <link id="theme-css" rel="stylesheet" href="../../css/themes/clean.css">

    <script>
        // Prüfen, ob der User ein anderes Theme bevorzugt
        const prefix = "<?= isset($table_prefix) ? htmlspecialchars($table_prefix) : 'default' ?>";
        const savedTheme = localStorage.getItem('inventory_theme_' + prefix);
        
        if (savedTheme && savedTheme !== 'clean') {
            // Theme CSS Datei austauschen
            document.getElementById('theme-css').href = '../../css/themes/' + savedTheme + '.css';
        }
    </script>
</head>
<body class="flex-center" style="min-height: 100vh;">
    
    <div class="glass-panel" style="padding: 2.5rem; width: 90%; max-width: 460px;">

        <div class="text-center" style="margin-bottom: 2rem;">
            <h1 class="text-primary" style="margin-bottom: 0.5rem;">📦 <?= htmlspecialchars($site_name ?? 'Inventar') ?></h1>
            <p class="text-muted">Bitte anmelden</p>
        </div>

        <?php if ($error): ?><div class="alert alert-error text-center"><?= htmlspecialchars($error) ?></div><?php endif; ?>

        <form method="post">
            <div class="form-group" style="margin-bottom: 1.5rem;">
                <input type="text" name="username" placeholder="Benutzername" required autofocus autocomplete="username">
            </div>

            <div class="form-group" style="margin-bottom: 2rem;">
                <input type="password" name="password" placeholder="Passwort" required autocomplete="current-password">
            </div>

            <div class="flex-row gap-2">
                <a href="../../index.php" class="btn btn-secondary" style="flex:1; text-align:center;">Zurück</a>
                <button type="submit" class="btn" style="flex:1;">Anmelden</button>
            </div>
        </form>
    </div>
</body>
</html>