<?php
// core/locations_cats.php
ob_start();
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/db.php';

$msgSuccess = [];
$msgError = [];

// Name der Haupttabelle für den Import
$sourceTableName = $table_prefix . 'inventory';

// =================================================================================
// 1. LOGIK: IMPORT AUS INVENTAR (SYNC)
// =================================================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msgError[] = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
    } else {
    
    // A. Kategorien importieren
    if (isset($_POST['import_cats'])) {
        try {
            $sql = "INSERT IGNORE INTO `{$table_prefix}categories` (name)
                    SELECT DISTINCT category 
                    FROM `{$sourceTableName}` 
                    WHERE category IS NOT NULL 
                    AND category != ''";
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute();
            $count = $stmt->rowCount();
            if($count > 0) {
                $msgSuccess[] = "$count neue Kategorien aus dem Inventar übernommen.";
            } else {
                $msgSuccess[] = "Kategorien sind bereits synchron.";
            }
        } catch (PDOException $e) {
            $msgError[] = "Fehler: " . $e->getMessage();
        }
    }

    // B. Standorte importieren
    if (isset($_POST['import_locs'])) {
        try {
            $sql = "INSERT IGNORE INTO `{$table_prefix}locations` (name)
                    SELECT DISTINCT location 
                    FROM `{$sourceTableName}` 
                    WHERE location IS NOT NULL 
                    AND location != ''";
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute();
            $count = $stmt->rowCount();
            if($count > 0) {
                $msgSuccess[] = "$count neue Standorte aus dem Inventar übernommen.";
            } else {
                $msgSuccess[] = "Standorte sind bereits synchron.";
            }
        } catch (PDOException $e) {
            $msgError[] = "Fehler: " . $e->getMessage();
        }
    }

    // =============================================================================
    // 2. LOGIK: MANUELLES HINZUFÜGEN / LÖSCHEN
    // =============================================================================
    
    // Kategorie
    if (isset($_POST['add_cat']) && !empty($_POST['new_cat'])) {
        $pdo->prepare("INSERT IGNORE INTO `{$table_prefix}categories` (name) VALUES (?)")->execute([trim($_POST['new_cat'])]);
    }
    if (isset($_POST['del_cat'])) {
        $pdo->prepare("DELETE FROM `{$table_prefix}categories` WHERE id = ?")->execute([$_POST['del_id']]);
    }
    
    // Standort
    if (isset($_POST['add_loc']) && !empty($_POST['new_loc'])) {
        $pdo->prepare("INSERT IGNORE INTO `{$table_prefix}locations` (name) VALUES (?)")->execute([trim($_POST['new_loc'])]);
    }
    if (isset($_POST['del_loc'])) {
        $pdo->prepare("DELETE FROM `{$table_prefix}locations` WHERE id = ?")->execute([$_POST['del_id']]);
    }

    // Ausscheidungsgrund
    if (isset($_POST['add_reason']) && !empty($_POST['new_reason'])) {
        $pdo->prepare("INSERT IGNORE INTO `{$table_prefix}disposal_reasons` (reason) VALUES (?)")->execute([trim($_POST['new_reason'])]);
    }
    if (isset($_POST['del_reason'])) {
        $pdo->prepare("DELETE FROM `{$table_prefix}disposal_reasons` WHERE id = ?")->execute([$_POST['del_id']]);
    }
    } // Ende CSRF-Schutz
}

// =================================================================================
// 3. SORTIERUNG VORBEREITEN
// =================================================================================

// Kategorien Sortierung
$sort_c = $_GET['sort_c'] ?? 'asc';
$order_c = ($sort_c === 'desc') ? 'DESC' : 'ASC';
$next_sort_c = ($sort_c === 'asc') ? 'desc' : 'asc';
$arrow_c = ($sort_c === 'asc') ? '⬇ A-Z' : '⬆ Z-A';

// Standorte Sortierung
$sort_l = $_GET['sort_l'] ?? 'asc';
$order_l = ($sort_l === 'desc') ? 'DESC' : 'ASC';
$next_sort_l = ($sort_l === 'asc') ? 'desc' : 'asc';
$arrow_l = ($sort_l === 'asc') ? '⬇ A-Z' : '⬆ Z-A';

// Daten laden
$cats = $pdo->query("SELECT * FROM `{$table_prefix}categories` ORDER BY name $order_c")->fetchAll();
$locs = $pdo->query("SELECT * FROM `{$table_prefix}locations` ORDER BY name $order_l")->fetchAll();
$reasons = $pdo->query("SELECT * FROM `{$table_prefix}disposal_reasons` ORDER BY reason ASC")->fetchAll();

$pageTitle = "Stammdaten";
require_once __DIR__ . '/header.php';
?>

<div class="container">
    
    <?php if ($msgSuccess) echo '<div class="alert alert-success alert-simple">'.implode('<br>', $msgSuccess).'</div>'; ?>
    <?php if ($msgError) echo '<div class="alert alert-error alert-simple">'.implode('<br>', $msgError).'</div>'; ?>

    <div class="glass-panel" style="display: flex; flex-direction: column; align-items: center; text-align: center; border-left: 4px solid var(--info);">
        <h3 class="text-primary" style="margin-bottom: 0.5rem;">🔄 Datenabgleich</h3>
        <p class="text-muted" style="margin-bottom: 1.5rem; font-size: 0.9rem;">
            Findet Kategorien und Standorte, die im Inventar verwendet werden, aber hier fehlen.
        </p>
        
        <div class="flex-row gap-4 flex-wrap justify-center">
            <form method="POST">
                <?= csrfField() ?>
                <button type="submit" name="import_cats" class="btn btn-secondary">
                    📂 Kategorien importieren
                </button>
            </form>

            <form method="POST">
                <?= csrfField() ?>
                <button type="submit" name="import_locs" class="btn btn-secondary">
                    📍 Standorte importieren
                </button>
            </form>
        </div>
    </div>

    <div class="dashboard-grid" style="align-items: start;">
        
        <div class="glass-panel">
            <div class="flex-between" style="margin-bottom: 1rem; border-bottom: 1px solid var(--glass-border); padding-bottom: 0.5rem;">
                <h2 class="text-primary" style="margin:0;">Kategorien</h2>
                <a href="?sort_c=<?= $next_sort_c ?>&sort_l=<?= $sort_l ?>" class="btn btn-sm btn-secondary" style="font-size: 0.7rem;">
                    <?= $arrow_c ?>
                </a>
            </div>
            
            <div class="scroll-list" style="max-height: 300px; overflow-y: auto; margin: 1rem 0;">
                <?php if(count($cats) > 0): ?>
                    <?php foreach($cats as $c): ?>
                        <div class="flex-between" style="padding: 6px; border-bottom: 1px solid var(--glass-border);">
                            <span><?= h($c['name']) ?></span>
                            <form method="POST" style="margin:0;">
                                <?= csrfField() ?>
                                <input type="hidden" name="del_cat" value="1">
                                <input type="hidden" name="del_id" value="<?= $c['id'] ?>">
                                <button class="btn btn-danger btn-sm" onclick="return confirm('Löschen?')">X</button>
                            </form>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="text-muted text-center" style="padding: 1rem;">Leer</div>
                <?php endif; ?>
            </div>
            
            <form method="POST" class="flex-row gap-2">
                <?= csrfField() ?>
                <input type="text" name="new_cat" placeholder="Neu..." required>
                <button name="add_cat" class="btn">+</button>
            </form>
        </div>

        <div class="glass-panel">
            <div class="flex-between" style="margin-bottom: 1rem; border-bottom: 1px solid var(--glass-border); padding-bottom: 0.5rem;">
                <h2 class="text-primary" style="margin:0;">Standorte</h2>
                <a href="?sort_l=<?= $next_sort_l ?>&sort_c=<?= $sort_c ?>" class="btn btn-sm btn-secondary" style="font-size: 0.7rem;">
                    <?= $arrow_l ?>
                </a>
            </div>

            <div class="scroll-list" style="max-height: 300px; overflow-y: auto; margin: 1rem 0;">
                <?php if(count($locs) > 0): ?>
                    <?php foreach($locs as $l): ?>
                        <div class="flex-between" style="padding: 6px; border-bottom: 1px solid var(--glass-border);">
                            <span><?= h($l['name']) ?></span>
                            <form method="POST" style="margin:0;">
                                <?= csrfField() ?>
                                <input type="hidden" name="del_loc" value="1">
                                <input type="hidden" name="del_id" value="<?= $l['id'] ?>">
                                <button class="btn btn-danger btn-sm" onclick="return confirm('Löschen?')">X</button>
                            </form>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="text-muted text-center" style="padding: 1rem;">Leer</div>
                <?php endif; ?>
            </div>
            
            <form method="POST" class="flex-row gap-2">
                <?= csrfField() ?>
                <input type="text" name="new_loc" placeholder="Neu..." required>
                <button name="add_loc" class="btn">+</button>
            </form>
        </div>

        <div class="glass-panel">
            <h2 class="text-danger text-center" style="margin-bottom: 1rem; border-bottom: 1px solid var(--glass-border); padding-bottom: 0.5rem;">
                Gründe (Ausbuchung)
            </h2>
            <div class="scroll-list" style="max-height: 300px; overflow-y: auto; margin: 1rem 0;">
                <?php foreach($reasons as $r): ?>
                    <div class="flex-between" style="padding: 6px; border-bottom: 1px solid var(--glass-border);">
                        <span><?= h($r['reason']) ?></span>
                        <form method="POST" style="margin:0;">
                            <?= csrfField() ?>
                            <input type="hidden" name="del_reason" value="1">
                            <input type="hidden" name="del_id" value="<?= $r['id'] ?>">
                            <button class="btn btn-danger btn-sm" onclick="return confirm('Löschen?')">X</button>
                        </form>
                    </div>
                <?php endforeach; ?>
            </div>
            <form method="POST" class="flex-row gap-2">
                <?= csrfField() ?>
                <input type="text" name="new_reason" placeholder="Neu..." required>
                <button name="add_reason" class="btn">+</button>
            </form>
        </div>

    </div>
</div>
<?php require_once __DIR__ . '/footer.php'; ?>