<?php
// core/inventur.php
ob_start();
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/db.php';

$msg = "";
$msgClass = "";

$stmtLoc = $pdo->query("SELECT name FROM `{$table_prefix}locations` ORDER BY name ASC");
$locations = $stmtLoc->fetchAll(PDO::FETCH_COLUMN);

// --- LOGIK: MASSEN-VERSCHIEBUNG ---
if (isset($_POST['move_missing_to_unknown']) && isset($_SESSION['inventur_room'])) {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msg = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
        $msgClass = "alert-error";
    } else {
    $currentRoom = $_SESSION['inventur_room'];
    $targetLoc   = "Unbekannter Standort"; 
    
    $stmtCheckLoc = $pdo->prepare("SELECT id FROM `{$table_prefix}locations` WHERE name = ?");
    $stmtCheckLoc->execute([$targetLoc]);
    if (!$stmtCheckLoc->fetch()) {
        $pdo->prepare("INSERT INTO `{$table_prefix}locations` (name) VALUES (?)")->execute([$targetLoc]);
    }

    $stmtRoom = $pdo->prepare("SELECT id, barcode FROM `{$table_prefix}inventory` WHERE location = ? AND status = 'active'");
    $stmtRoom->execute([$currentRoom]);
    $allItems = $stmtRoom->fetchAll(PDO::FETCH_ASSOC);
    
    $movedCount = 0;
    $scannedItems = $_SESSION['inventur_scanned'] ?? [];

    $pdo->beginTransaction();
    try {
        $updateStmt = $pdo->prepare("UPDATE `{$table_prefix}inventory` SET location = ? WHERE id = ?");
        $histStmt   = $pdo->prepare("INSERT INTO `{$table_prefix}history` (inventory_id, user_id, username, action, old_value, new_value, created_at) VALUES (?, ?, ?, 'lost_inventory', ?, ?, NOW())");

        foreach ($allItems as $item) {
            if (!in_array($item['barcode'], $scannedItems)) {
                $updateStmt->execute([$targetLoc, $item['id']]);
                $histStmt->execute([$item['id'], $currentUserId, $currentUser, $currentRoom, $targetLoc]);
                $movedCount++;
            }
        }
        $pdo->commit();
        $msg = "$movedCount nicht gefundene Artikel wurden nach '<b>$targetLoc</b>' verschoben.";
        $msgClass = "alert-success";
        header("Refresh:0"); 
    } catch (Exception $e) {
        $pdo->rollBack();
        $msg = "Fehler: " . $e->getMessage();
        $msgClass = "alert-error";
    }
    } // Ende CSRF-Schutz
}

// --- SITZUNG STEUERN ---
if (isset($_GET['reset'])) {
    unset($_SESSION['inventur_room']);
    unset($_SESSION['inventur_scanned']);
    header("Location: inventur.php");
    exit();
}

if (isset($_POST['set_room'])) {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msg = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
        $msgClass = "alert-error";
    } else {
    $selectedRoom = trim($_POST['room']);
    if (in_array($selectedRoom, $locations)) {
        $_SESSION['inventur_room'] = $selectedRoom;
        if (!isset($_SESSION['inventur_scanned'])) {
            $_SESSION['inventur_scanned'] = [];
        }
    } else {
        $msg = "Ungültiger Standort.";
        $msgClass = "alert-error";
    }
    } // Ende CSRF-Schutz
}

// SCAN LOGIK
if (isset($_SESSION['inventur_room']) && isset($_POST['barcode'])) {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msg = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
        $msgClass = "alert-error";
    } else {
    $rawInput = trim($_POST['barcode']);
    $rawInput = preg_replace('/[\t\n\r\s]+/', ',', $rawInput); 
    
    $currentRoom = $_SESSION['inventur_room'];
    
    if (!empty($rawInput)) {
        $barcodeList = explode(',', $rawInput);
        $countSuccess = 0;
        $errors = [];
        $wrongLocation = [];  // NEU: Artikel am falschen Ort
        
        $stmtCheck = $pdo->prepare("SELECT id, item_name, location, status FROM `{$table_prefix}inventory` WHERE barcode = ?");
        $updateDate = $pdo->prepare("UPDATE `{$table_prefix}inventory` SET last_stocktake = NOW() WHERE id = ?");

        foreach($barcodeList as $code) {
            $code = trim($code);
            if(empty($code)) continue;

            if (($_POST['remove_zeros'] ?? '1') === '1') {
                $code = preg_replace('/0000$/', '', $code);
            }

            $stmtCheck->execute([$code]);
            $item = $stmtCheck->fetch();

            if ($item) {
                if ($item['status'] !== 'active') {
                     $errors[] = "$code ist ausgeschieden!";
                } else {
                    if ($item['location'] === $currentRoom) {
                        if (!in_array($code, $_SESSION['inventur_scanned'])) {
                            $_SESSION['inventur_scanned'][] = $code;
                            $updateDate->execute([$item['id']]);
                            $countSuccess++;
                        }
                    } else {
                        // NEU: Falscher Standort - zur Liste hinzufügen
                        $wrongLocation[] = [
                            'barcode' => $code,
                            'item_name' => $item['item_name'],
                            'old_location' => $item['location'],
                            'id' => $item['id']
                        ];
                    }
                }
            } else {
                $errors[] = "Unbekannt: $code";
            }
        }

        if($countSuccess > 0) {
            $msg = "<b>$countSuccess</b> Artikel erfolgreich erfasst.";
            $msgClass = "alert-success";
        }
        
        // NEU: Falsche Standorte speichern für Abfrage
        if (!empty($wrongLocation)) {
            $_SESSION['inventur_wrong_location'] = $wrongLocation;
        }
        
        if(!empty($errors)) {
            $errorStr = implode('<br>', array_slice($errors, 0, 5));
            if(count($errors) > 5) $errorStr .= "<br>...und ".(count($errors)-5)." weitere.";
            if($countSuccess > 0) {
                $msg .= "<br><br>⚠️ Warnungen:<br>" . $errorStr;
            } else {
                $msg = "Keine Artikel erfasst.<br>" . $errorStr;
                $msgClass = "alert-error";
            }
        }
    }
    } // Ende CSRF-Schutz
}

// NEU: Standort-Verschiebung bestätigen
if (isset($_POST['confirm_move']) && isset($_SESSION['inventur_wrong_location'])) {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msg = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
        $msgClass = "alert-error";
    } else {
    $wrongItems = $_SESSION['inventur_wrong_location'];
    $currentRoom = $_SESSION['inventur_room'];
    $movedCount = 0;
    
    $pdo->beginTransaction();
    try {
        $updateStmt = $pdo->prepare("UPDATE `{$table_prefix}inventory` SET location = ?, last_stocktake = NOW() WHERE id = ?");
        $histStmt = $pdo->prepare("INSERT INTO `{$table_prefix}history` (inventory_id, user_id, username, action, old_value, new_value, created_at) VALUES (?, ?, ?, 'move', ?, ?, NOW())");
        $updateDateStmt = $pdo->prepare("UPDATE `{$table_prefix}inventory` SET last_stocktake = NOW() WHERE id = ?");
        
        foreach ($wrongItems as $item) {
            $itemId = $item['id'];
            
            // Prüfen ob User "verschieben" gewählt hat
            if (isset($_POST['move_' . $itemId])) {
                // Verschieben
                $updateStmt->execute([$currentRoom, $itemId]);
                $histStmt->execute([$itemId, $currentUserId, $currentUser, $item['old_location'], $currentRoom]);
                $_SESSION['inventur_scanned'][] = $item['barcode'];
                $movedCount++;
            } else {
                // Ignorieren - nur Datum aktualisieren
                $updateDateStmt->execute([$itemId]);
            }
        }
        
        $pdo->commit();
        unset($_SESSION['inventur_wrong_location']);
        
        if ($movedCount > 0) {
            $msg = "<b>$movedCount</b> Artikel hierher verschoben.";
            $msgClass = "alert-success";
        } else {
            $msg = "Keine Artikel verschoben. Inventurdatum wurde aktualisiert.";
            $msgClass = "alert-info";
        }
    } catch (Exception $e) {
        $pdo->rollBack();
        $msg = "Fehler: " . $e->getMessage();
        $msgClass = "alert-error";
    }
    } // Ende CSRF-Schutz
}

// NEU: Abbrechen
if (isset($_POST['cancel_move'])) {
    unset($_SESSION['inventur_wrong_location']);
    $msg = "Vorgang abgebrochen.";
    $msgClass = "alert-info";
}

$pageTitle = "Inventur";
require_once __DIR__ . '/header.php';

$missingItems = [];
$totalItemsInRoom = 0;
$scannedCount = 0;

if (isset($_SESSION['inventur_room'])) {
    $stmtRoom = $pdo->prepare("SELECT barcode, item_name FROM `{$table_prefix}inventory` WHERE location = ? AND status = 'active' ORDER BY item_name ASC");
    $stmtRoom->execute([$_SESSION['inventur_room']]);
    $dbItems = $stmtRoom->fetchAll(PDO::FETCH_ASSOC);
    
    $totalItemsInRoom = count($dbItems);
    $scannedCount = count($_SESSION['inventur_scanned'] ?? []);
    
    foreach ($dbItems as $dbItem) {
        if (!in_array($dbItem['barcode'], $_SESSION['inventur_scanned'] ?? [])) {
            $missingItems[] = $dbItem;
        }
    }
}
?>

<div class="container container-form">
    <?php if (!empty($msg)): ?><div class="alert <?= $msgClass ?> alert-simple"><?= $msg ?></div><?php endif; ?>

    <?php if (!isset($_SESSION['inventur_room'])): ?>
        <div class="glass-panel" style="border-top: 4px solid var(--primary);">
            <h2 class="text-center text-primary" style="margin-bottom: 2rem; border-bottom: 1px solid var(--glass-border); padding-bottom: 1rem;">Inventur starten</h2>
            <form method="POST">
                <?= csrfField() ?>
                <div class="form-group">
                    <label>Welchen Raum möchten Sie prüfen?</label>
                    <select name="room" required style="width: 100%; font-size: 1.1rem; padding: 0.8rem;">
                        <option value="">-- Standort wählen --</option>
                        <?php foreach($locations as $l): ?>
                            <option value="<?= h($l) ?>"><?= h($l) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <button type="submit" name="set_room" class="btn btn-block" style="margin-top: 1.5rem;">Starten</button>
            </form>
        </div>
    <?php else: ?>
        <div class="glass-panel" style="border-top: 4px solid var(--success);">
            <div class="flex-between" style="border-bottom: 1px solid var(--glass-border); padding-bottom: 10px; margin-bottom: 20px;">
                <h2 style="margin:0;">Raum: <span style="color: var(--success);"><?= h($_SESSION['inventur_room']) ?></span></h2>
                <a href="?reset=1" class="btn btn-secondary btn-sm">Wechseln</a>
            </div>

            <div style="margin-bottom: 20px; text-align: center;">
                <div style="font-size: 2.5rem; font-weight: bold; color: var(--success); line-height: 1;">
                    <?= $scannedCount ?> <span style="font-size: 1.5rem; color: var(--text-muted);">/ <?= $totalItemsInRoom ?></span>
                </div>
                <div class="text-muted">Artikel gefunden</div>
                <?php $percent = $totalItemsInRoom > 0 ? round(($scannedCount / $totalItemsInRoom) * 100) : 0; ?>
                <div style="background: var(--glass-border); height: 10px; border-radius: 5px; margin-top: 10px; overflow: hidden;">
                    <div style="background: var(--success); width: <?= $percent ?>%; height: 100%; transition: width 0.3s;"></div>
                </div>
            </div>
            
            <form method="POST" id="inventurForm" style="margin-bottom: 2rem;">
                <?= csrfField() ?>
                <input type="hidden" name="remove_zeros" id="removeZerosInput" value="1">
                <div class="form-group">
                    <label>Barcode scannen (Massen-Erfassung)</label>
                    <textarea name="barcode" id="barcodeInput" autofocus autocomplete="off" rows="3"
                           placeholder="Scan..." class="font-mono" style="font-size: 1.2rem; padding: 10px;"></textarea>
                    <p class="text-muted" id="barcodeHint" style="font-size: 0.75rem; margin-top: 0.25rem;"></p>
                </div>
                <button type="submit" class="btn btn-block">Erfassen</button>
            </form>

            <?php // NEU: Dialog für falsche Standorte ?>
            <?php if (isset($_SESSION['inventur_wrong_location']) && !empty($_SESSION['inventur_wrong_location'])): ?>
                <div class="glass-panel" style="background: var(--warning-bg, #fff3cd); border: 2px solid var(--warning, #ffc107); margin-bottom: 2rem;">
                    <h3 style="margin-top: 0; color: var(--warning, #ffc107);">⚠️ Artikel am falschen Standort (<?= count($_SESSION['inventur_wrong_location']) ?>)</h3>
                    <p style="margin-bottom: 1rem;">Diese Artikel gehören in einen anderen Raum. Was möchten Sie tun?</p>
                    
                    <form method="POST">
                        <?= csrfField() ?>
                        <div class="table-wrapper" style="margin-bottom: 1rem; border: 1px solid var(--glass-border); border-radius: 8px; max-height: 300px; overflow-y: auto;">
                            <table style="font-size: 0.9rem;">
                                <thead style="position: sticky; top: 0; background: var(--glass-bg); z-index: 1;">
                                    <tr>
                                        <th>Barcode</th>
                                        <th>Gegenstand</th>
                                        <th>Alter Standort</th>
                                        <th style="text-align: center; width: 150px;">Hierher verschieben?</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($_SESSION['inventur_wrong_location'] as $item): ?>
                                    <tr>
                                        <td class="font-mono text-primary"><?= h($item['barcode']) ?></td>
                                        <td><?= h($item['item_name']) ?></td>
                                        <td><span style="background: var(--danger-bg, #fee); padding: 2px 6px; border-radius: 4px;"><?= h($item['old_location']) ?></span></td>
                                        <td style="text-align: center;">
                                            <input type="checkbox" name="move_<?= $item['id'] ?>" value="1" checked style="width: 20px; height: 20px; cursor: pointer;">
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="grid-2" style="gap: 10px;">
                            <button type="submit" name="confirm_move" class="btn btn-primary">Bestätigen & Verschieben</button>
                            <button type="submit" name="cancel_move" class="btn btn-secondary">Abbrechen</button>
                        </div>
                        
                        <p class="text-muted" style="font-size: 0.85rem; margin-top: 1rem; margin-bottom: 0;">
                            <strong>Hinweis:</strong> Ausgewählte Artikel werden nach "<?= h($_SESSION['inventur_room']) ?>" verschoben. Nicht ausgewählte bleiben am alten Standort (nur Inventurdatum wird aktualisiert).
                        </p>
                    </form>
                </div>
            <?php endif; ?>

            <?php if (!empty($missingItems)): ?>
                <div style="border-top: 1px solid var(--glass-border); padding-top: 1rem;">
                    <h3 class="text-danger" style="margin-bottom: 1rem;">Fehlende Artikel (<?= count($missingItems) ?>):</h3>
                    <div class="table-wrapper" style="max-height: 300px; overflow-y: auto; margin-bottom: 20px; border: 1px solid var(--glass-border); border-radius: 8px;">
                        <table style="font-size: 0.9rem;">
                            <thead style="position: sticky; top: 0; background: var(--glass-bg); z-index: 1;">
                                <tr><th>Barcode</th><th>Gegenstand</th><th style="width: 50px;"></th></tr>
                            </thead>
                            <tbody>
                                <?php foreach ($missingItems as $m): ?>
                                <tr>
                                    <td class="font-mono text-primary"><?= h($m['barcode']) ?></td>
                                    <td><?= h($m['item_name']) ?></td>
                                    <td><button type="button" onclick="manualScan('<?= h($m['barcode']) ?>')" class="btn btn-sm btn-secondary">✔</button></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div style="text-align: center;">
                        <form method="POST" onsubmit="return confirm('Sicher?');">
                            <?= csrfField() ?>
                            <button type="submit" name="move_missing_to_unknown" class="btn btn-danger btn-block">⚠️ Restliche auf "Unbekannt" setzen</button>
                        </form>
                    </div>
                </div>
            <?php elseif ($totalItemsInRoom > 0): ?>
                <div class="alert alert-success" style="margin-top: 20px; text-align: center; font-weight: bold;">✅ Inventur für diesen Raum vollständig!</div>
                <div class="text-center"><a href="?reset=1" class="btn btn-primary">Nächsten Raum wählen</a></div>
            <?php else: ?>
                 <div class="text-center text-muted" style="padding: 2rem;">Dieser Raum ist leer.</div>
            <?php endif; ?>
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const removeZeros = getBarcodeRemoveZeros();
                document.getElementById('removeZerosInput').value = removeZeros ? '1' : '0';
                const hint = document.getElementById('barcodeHint');
                if (hint) hint.textContent = removeZeros
                    ? '(Drücken Sie "Erfassen", wenn fertig. 0000 am Ende werden entfernt.)'
                    : '(Drücken Sie "Erfassen", wenn fertig. Nullen werden NICHT entfernt.)';
                const input = document.getElementById('barcodeInput');
                if(input) {
                    input.focus();
                    input.addEventListener('blur', () => { setTimeout(() => input.focus(), 10); });
                    input.addEventListener('keydown', (e) => {
                        if (e.key === 'Tab' || e.key === 'Enter') {
                            e.preventDefault();
                            let start = input.selectionStart; 
                            let end = input.selectionEnd; 
                            let val = input.value;
                            
                            let before = val.substring(0, start);
                            let after = val.substring(end);
                            
                            // NEU: Nutze globale cleanBarcode Funktion
                            before = cleanBarcode(before);
                            
                            input.value = before + "," + after;
                            input.selectionStart = input.selectionEnd = before.length + 1;
                        }
                    });
                }
            });
            function manualScan(code) {
                const input = document.getElementById('barcodeInput');
                input.value = code;
                document.getElementById('inventurForm').submit();
            }
        </script>
    <?php endif; ?>
</div>
<?php require_once __DIR__ . '/footer.php'; ?>