<?php
// core/install.php
$msg = "";
$error = "";
// Prefix kommt aus der URL (wird vom Hub übergeben)
$suggestedPrefix = $_GET['prefix'] ?? 'inv_'; 

// Standard-Werte für Footer Formular - LEER lassen!
$defaultFooterText = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $host   = trim($_POST['host']);
    $dbname = trim($_POST['dbname']);
    $user   = trim($_POST['user']);
    $pass   = trim($_POST['pass']);
    $prefix = trim($_POST['prefix']);
    $siteName = trim($_POST['sitename']);
    
    $adminUser = trim($_POST['admin_user']);
    $adminPass = $_POST['admin_pass'] ?? '';
    
    // Initiale Daten aus den Textareas
    $initLocs = trim($_POST['init_locations']);
    $initCats = trim($_POST['init_categories']);

    // Footer Daten
    $footer_show = isset($_POST['footer_show']) ? 'true' : 'false';
    $footer_text = trim($_POST['footer_text']);
    
    // HIER GEÄNDERT: Links komplett leer gelassen
    $footer_links = '';

    if (empty($host) || empty($dbname) || empty($user) || empty($adminUser) || empty($adminPass)) {
        $error = "Bitte alle Pflichtfelder ausfüllen.";
    } else {
        try {
            $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            // --- 1. TABELLEN ERSTELLEN (ENGLISCH) ---
            
            // USERS
            $pdo->exec("CREATE TABLE IF NOT EXISTS `{$prefix}users` (
                `id` INT AUTO_INCREMENT PRIMARY KEY,
                `username` VARCHAR(50) NOT NULL UNIQUE,
                `password` VARCHAR(255) NOT NULL,
                `role` VARCHAR(20) DEFAULT 'admin',
                `last_login` DATETIME NULL DEFAULT NULL,
                `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

            // CATEGORIES
            $pdo->exec("CREATE TABLE IF NOT EXISTS `{$prefix}categories` (
                `id` INT AUTO_INCREMENT PRIMARY KEY,
                `name` VARCHAR(100) NOT NULL UNIQUE
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

            // LOCATIONS
            $pdo->exec("CREATE TABLE IF NOT EXISTS `{$prefix}locations` (
                `id` INT AUTO_INCREMENT PRIMARY KEY,
                `name` VARCHAR(100) NOT NULL UNIQUE
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

            // DISPOSAL REASONS
            $pdo->exec("CREATE TABLE IF NOT EXISTS `{$prefix}disposal_reasons` (
                `id` INT AUTO_INCREMENT PRIMARY KEY,
                `reason` VARCHAR(100) NOT NULL UNIQUE
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

            // INVENTORY
            $pdo->exec("CREATE TABLE IF NOT EXISTS `{$prefix}inventory` (
                `id` INT AUTO_INCREMENT PRIMARY KEY,
                `barcode` VARCHAR(100) NOT NULL UNIQUE,
                `item_name` VARCHAR(255) NOT NULL,
                `category` VARCHAR(100),
                `location` VARCHAR(100),
                `notes` TEXT,
                `status` ENUM('active', 'disposed') DEFAULT 'active',
                `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                `created_by` VARCHAR(50),
                `last_stocktake` TIMESTAMP NULL DEFAULT NULL
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

            // HISTORY
            $pdo->exec("CREATE TABLE IF NOT EXISTS `{$prefix}history` (
                `id` INT AUTO_INCREMENT PRIMARY KEY,
                `inventory_id` INT NOT NULL,
                `user_id` INT DEFAULT NULL,
                `username` VARCHAR(50),
                `action` VARCHAR(50) NOT NULL,
                `old_value` TEXT,
                `new_value` TEXT,
                `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                INDEX (`inventory_id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

            // LOGIN ATTEMPTS (IP-basiertes Rate-Limiting)
            $pdo->exec("CREATE TABLE IF NOT EXISTS `{$prefix}login_attempts` (
                `ip` VARCHAR(45) NOT NULL,
                `attempts` INT DEFAULT 0,
                `last_attempt` INT DEFAULT 0,
                PRIMARY KEY (`ip`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

            // --- 2. USER ANLEGEN ---
            $stmtCheck = $pdo->prepare("SELECT id FROM `{$prefix}users` WHERE username = ?");
            $stmtCheck->execute([$adminUser]);
            if ($stmtCheck->fetch()) {
                $stmt = $pdo->prepare("UPDATE `{$prefix}users` SET password = ? WHERE username = ?");
                $stmt->execute([password_hash($adminPass, PASSWORD_DEFAULT), $adminUser]);
            } else {
                $stmt = $pdo->prepare("INSERT INTO `{$prefix}users` (username, password, role) VALUES (?, ?, 'admin')");
                $stmt->execute([$adminUser, password_hash($adminPass, PASSWORD_DEFAULT)]);
            }

            // --- 3. STAMMDATEN IMPORTIEREN ---
            if(!empty($initLocs)) {
                $stmtLoc = $pdo->prepare("INSERT IGNORE INTO `{$prefix}locations` (name) VALUES (?)");
                foreach(explode("\n", $initLocs) as $line) { if(trim($line)) $stmtLoc->execute([trim($line)]); }
            }
            if(!empty($initCats)) {
                $stmtCat = $pdo->prepare("INSERT IGNORE INTO `{$prefix}categories` (name) VALUES (?)");
                foreach(explode("\n", $initCats) as $line) { if(trim($line)) $stmtCat->execute([trim($line)]); }
            }
            
            // Standard-Ausscheidungsgründe anlegen
            $defaultReasons = ["Defekt / Kaputt", "Veraltet / Elektroschrott", "Verkauft", "Verloren / Gestohlen", "Rückgabe"];
            $stmtReason = $pdo->prepare("INSERT IGNORE INTO `{$prefix}disposal_reasons` (reason) VALUES (?)");
            foreach($defaultReasons as $r) { $stmtReason->execute([$r]); }

            // --- 4. CONFIG SCHREIBEN ---
            $configContent = "<?php\n";
            $configContent .= "// Instanz-Konfiguration\n";
            $configContent .= "define('DB_HOST', '".addslashes($host)."');\n";
            $configContent .= "define('DB_NAME', '".addslashes($dbname)."');\n";
            $configContent .= "define('DB_USER', '".addslashes($user)."');\n";
            $configContent .= "define('DB_PASS', '".addslashes($pass)."');\n\n";
            $configContent .= "\$table_prefix = '".addslashes($prefix)."';\n";
            $configContent .= "\$site_name = '".addslashes($siteName)."';\n\n";

            // NEU: Footer Config
            $configContent .= "// Footer Konfiguration\n";
            $configContent .= "define('FOOTER_SHOW', " . $footer_show . ");\n";
            $configContent .= "define('FOOTER_TEXT', '" . addslashes($footer_text) . "');\n";
            $configContent .= "define('FOOTER_LINKS', '" . addslashes($footer_links) . "');\n";
            
            if (file_put_contents('config.php', $configContent)) {
                
                // --- 5. WRAPPER-DATEIEN ERSTELLEN ---
                $wrapperFiles = [
                    'dashboard.php' => 'dashboard.php',
                    'dispose.php' => 'dispose.php',
                    'edit.php' => 'edit.php',
                    'import_export.php' => 'import_export.php',
                    'index.php' => 'index.php',
                    'inventur.php' => 'inventur.php',
                    'list.php' => 'list.php',
                    'locations_cats.php' => 'locations_cats.php',
                    'login.php' => 'login.php',
                    'logout.php' => 'logout.php',
                    'manage.php' => 'manage.php',
                    'move.php' => 'move.php',
                    'report.php' => 'report.php',
                    'report_export.php' => 'report_export.php',  // NEU!
                    'scan.php' => 'scan.php',
                    'themes.php' => 'themes.php',
                    'users.php' => 'users.php',
                    'manifest.php' => 'manifest.php',
                    'sw.php' => 'sw.php'
                ];
                
                // Nur fehlende Dateien erstellen
                foreach ($wrapperFiles as $localFile => $coreFile) {
                    if (!file_exists($localFile)) {
                        $wrapperContent = "<?php\n";
                        $wrapperContent .= "define('INSTANCE_DIR', __DIR__);\n";
                        $wrapperContent .= "require_once '../../core/$coreFile';\n";
                        file_put_contents($localFile, $wrapperContent);
                    }
                }
                
                // Weiterleitung zum Login der neuen Instanz
                header("Location: login.php?msg=installed");
                exit();
            } else {
                $error = "Konnte config.php nicht schreiben.";
            }

        } catch (PDOException $e) {
            $error = "DB Fehler: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation</title>
    <link rel="stylesheet" href="../../css/base.css"> 
    
    <style>
        /* FIX: Variablen manuell setzen, da noch kein Theme geladen werden kann */
        :root {
            --bg-body: #f8fafc;
            --text-main: #0f172a;
            --text-muted: #64748b;
            --glass-bg: #ffffff;
            --glass-border: #cbd5e1;
            --glass-shadow: 0 4px 6px -1px rgba(0,0,0,0.1);
            --input-bg: #ffffff;
            --input-text: #0f172a;
            --input-border: #94a3b8; /* Sichtbarer Rahmen */
            --primary: #7c3aed;
            --danger: #ef4444;
            --backdrop-blur: 0px;
        }

        /* Inputs explizit stylen, damit sie sichtbar sind */
        input, textarea, select {
            border: 1px solid var(--input-border) !important;
            background-color: var(--input-bg) !important;
            color: var(--input-text) !important;
        }

        .password-wrapper { position: relative; display: flex; align-items: center; }
        .password-wrapper input { padding-right: 40px; }
        .toggle-password { position: absolute; right: 10px; cursor: pointer; color: var(--text-muted); }
        .checkbox-wrapper { display: flex; align-items: center; gap: 10px; margin-bottom: 1rem; }
    </style>
    
    <script>
        // Light Mode als Default bei Installation
        document.documentElement.setAttribute('data-theme', 'light');

        function togglePass(inputId) {
            const input = document.getElementById(inputId);
            input.type = input.type === "password" ? "text" : "password";
        }

        function toggleFooterFields(checkbox) {
            const fields = document.getElementById('footerFields');
            fields.style.display = checkbox.checked ? 'block' : 'none';
        }
    </script>
</head>
<body class="flex-center" style="min-height: 100vh;">
    
    <div class="glass-panel container-narrow" style="width: 100%; margin: 2rem;">
        <h1 class="text-center text-primary" style="margin-bottom: 2rem;">🚀 Inventar Setup (Core)</h1>
        
        <?php if($error): ?><div class="alert alert-error"><?= htmlspecialchars($error) ?></div><?php endif; ?>

        <form method="POST">
            <h3 class="text-muted uppercase font-bold" style="margin-bottom: 1rem; border-bottom: 1px solid var(--glass-border); padding-bottom: 5px;">1. Datenbank</h3>
            <div class="grid-2">
                <input type="text" name="host" placeholder="Host (z.B. localhost)" value="localhost" required>
                <input type="text" name="dbname" placeholder="DB Name" required>
                <input type="text" name="user" placeholder="DB User" required>
                <div class="password-wrapper">
                    <input type="password" name="pass" id="db_pass" placeholder="DB Passwort">
                    <span class="toggle-password" onclick="togglePass('db_pass')">👁️</span>
                </div>
            </div>
            
            <div class="form-group" style="margin-top: 1rem;">
                <label style="font-size: 0.8rem; color: var(--text-muted);">Tabellen-Präfix</label>
                <input type="text" name="prefix" value="<?= htmlspecialchars($suggestedPrefix) ?>" required class="font-mono">
            </div>

            <h3 class="text-muted uppercase font-bold" style="margin-top: 2rem; margin-bottom: 1rem; border-bottom: 1px solid var(--glass-border); padding-bottom: 5px;">2. Admin</h3>
            <div class="form-group">
                <input type="text" name="sitename" placeholder="Titel (z.B. IT Lager)" required>
            </div>
            <div class="grid-2">
                <input type="text" name="admin_user" placeholder="Admin Username" required>
                <div class="password-wrapper">
                    <input type="password" name="admin_pass" id="admin_pass" placeholder="Admin Passwort" required>
                    <span class="toggle-password" onclick="togglePass('admin_pass')">👁️</span>
                </div>
            </div>

            <h3 class="text-muted uppercase font-bold" style="margin-top: 2rem; margin-bottom: 1rem; border-bottom: 1px solid var(--glass-border); padding-bottom: 5px;">3. Erste Daten</h3>
            <div class="grid-2">
                <div>
                    <label>Standorte</label>
                    <textarea name="init_locations" rows="4">Lager
Büro</textarea>
                </div>
                <div>
                    <label>Kategorien</label>
                    <textarea name="init_categories" rows="4">Hardware
Möbel</textarea>
                </div>
            </div>

            <h3 class="text-muted uppercase font-bold" style="margin-top: 2rem; margin-bottom: 1rem; border-bottom: 1px solid var(--glass-border); padding-bottom: 5px;">4. Footer / Branding</h3>
            
            <div class="checkbox-wrapper">
                <input type="checkbox" name="footer_show" id="footer_show" value="1" checked onchange="toggleFooterFields(this)">
                <label for="footer_show">Footer anzeigen</label>
            </div>

            <div id="footerFields">
                <div class="form-group">
                    <label style="font-size: 0.8rem;">Anzeige-Text (Copyright)</label>
                    <input type="text" name="footer_text" value="<?= htmlspecialchars($defaultFooterText) ?>" placeholder="z.B. IT Abteilung">
                </div>
            </div>

            <button type="submit" class="btn btn-block" style="margin-top: 2rem; padding: 1rem;">Installation abschließen</button>
        </form>
    </div>
</body>
</html>