<?php
// core/import_export.php
ob_start();
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/db.php';

$msgSuccess = [];
$msgError = [];

// =================================================================
// NOTFALL-REPARATUR: STATUS FIXEN
// =================================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['fix_all_active'])) {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msgError[] = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
    } else {
    try {
        // Setzt ALLES auf active, was nicht gelöscht ist.
        $sql = "UPDATE `{$table_prefix}inventory` SET status = 'active'";
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        $count = $stmt->rowCount();
        
        $msgSuccess[] = "Reparatur erfolgreich: Status von <b>$count</b> Einträgen auf 'Active' gesetzt.";
    } catch (Exception $e) {
        $msgError[] = "Fehler: " . $e->getMessage();
    }
    } // Ende CSRF-Schutz
}

// =================================================================
// A. EXPORT LOGIK
// =================================================================
if (isset($_POST['export_target'])) {
    $target = $_POST['export_target']; 
    $tableName = ($target === 'history') ? $table_prefix . 'history' : $table_prefix . 'inventory';
    $filename = "backup_" . $target . "_" . date('Y-m-d_H-i') . ".csv";
    
    ob_end_clean();
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    
    $output = fopen('php://output', 'w');
    fputs($output, "\xEF\xBB\xBF"); // UTF-8 BOM

    try {
        $stmt = $pdo->query("SELECT * FROM `$tableName` LIMIT 0");
        $headers = [];
        for ($i = 0; $i < $stmt->columnCount(); $i++) {
            $headers[] = $stmt->getColumnMeta($i)['name'];
        }
        fputcsv($output, $headers, ';');
        
        $stmtData = $pdo->query("SELECT * FROM `$tableName`");
        while ($row = $stmtData->fetch(PDO::FETCH_ASSOC)) {
            fputcsv($output, $row, ';');
        }
    } catch (Exception $e) { exit; }
    
    fclose($output);
    exit();
}

// =================================================================
// B. IMPORT LOGIK
// =================================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['import_file'])) {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msgError[] = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
    } else {
    $target = $_POST['import_target'] ?? 'inventory';
    $tableName = ($target === 'history') ? $table_prefix . 'history' : $table_prefix . 'inventory';
    $useSmartImport = ($target === 'inventory');
    $truncate = isset($_POST['truncate_table']);
    $file = $_FILES['import_file']['tmp_name'];

    // MAPPING
    $columnMap = [
        'barcode' => 'barcode',
        'bezeichnung' => 'item_name', 'item_name' => 'item_name',
        'kategorie' => 'category', 'category' => 'category',
        'standort' => 'location', 'location' => 'location',
        'status' => 'status',
        'anmerkung' => 'notes', 'notes' => 'notes',
        'created_at' => 'created_at', 'erstellt am' => 'created_at',
        'last_inventur' => 'last_stocktake', 'last_stocktake' => 'last_stocktake', 'letzte inventur' => 'last_stocktake',
        'created_by' => 'created_by', 'erstellt von' => 'created_by'
    ];

    if (is_uploaded_file($file)) {
        $handle = fopen($file, "r");
        try {
            $line1 = fgets($handle); rewind($handle);
            $delimiter = (substr_count($line1, ';') >= substr_count($line1, ',')) ? ';' : ',';

            $rawHeaders = fgetcsv($handle, 0, $delimiter); 
            if (!$rawHeaders) throw new Exception("CSV ungültig oder leer.");
            $rawHeaders[0] = preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $rawHeaders[0]);

            $dbColumns = []; $csvIndexMap = []; 

            if ($useSmartImport) {
                foreach ($rawHeaders as $index => $h) {
                    $hClean = strtolower(trim($h));
                    if (isset($columnMap[$hClean])) {
                        $dbColumns[] = $columnMap[$hClean];
                        $csvIndexMap[] = $index;
                    }
                }
                if (empty($dbColumns)) throw new Exception("Keine passenden Spalten gefunden.");
            } else {
                $dbColumns = array_map('trim', $rawHeaders);
                $csvIndexMap = array_keys($rawHeaders);
            }

            $pdo->exec("SET FOREIGN_KEY_CHECKS=0");
            if ($truncate) $pdo->exec("TRUNCATE TABLE `$tableName`");
            $pdo->beginTransaction();
            
            $stmtAddCat = $pdo->prepare("INSERT IGNORE INTO `{$table_prefix}categories` (name) VALUES (?)");
            $stmtAddLoc = $pdo->prepare("INSERT IGNORE INTO `{$table_prefix}locations` (name) VALUES (?)");

            $colString = implode(", ", array_map(function($c){ return "`$c`"; }, $dbColumns));
            $valPlaceholders = implode(", ", array_fill(0, count($dbColumns), "?"));
            $stmt = $pdo->prepare("INSERT IGNORE INTO `$tableName` ($colString) VALUES ($valPlaceholders)");

            $rows = 0;
            while (($data = fgetcsv($handle, 0, $delimiter)) !== FALSE) {
                if (count($data) < 1) continue;
                $insertValues = [];
                $catVal = null; $locVal = null;

                foreach ($csvIndexMap as $k => $idx) {
                    $val = trim($data[$idx] ?? '');
                    $targetCol = $dbColumns[$k];

                    if ($useSmartImport) {
                        if (preg_match('/^\d{2}\.\d{2}\.\d{4}/', $val)) {
                            try { $val = (new DateTime($val))->format('Y-m-d H:i:s'); } catch(Exception $e) {}
                        }
                        if ($val === '' && in_array($targetCol, ['created_at', 'last_stocktake'])) $val = null;
                        if ($targetCol === 'category') $catVal = $val;
                        if ($targetCol === 'location') $locVal = $val;
                    }
                    $insertValues[] = $val;
                }

                if (count($insertValues) === count($dbColumns)) {
                    if ($catVal) $stmtAddCat->execute([$catVal]);
                    if ($locVal) $stmtAddLoc->execute([$locVal]);
                    $stmt->execute($insertValues);
                    if ($stmt->rowCount() > 0) $rows++;
                }
            }
            $pdo->commit();
            $msgSuccess[] = "$rows Datensätze in <b>$target</b> importiert.";
        } catch (Exception $e) {
            if ($pdo->inTransaction()) $pdo->rollBack();
            $msgError[] = "Fehler: " . $e->getMessage();
        }
        $pdo->exec("SET FOREIGN_KEY_CHECKS=1");
        fclose($handle);
    } else {
        $msgError[] = "Upload fehlgeschlagen.";
    }
    } // Ende CSRF-Schutz
}

$pageTitle = "Backup & Restore";
require_once __DIR__ . '/header.php';
?>

<div class="container container-narrow">
    
    <?php if ($msgSuccess) echo '<div class="alert alert-success alert-simple">'.implode('<br>', $msgSuccess).'</div>'; ?>
    <?php if ($msgError) echo '<div class="alert alert-error alert-simple">'.implode('<br>', $msgError).'</div>'; ?>

    <div class="glass-panel text-center" style="margin-bottom: 2rem;">
        <h1>Backup & Wiederherstellung</h1>
    </div>

    <div class="grid-2">
        <div class="glass-panel">
            <h2 class="text-primary text-center" style="margin-bottom: 1.5rem; border-bottom: 1px solid var(--glass-border); padding-bottom: 0.5rem;">📦 Inventar</h2>
            <form method="POST" style="margin-bottom: 2rem;">
                <?= csrfField() ?>
                <input type="hidden" name="export_target" value="inventory">
                <button type="submit" class="btn btn-block btn-purple">Exportieren (CSV)</button>
            </form>
            <form method="POST" enctype="multipart/form-data">
                <?= csrfField() ?>
                <input type="hidden" name="import_target" value="inventory">
                <div style="margin-bottom: 1rem;">
                    <input type="file" name="import_file" id="inv_file_input" accept=".csv" required style="width: 100%; padding: 10px; border: 1px dashed var(--glass-border); border-radius: 8px;" onchange="previewCsv(this, 'inv_preview')">
                </div>
                <div id="inv_preview" style="display:none; margin-bottom: 1rem; overflow-x: auto; font-size: 0.8rem; max-height: 200px; overflow-y: auto;"></div>
                <div class="alert alert-error alert-simple" style="padding: 10px; display: flex; align-items: center; gap: 10px;">
                    <input type="checkbox" name="truncate_table" value="1" style="width: 18px; height: 18px; accent-color: var(--danger);">
                    <span class="text-danger font-bold" style="font-size: 0.9rem;">Vorher alles löschen?</span>
                </div>
                <button type="submit" class="btn btn-secondary btn-block">Importieren</button>
            </form>
        </div>

        <div class="glass-panel">
            <h2 class="text-center" style="margin-bottom: 1.5rem; border-bottom: 1px solid var(--glass-border); padding-bottom: 0.5rem; color: #a855f7;">📜 Historie</h2>
            <form method="POST" style="margin-bottom: 2rem;">
                <?= csrfField() ?>
                <input type="hidden" name="export_target" value="history">
                <button type="submit" class="btn btn-block btn-purple" style="background-color: #a855f7;">Exportieren (CSV)</button>
            </form>
            <form method="POST" enctype="multipart/form-data">
                <?= csrfField() ?>
                <input type="hidden" name="import_target" value="history">
                <div style="margin-bottom: 1rem;">
                    <input type="file" name="import_file" id="hist_file_input" accept=".csv" required style="width: 100%; padding: 10px; border: 1px dashed var(--glass-border); border-radius: 8px;" onchange="previewCsv(this, 'hist_preview')">
                </div>
                <div id="hist_preview" style="display:none; margin-bottom: 1rem; overflow-x: auto; font-size: 0.8rem; max-height: 200px; overflow-y: auto;"></div>
                <div class="alert alert-error alert-simple" style="padding: 10px; display: flex; align-items: center; gap: 10px;">
                    <input type="checkbox" name="truncate_table" value="1" style="width: 18px; height: 18px; accent-color: var(--danger);">
                    <span class="text-danger font-bold" style="font-size: 0.9rem;">Historie löschen?</span>
                </div>
                <button type="submit" class="btn btn-secondary btn-block">Importieren</button>
            </form>
        </div>
    </div>

    <div class="glass-panel" style="margin-top: 2rem; border-top: 4px solid var(--warning);">
        <h3 class="text-warning text-center">🔧 Datenbank Reparatur</h3>
        <p class="text-center text-muted" style="margin-bottom: 1rem;">
            Falls der Status beim Import verloren gegangen ist (Artikel werden nicht angezeigt):
        </p>
        <form method="POST" onsubmit="return confirm('Sicher? JEDER Artikel im System wird auf den Status ACTIVE gesetzt (auch ausgeschiedene).');">
            <?= csrfField() ?>
            <button type="submit" name="fix_all_active" class="btn btn-block" style="background-color: var(--warning); color: #000 !important;">
                Alle Items auf 'Aktiv' setzen
            </button>
        </form>
    </div>

</div>
<script>
function previewCsv(input, previewId) {
    const preview = document.getElementById(previewId);
    if (!input.files[0]) { preview.style.display = 'none'; return; }
    const reader = new FileReader();
    reader.onload = function(e) {
        const text = e.target.result;
        const lines = text.split(/\r?\n/).filter(l => l.trim());
        if (lines.length === 0) { preview.style.display = 'none'; return; }
        const delim = (lines[0].split(';').length >= lines[0].split(',').length) ? ';' : ',';
        const rows = lines.slice(0, 6).map(l => l.split(delim).map(c => c.replace(/^"|"$/g, '').trim()));
        let html = '<table style="width:100%; border-collapse:collapse; background: var(--glass-bg);">';
        rows.forEach((row, i) => {
            html += '<tr>' + row.map(cell =>
                i === 0
                    ? `<th style="border:1px solid var(--glass-border); padding:4px 6px; background:var(--primary); color:white; white-space:nowrap;">${cell}</th>`
                    : `<td style="border:1px solid var(--glass-border); padding:4px 6px; white-space:nowrap; max-width:120px; overflow:hidden; text-overflow:ellipsis;" title="${cell}">${cell}</td>`
            ).join('') + '</tr>';
        });
        const total = lines.length - 1;
        html += '</table>';
        if (total > 5) html += `<p class="text-muted" style="margin:4px 0 0; font-size:0.75rem;">… und ${total - 5} weitere Zeilen (${total} gesamt)</p>`;
        preview.innerHTML = html;
        preview.style.display = 'block';
    };
    reader.readAsText(input.files[0], 'UTF-8');
}
</script>
<?php require_once __DIR__ . '/footer.php'; ?>