<?php
// core/header.php
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// Seitentitel Fallback
$pageTitle = $pageTitle ?? $site_name ?? 'Inventar';

// PWA: Stubs auto-erstellen falls noch nicht vorhanden (für bestehende Instanzen)
if (defined('INSTANCE_DIR')) {
    foreach (['manifest.php', 'sw.php'] as $_pwaStub) {
        $_pwaPath = INSTANCE_DIR . '/' . $_pwaStub;
        if (!file_exists($_pwaPath)) {
            file_put_contents($_pwaPath, "<?php\ndefine('INSTANCE_DIR', __DIR__);\nrequire_once '../../core/$_pwaStub';\n");
        }
    }
    unset($_pwaStub, $_pwaPath);
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    <title><?= h($pageTitle) ?></title>
    <meta name="theme-color" content="#7c3aed">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="<?= h($site_name ?? 'Inventar') ?>">
    <link rel="manifest" href="manifest.php">
    <link rel="apple-touch-icon" href="../../css/icon.svg">

<link rel="stylesheet" href="../../css/base.css?v=<?= time() ?>">
<link id="theme-css" rel="stylesheet" href="../../css/themes/clean.css?v=<?= time() ?>">

    <script>
        // Prefix für LocalStorage Key (damit verschiedene Instanzen getrennte Designs haben können)
        const prefix = "<?= isset($table_prefix) ? h($table_prefix) : 'default' ?>";
        const themeKey = 'inventory_theme_' + prefix;
        const barcodeKey = 'inventory_remove_zeros_' + prefix;  // NEU: Barcode-Einstellung

        // Gespeichertes Theme laden oder Default (Clean)
        const savedTheme = localStorage.getItem(themeKey) || 'clean';
        
        // CSS Link sofort anpassen, bevor die Seite rendert (verhindert weißes Flackern bei Dark Mode)
        const themeLink = document.getElementById('theme-css');
        themeLink.href = '../../css/themes/' + savedTheme + '.css';

        // Globale Funktion zum Setzen des Themes (wird von themes.php genutzt)
        function setTheme(mode) {
            document.getElementById('theme-css').href = '../../css/themes/' + mode + '.css';
            localStorage.setItem(themeKey, mode);
        }
        
        // NEU: Barcode-Einstellung (Standard: true = 0000 entfernen)
        function getBarcodeRemoveZeros() {
            const saved = localStorage.getItem(barcodeKey);
            return saved === null ? true : saved === 'true';
        }
        
        function setBarcodeRemoveZeros(remove) {
            localStorage.setItem(barcodeKey, remove ? 'true' : 'false');
        }
        
        // Globale Funktion zum Bereinigen von Barcodes
        function cleanBarcode(code) {
            if (getBarcodeRemoveZeros() && code.endsWith('0000')) {
                return code.slice(0, -4);
            }
            return code;
        }

        // Barcode in Zwischenablage kopieren (visuelles Feedback via Outline)
        function copyBarcode(el) {
            navigator.clipboard.writeText(el.textContent.trim()).then(() => {
                el.style.outline = '2px solid var(--success)';
                setTimeout(() => el.style.outline = '', 700);
            }).catch(() => {});
        }

        // PWA Service Worker registrieren
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', () => {
                navigator.serviceWorker.register('sw.php').catch(() => {});
            });
        }
    </script>
</head>
<body>

<?php 
// Navigation anzeigen, außer $noNav ist auf true gesetzt (z.B. Login, Druckansicht)
if(!isset($noNav) || $noNav !== true): 
?>
<nav class="glass-panel navbar no-print">
    
    <div style="display: flex; align-items: center; gap: 1rem;">
        <!-- Hub-Link mit klarerem Icon -->
        <a href="../../index.php" title="Zum Inventar Hub" style="text-decoration: none; font-size: 1.3rem; display: flex; align-items: center;">
            🏢
        </a>
        
        <!-- Trenner -->
        <div style="width: 1px; height: 24px; background: var(--glass-border); opacity: 0.5;"></div>
        
        <!-- Instanz-Name mit Dashboard-Icon -->
        <a href="index.php" title="Zum Dashboard" style="text-decoration: none; color: var(--text-main); font-weight: bold; font-size: 1.1rem; display: flex; align-items: center; gap: 0.5rem;">
            <span style="font-size: 1.2rem;">📊</span>
            <span><?= h($site_name ?? 'Inventar') ?></span>
        </a>
    </div>
    
    <div style="display: flex; gap: 0.5rem; align-items: center;">
        
        <!-- Angemeldeter User -->
        <span class="text-muted" style="font-size: 0.9rem; margin-right: 0.5rem;">
            👤 <?= h($currentUser) ?>
        </span>
        
        <a href="manage.php" class="btn" style="padding: 0.5rem; font-size: 0.9rem;" title="Einstellungen">⚙️</a>
        
        <a href="logout.php" class="btn btn-danger" style="padding: 0.5rem; font-size: 0.9rem;" title="Logout">Logout</a>
    </div>
</nav>
<?php endif; ?>