<?php
// core/functions.php

/**
 * HTML-Escaping Helper (kurz für htmlspecialchars)
 */
function h($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}

/**
 * URL Builder für Parameter
 */
function buildUrl($newParams = []) {
    $params = $_GET;
    foreach ($newParams as $k => $v) $params[$k] = $v;
    return '?' . http_build_query($params);
}

/**
 * Prüft, ob ein String mit einem Substring beginnt (für Router Logik)
 */
function startsWith($haystack, $needle) {
    return substr($haystack, 0, strlen($needle)) === $needle;
}

/**
 * CSRF-Token generieren und in Session speichern
 * @return string Das CSRF-Token
 */
function generateCSRF() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

/**
 * CSRF-Token validieren
 * @param string $token Das zu prüfende Token
 * @return bool True wenn gültig, sonst false
 */
function validateCSRF($token) {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

/**
 * CSRF-Token als Hidden Input ausgeben
 * @return string HTML Input-Feld
 */
function csrfField() {
    return '<input type="hidden" name="csrf_token" value="' . h(generateCSRF()) . '">';
}
?>