<?php
// core/footer.php

// --- 1. CONFIG & WHITE-LABELING LOGIK ---
// Prüfen, ob Konstanten definiert sind (aus config.php), sonst Standardwerte nutzen
$showFooter  = defined('FOOTER_SHOW') ? FOOTER_SHOW : true;
$footerText  = defined('FOOTER_TEXT') ? FOOTER_TEXT : '';
$footerLinks = defined('FOOTER_LINKS') ? FOOTER_LINKS : '<a href="https://www.it-wil.at/impressum">Impressum</a><span>|</span><a href="https://www.it-wil.at/datenschutz">Datenschutz</a>';
?>

<?php if ($showFooter): ?>
<footer class="main-footer no-print">
    <div class="footer-content">
        <?= $footerText ?> | &copy; <?= date("Y") ?>
    </div>
    <?php if (!empty($footerLinks)): ?>
    <div class="footer-links">
        <?= $footerLinks ?>
    </div>
    <?php endif; ?>
</footer>
<?php endif; ?>

<script>
    // 1. Modal Logic (Öffnen/Schließen)
    function openModal(id) {
        const el = document.getElementById(id);
        if(el) el.classList.add('active');
    }

    function closeModal(id) {
        const el = document.getElementById(id);
        if(el) el.classList.remove('active');
    }

    // UX-Feature: Modal schließen, wenn man daneben klickt (auf den dunklen Hintergrund)
    window.onclick = function(event) {
        if (event.target.classList.contains('modal')) {
            event.target.classList.remove('active');
        }
    }

    // 2. Theme Toggle Logic (Damit der Darkmode überall funktioniert)
    function toggleTheme() {
        const html = document.documentElement;
        const next = html.getAttribute('data-theme') === 'light' ? 'dark' : 'light';
        html.setAttribute('data-theme', next);
        localStorage.setItem('hub_theme', next);
    }
</script>

</body>
</html>