<?php
// core/edit.php
ob_start();
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/db.php';

$msgSuccess = [];
$msgError = [];

if (!isset($_GET['id']) || empty($_GET['id'])) { header("Location: list.php"); exit(); }
$id = (int)$_GET['id'];

$stmt = $pdo->prepare("SELECT * FROM `{$table_prefix}inventory` WHERE id = ?");
$stmt->execute([$id]);
$item = $stmt->fetch();
if (!$item) die("Datensatz nicht gefunden.");

// Stammdaten laden
$stmtCat = $pdo->query("SELECT name FROM `{$table_prefix}categories` ORDER BY name ASC");
$categories = $stmtCat->fetchAll(PDO::FETCH_COLUMN);

$stmtLoc = $pdo->query("SELECT name FROM `{$table_prefix}locations` ORDER BY name ASC");
$locations = $stmtLoc->fetchAll(PDO::FETCH_COLUMN);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msgError[] = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
    } else {
    $barcode     = trim($_POST['barcode']);
    $itemName    = trim($_POST['item_name']);
    $category    = trim($_POST['category']);
    $location    = trim($_POST['location']);
    $status      = trim($_POST['status']);
    $created_at  = trim($_POST['created_at']); 
    $notes       = trim($_POST['notes']);

    if (empty($barcode) || empty($itemName)) {
        $msgError[] = "Barcode und Bezeichnung sind Pflicht.";
    } else {
        if (!empty($category) && !in_array($category, $categories)) {
            $msgError[] = "Kategorie ungültig.";
        }
        if (!empty($location) && !in_array($location, $locations)) {
            $msgError[] = "Standort ungültig.";
        }

        if (empty($msgError)) {
            $checkStmt = $pdo->prepare("SELECT id FROM `{$table_prefix}inventory` WHERE barcode = ? AND id != ?");
            $checkStmt->execute([$barcode, $id]);
            
            if ($checkStmt->fetch()) {
                $msgError[] = "Barcode $barcode ist vergeben.";
            } else {
                $dbDate = str_replace('T', ' ', $created_at);
                if(strlen($dbDate) == 16) $dbDate .= ':00';

                $changeLog = "Manuelle Bearbeitung";
                if ($item['location'] !== $location) $changeLog = "Verschoben nach: $location (Edit)";

                $sql = "UPDATE `{$table_prefix}inventory` SET barcode = ?, item_name = ?, category = ?, location = ?, status = ?, created_at = ?, notes = ? WHERE id = ?";
                $updateStmt = $pdo->prepare($sql);
                $updateStmt->execute([$barcode, $itemName, $category, $location, $status, $dbDate, $notes, $id]);
                
                $histStmt = $pdo->prepare("INSERT INTO `{$table_prefix}history` (inventory_id, user_id, username, action, new_value) VALUES (?, ?, ?, 'edit', ?)");
                $histStmt->execute([$id, $currentUserId, $currentUser, $changeLog]);
                
                $msgSuccess[] = "Änderungen gespeichert.";
                
                // Reload
                $stmt->execute([$id]); 
                $item = $stmt->fetch();
            }
        }
    }
    } // Ende CSRF-Schutz
}

$dateValue = date('Y-m-d\TH:i', strtotime($item['created_at']));
$pageTitle = "Bearbeiten: " . $item['barcode'];
require_once __DIR__ . '/header.php';
?>

<div class="container container-form">
    <?php if ($msgSuccess) echo '<div class="alert alert-success">'.implode('<br>', $msgSuccess).'</div>'; ?>
    <?php if ($msgError) echo '<div class="alert alert-error">'.implode('<br>', $msgError).'</div>'; ?>

    <div class="glass-panel">
        <div class="flex-between" style="border-bottom: 1px solid var(--glass-border); padding-bottom: 1rem; margin-bottom: 1.5rem;">
            <h2 style="margin:0;">Bearbeiten</h2>
            <a href="list.php" class="btn btn-secondary btn-sm">Zurück zur Liste</a>
        </div>

        <form method="POST">
            <?= csrfField() ?>
            <div class="flex-col gap-4">
                <div class="form-group">
                    <label>Barcode</label>
                    <input type="text" name="barcode" value="<?= h($item['barcode']) ?>" required class="font-mono text-primary font-bold">
                </div>
                
                <div class="form-group">
                    <label>Bezeichnung</label>
                    <input type="text" name="item_name" value="<?= h($item['item_name']) ?>" required>
                </div>
                
                <div class="grid-2">
                    <div class="form-group">
                        <label>Kategorie</label>
                        <select name="category" required style="width: 100%;">
                            <option value="">-- Wählen --</option>
                            <?php foreach($categories as $c): ?>
                                <option value="<?= h($c) ?>" <?= ($item['category'] == $c) ? 'selected' : '' ?>><?= h($c) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Standort</label>
                        <select name="location" required style="width: 100%;">
                            <option value="">-- Wählen --</option>
                            <?php foreach($locations as $l): ?>
                                <option value="<?= h($l) ?>" <?= ($item['location'] == $l) ? 'selected' : '' ?>><?= h($l) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <div class="grid-2">
                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" style="width: 100%;">
                            <option value="active" <?= $item['status']=='active'?'selected':'' ?>>Aktiv</option>
                            <option value="disposed" <?= $item['status']=='disposed'?'selected':'' ?>>Ausgeschieden</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Erstellt am</label>
                        <input type="datetime-local" name="created_at" value="<?= $dateValue ?>">
                    </div>
                </div>

                <div class="form-group">
                    <label>Anmerkung</label>
                    <textarea name="notes" rows="3"><?= h($item['notes']) ?></textarea>
                </div>

                <button type="submit" class="btn btn-block" style="padding: 1rem;">Speichern</button>
            </div>
        </form>
    </div>
</div>
<?php require_once __DIR__ . '/footer.php'; ?>