<?php
// core/dispose.php
ob_start();
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/db.php';

$msgSuccess = [];
$msgError = [];
$prefillValue = '';

$stmtReasons = $pdo->query("SELECT reason FROM `{$table_prefix}disposal_reasons` ORDER BY reason ASC");
$reasons = $stmtReasons->fetchAll(PDO::FETCH_COLUMN);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ids']) && is_array($_POST['ids'])) {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msgError[] = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
    } else {
    $ids = $_POST['ids'];
    $placeholders = str_repeat('?,', count($ids) - 1) . '?';
    try {
        $stmtGet = $pdo->prepare("SELECT barcode FROM `{$table_prefix}inventory` WHERE id IN ($placeholders)");
        $stmtGet->execute($ids);
        $codes = $stmtGet->fetchAll(PDO::FETCH_COLUMN);
        $prefillValue = implode(', ', $codes);
        if(count($codes) > 0) $msgSuccess[] = count($codes) . " Elemente vorgemerkt.";
    } catch (Exception $e) { $msgError[] = $e->getMessage(); }
    } // Ende CSRF-Schutz
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reason']) && isset($_POST['barcode'])) {
    // CSRF-Schutz
    if (!validateCSRF($_POST['csrf_token'] ?? '')) {
        $msgError[] = "Ungültige Anfrage. Bitte laden Sie die Seite neu.";
    } else {
    $rawInput = trim($_POST['barcode']);
    $rawInput = preg_replace('/[\t\n\r\s]+/', ',', $rawInput); 
    $reason   = trim($_POST['reason']);
    $prefillValue = $rawInput;

    if (empty($rawInput) || empty($reason)) {
        $msgError[] = "Bitte Barcode und Grund angeben.";
    } else {
        if (!in_array($reason, $reasons)) {
             $msgError[] = "Ungültiger Ausscheidungsgrund.";
        } else {
            $barcodesToProcess = [];
            $parts = explode(',', $rawInput);
            foreach ($parts as $part) {
                $part = trim($part);
                if(empty($part)) continue;
                if (($_POST['remove_zeros'] ?? '1') === '1') {
                    $part = preg_replace('/0000$/', '', $part);
                }

                if (strpos($part, '-') !== false) {
                     $range = explode('-', $part);
                     if (count($range) == 2 && is_numeric($range[0]) && is_numeric($range[1])) {
                         for ($i = min($range[0], $range[1]); $i <= max($range[0], $range[1]); $i++) $barcodesToProcess[] = (string)$i;
                     } else { $barcodesToProcess[] = $part; }
                } else { $barcodesToProcess[] = $part; }
            }

            $pdo->beginTransaction();
            try {
                $checkStmt = $pdo->prepare("SELECT id, status FROM `{$table_prefix}inventory` WHERE barcode = ?");
                $updateStmt = $pdo->prepare("UPDATE `{$table_prefix}inventory` SET status = 'disposed', notes = CONCAT(IFNULL(notes, ''), ' | Ausgeschieden: ', ?) WHERE id = ?");
                $histStmt = $pdo->prepare("INSERT INTO `{$table_prefix}history` (inventory_id, user_id, username, action, old_value, new_value) VALUES (?, ?, ?, 'dispose', 'active', ?)");
                
                $successCount = 0;
                foreach ($barcodesToProcess as $code) {
                    $checkStmt->execute([$code]);
                    $item = $checkStmt->fetch();
                    if (!$item || $item['status'] === 'disposed') continue;

                    $updateStmt->execute([$reason, $item['id']]);
                    $histVal = "Ausgeschieden. Grund: $reason";
                    $histStmt->execute([$item['id'], $currentUserId, $currentUser, $histVal]);
                    $successCount++;
                }
                $pdo->commit();
                if($successCount > 0) {
                    $msgSuccess[] = "$successCount Gegenstände ausgeschieden.";
                    $prefillValue = '';
                }
            } catch (Exception $e) { $pdo->rollBack(); $msgError[] = $e->getMessage(); }
        }
    }
    } // Ende CSRF-Schutz
}

$pageTitle = "Ausscheiden";
require_once __DIR__ . '/header.php';
?>

<div class="container container-form">
    <?php if ($msgSuccess) echo '<div class="alert alert-success">'.implode('<br>', $msgSuccess).'</div>'; ?>
    <?php if ($msgError) echo '<div class="alert alert-error">'.implode('<br>', $msgError).'</div>'; ?>

    <div class="glass-panel" style="border-top: 4px solid var(--danger);">
        <h2 class="text-center text-danger" style="margin-bottom: 1rem;">Inventar ausscheiden</h2>
        <p class="text-center text-muted" style="margin-bottom: 2rem;">Achtung: Status wird auf "ausgeschieden" gesetzt.</p>
        
        <form method="POST" class="mode-danger" style="margin-top: 2rem;">
            <?= csrfField() ?>
            <input type="hidden" name="remove_zeros" id="removeZerosInput" value="1">
            <div class="form-group">
                <label class="font-bold text-danger uppercase">Barcodes</label>
                <textarea name="barcode" id="barcodeInput" rows="3" required 
                       placeholder="Scan..." 
                       class="font-mono" style="font-size: 1.1rem; padding: 1rem;"><?= htmlspecialchars($prefillValue) ?></textarea>
                 <p class="text-muted" id="barcodeHint" style="font-size: 0.75rem; margin-top: 0.25rem;"></p>
            </div>

            <div class="form-group">
                <label>Grund</label>
                <select name="reason" required style="width: 100%;">
                    <option value="" disabled selected>Bitte wählen...</option>
                    <?php foreach ($reasons as $r): ?>
                        <option value="<?= h($r) ?>"><?= h($r) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <button type="submit" class="btn btn-danger btn-block" style="padding: 1rem; font-size: 1.1rem; margin-top: 2rem;">
                Endgültig ausscheiden
            </button>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const removeZeros = getBarcodeRemoveZeros();
        document.getElementById('removeZerosInput').value = removeZeros ? '1' : '0';
        const hint = document.getElementById('barcodeHint');
        if (hint) hint.textContent = removeZeros
            ? '(Scanner-Modus: 0000 am Ende werden entfernt.)'
            : '(Scanner-Modus: aktiv – Nullen werden NICHT entfernt.)';
        const input = document.getElementById('barcodeInput');
        if(input) {
            input.addEventListener('keydown', (e) => {
                if (e.key === 'Tab' || e.key === 'Enter') {
                    e.preventDefault();
                    let start = input.selectionStart; 
                    let end = input.selectionEnd; 
                    let val = input.value;
                    
                    let before = val.substring(0, start);
                    let after = val.substring(end);
                    
                    before = cleanBarcode(before);
                    
                    input.value = before + "," + after;
                    input.selectionStart = input.selectionEnd = before.length + 1;
                }
            });
        }
    });
</script>
<?php require_once __DIR__ . '/footer.php'; ?>