<?php
// core/db.php

// 1. Instanz-Konfiguration finden und laden
// Wir gehen davon aus, dass dieses Skript von einer Datei im Instanz-Ordner (z.B. inventar/edv/index.php) eingebunden wurde.
// Wenn INSTANCE_DIR definiert ist (machen wir gleich in den Stub-Files), nutzen wir das.
if (defined('INSTANCE_DIR')) {
    $configFile = INSTANCE_DIR . '/config.php';
} else {
    // Fallback: Versuchen, die Config relativ zu finden (../config.php ist unsicher, besser über Konstante)
    die("Fehler: System-Kontext nicht definiert. Bitte starten Sie über die Instanz.");
}

if (!file_exists($configFile)) {
    die("<h3>Konfigurationsdatei fehlt</h3><p>Bitte führen Sie die Installation für diese Instanz durch.</p>");
}

require_once $configFile;

// 2. Datenbank verbinden
try {
    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
    $pdo = new PDO($dsn, DB_USER, DB_PASS);
    
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);

    // Auto-Migration: login_attempts Tabelle für IP-basiertes Rate-Limiting
    $pdo->exec("CREATE TABLE IF NOT EXISTS `{$table_prefix}login_attempts` (
        `ip` VARCHAR(45) NOT NULL,
        `attempts` INT DEFAULT 0,
        `last_attempt` INT DEFAULT 0,
        PRIMARY KEY (`ip`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

    // Auto-Migration: last_login Spalte
    try {
        $pdo->exec("ALTER TABLE `{$table_prefix}users` ADD COLUMN `last_login` DATETIME NULL DEFAULT NULL");
    } catch (Exception $e) { /* Spalte existiert bereits */ }
} catch (PDOException $e) {
    error_log('DB connection error: ' . $e->getMessage());
    die("<h3>Datenbankfehler</h3><p>Verbindung fehlgeschlagen. Bitte Administrator kontaktieren.</p>");
}

// 3. Hilfsfunktionen laden
require_once __DIR__ . '/functions.php';
?>