<?php
// core/auth.php

// 0. PHP-Fehlerausgabe deaktivieren (PHP-FPM-kompatibel, ersetzt php_flag in .htaccess)
ini_set('display_errors', 0);
error_reporting(0);

// 1. Session starten, falls noch nicht geschehen
if (session_status() === PHP_SESSION_NONE) {
    $isHttps = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off';
    session_set_cookie_params([
        'httponly' => true,
        'samesite' => 'Strict',
        'secure'   => $isHttps,
    ]);
    session_start();
}

// 2. WICHTIG: Config laden, falls $table_prefix noch unbekannt ist.
// Ohne das prüft auth.php gegen "auth_default" statt "auth_dein_prefix_"
if (!isset($table_prefix)) {
    // Fall A: Wir sind in einer Instanz (definiert im Stub file)
    if (defined('INSTANCE_DIR') && file_exists(INSTANCE_DIR . '/config.php')) {
        require_once INSTANCE_DIR . '/config.php';
    }
    // Fall B: Fallback für direkten Aufruf oder Hub (falls nötig)
    elseif (file_exists(__DIR__ . '/../config.php')) {
        // Dies passiert nur, wenn config direkt im Parent liegt (alte Struktur)
        // require_once __DIR__ . '/../config.php'; 
    }
}

// 3. Session-Fingerprinting (Session-Hijacking-Schutz)
$fingerprint = hash('sha256', $_SERVER['HTTP_USER_AGENT'] ?? '');
if (isset($_SESSION['security_fingerprint'])) {
    if ($_SESSION['security_fingerprint'] !== $fingerprint) {
        // Session wurde von anderem Gerät/Browser verwendet -> Session zerstören
        session_unset();
        session_destroy();
        session_start();
        header("Location: login.php?error=session_invalid");
        exit();
    }
} else {
    // Fingerprint bei erster Session setzen
    $_SESSION['security_fingerprint'] = $fingerprint;
}

// 4. Session Key generieren (Muss EXAKT gleich sein wie in login.php)
$sessionKey = 'auth_' . ($table_prefix ?? 'default');

// 5. Prüfung: Ist der User eingeloggt?
if (!isset($_SESSION[$sessionKey])) {
    // Debugging (falls nötig, einkommentieren):
    // die("Nicht eingeloggt. Suche nach Key: $sessionKey");
    
    // Nicht eingeloggt -> Redirect zum Login
    header("Location: login.php");
    exit();
}

// 6. User Daten global bereitstellen (für Dashboard, Header etc.)
$currentUser     = $_SESSION[$sessionKey]['username'];
$currentUserId   = $_SESSION[$sessionKey]['user_id'];
$currentUserRole = $_SESSION[$sessionKey]['role'] ?? 'admin';
?>