<?php
/**
 * update_cron.php – Täglicher Versionscheck (BIB)
 *
 * Cron-URL (lima-city):
 *   https://www.DEINE-DOMAIN.at/bib/update/update_cron.php?token=DEIN_TOKEN
 *
 * Interval: täglich, z.B. 02:35
 *
 * Prüft auf neue Versionen und schreibt Ergebnis ins Log.
 * Installiert KEIN Update automatisch (CRON_AUTO_APPLY = false).
 *
 * WICHTIG: CRON_UPDATE_TOKEN vor Produktiveinsatz ändern!
 */

header('Content-Type: text/plain; charset=utf-8');

// ─── Token-Auth (wie reset_demo.php) ──────────────────────────────────────────
define('CRON_UPDATE_TOKEN', 'AENDERN_bib_cron_token_hier_zufaelligen_64_zeichen_token_eintragen');
define('CRON_AUTO_APPLY',   false);

$token = $_GET['token'] ?? $_SERVER['HTTP_X_UPDATE_TOKEN'] ?? '';
if (!hash_equals(CRON_UPDATE_TOKEN, $token)) {
    http_response_code(403);
    exit('Access denied.');
}

// ─── Init ──────────────────────────────────────────────────────────────────────
define('CRON_START', microtime(true));
set_time_limit(300);
ini_set('memory_limit', '128M');

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/Updater.php';

// ─── Lock ────────────────────────────────────────────────────────────────────
$lock_file = BIB_UPDATE_DIR . '/cron.lock';
$lock = fopen($lock_file, 'w');
if (!$lock || !flock($lock, LOCK_EX | LOCK_NB)) {
    Updater::log('Cron bereits aktiv – Abbruch.');
    exit('Cron bereits aktiv.' . PHP_EOL);
}

// ─── Versionscheck ────────────────────────────────────────────────────────────
try {
    global $pdo;

    Updater::log('=== Cron Update-Check gestartet ===');

    $installed = Updater::getInstalledVersion($pdo);
    $available = Updater::getAvailableUpdate($installed);

    if ($available === null) {
        $msg = "Kein Update verfügbar. Installierte Version: v{$installed}";
        Updater::log($msg);
        echo $msg . PHP_EOL;
    } else {
        $msg = "Update verfügbar: v{$available['version']} (installiert: v{$installed})";
        Updater::log($msg);
        echo $msg . PHP_EOL;

        if (CRON_AUTO_APPLY) {
            Updater::log('Auto-Apply aktiv: starte Update…');
            echo "Installiere v{$available['version']}…" . PHP_EOL;
            $result = Updater::applyUpdate($available, $pdo);
            if ($result['success']) {
                Updater::log("Auto-Update erfolgreich auf v{$available['version']}");
                echo "Update erfolgreich installiert." . PHP_EOL;
            } else {
                Updater::log("Auto-Update FEHLER: " . $result['error']);
                echo "FEHLER: " . $result['error'] . PHP_EOL;
            }
        } else {
            echo "Manuelles Update über Admin-Panel erforderlich." . PHP_EOL;
        }
    }

    $elapsed = round(microtime(true) - CRON_START, 2);
    Updater::log("=== Cron abgeschlossen in {$elapsed}s ===");
    echo "Laufzeit: {$elapsed}s" . PHP_EOL;

} catch (Throwable $e) {
    Updater::log('FEHLER im Cron: ' . $e->getMessage());
    echo 'FEHLER: ' . $e->getMessage() . PHP_EOL;
} finally {
    flock($lock, LOCK_UN);
    fclose($lock);
    @unlink($lock_file);
}
