<?php
/**
 * update_check.php – Versionscheck AJAX-Endpoint (BIB)
 *
 * Gibt JSON zurück mit:
 *   installed  – aktuell installierte Version
 *   available  – neue Version (null wenn aktuell)
 *   changelog  – Changelog-Text der neuen Version
 *   up_to_date – boolean
 *
 * Zugriff: nur für eingeloggte Administratoren
 */

header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/session.php';
require_once __DIR__ . '/../includes/auth.php';

// Auth-Prüfung: nur Admins
if (!is_admin()) {
    http_response_code(403);
    echo json_encode(['error' => 'Nicht autorisiert']);
    exit;
}

require_once __DIR__ . '/Updater.php';

try {
    global $pdo;

    $installed = Updater::getInstalledVersion($pdo);
    $available = Updater::getAvailableUpdate($installed);

    echo json_encode([
        'installed'  => $installed,
        'available'  => $available ? $available['version'] : null,
        'changelog'  => $available ? ($available['changelog'] ?? '') : null,
        'released'   => $available ? ($available['released'] ?? '') : null,
        'up_to_date' => $available === null,
    ]);

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Interner Fehler: ' . $e->getMessage()]);
}
