<?php
// Check if installation was actually completed
if (!isset($_SESSION['installation_complete'])) {
    header('Location: wizard.php?step=1');
    exit;
}
?>

<div class="text-center">
    <div class="mx-auto flex items-center justify-center h-20 w-20 rounded-full bg-green-100 mb-6">
        <svg class="h-12 w-12 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
        </svg>
    </div>
    
    <h2 class="text-3xl font-bold text-gray-900 mb-4">
        Installation erfolgreich abgeschlossen! 🎉
    </h2>
    
    <p class="text-lg text-gray-600 mb-8">
        Ihre Bibliotheksverwaltung ist jetzt einsatzbereit.
    </p>
</div>

<div class="bg-green-50 border-l-4 border-green-500 p-6 mb-6">
    <div class="flex">
        <div class="flex-shrink-0">
            <svg class="h-6 w-6 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
            </svg>
        </div>
        <div class="ml-3">
            <h3 class="text-sm font-medium text-green-800 mb-2">Erfolgreich erstellt:</h3>
            <div class="text-sm text-green-700 grid grid-cols-1 md:grid-cols-2 gap-2">
                <div>✓ 12 Datenbank-Tabellen</div>
                <div>✓ 3 Datenbank-Views</div>
                <div>✓ Automatische Trigger</div>
                <div>✓ 10 Bücherkategorien</div>
                <div>✓ 2 Benutzergruppen</div>
                <div>✓ Administrator-Konto</div>
                <div>✓ System-Einstellungen</div>
                <div>✓ Konfigurations-Datei</div>
            </div>
        </div>
    </div>
</div>

<div class="bg-white border-2 border-gray-200 rounded-lg p-6 mb-6">
    <h3 class="text-lg font-semibold text-gray-900 mb-4">📝 Ihre Zugangsdaten</h3>
    
    <div class="bg-gray-50 rounded-lg p-4 space-y-3">
        <div class="flex justify-between items-center">
            <span class="text-sm text-gray-600">Benutzername:</span>
            <code class="px-3 py-1 bg-white border border-gray-300 rounded font-mono text-sm">
                <?php echo htmlspecialchars($_SESSION['install_admin']['username'] ?? 'admin'); ?>
            </code>
        </div>
        
        <div class="flex justify-between items-center">
            <span class="text-sm text-gray-600">E-Mail:</span>
            <code class="px-3 py-1 bg-white border border-gray-300 rounded font-mono text-sm">
                <?php echo htmlspecialchars($_SESSION['install_admin']['email'] ?? ''); ?>
            </code>
        </div>
        
        <div class="flex justify-between items-center">
            <span class="text-sm text-gray-600">Passwort:</span>
            <code class="px-3 py-1 bg-white border border-gray-300 rounded font-mono text-sm">
                •••••••• (Ihr gewähltes Passwort)
            </code>
        </div>
    </div>
    
    <div class="mt-4 bg-yellow-50 border-l-4 border-yellow-400 p-3">
        <div class="flex">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                </svg>
            </div>
            <div class="ml-3">
                <p class="text-sm text-yellow-700">
                    <strong>Wichtig:</strong> Notieren Sie sich diese Zugangsdaten sicher! Sie benötigen diese für die erste Anmeldung.
                </p>
            </div>
        </div>
    </div>
</div>

<div class="bg-blue-50 border-l-4 border-blue-500 p-6 mb-8">
    <div class="flex">
        <div class="flex-shrink-0">
            <svg class="h-6 w-6 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
            </svg>
        </div>
        <div class="ml-3">
            <h3 class="text-sm font-medium text-blue-800 mb-2">Nächste Schritte:</h3>
            <ol class="text-sm text-blue-700 list-decimal list-inside space-y-2">
                <li>Melden Sie sich mit Ihren Administrator-Zugangsdaten an</li>
                <li>Ändern Sie Ihr Passwort (empfohlen) unter Einstellungen</li>
                <li>Konfigurieren Sie SMTP für Email-Versand (optional)</li>
                <li>Konfigurieren Sie LDAP/Active Directory (optional)</li>
                <li>Importieren Sie Littera-Daten (falls vorhanden)</li>
                <li>Beginnen Sie mit der Erfassung Ihrer Bücher</li>
            </ol>
        </div>
    </div>
</div>

<div class="bg-white border-2 border-gray-200 rounded-lg p-6 mb-8">
    <h3 class="text-lg font-semibold text-gray-900 mb-4">📚 Hilfreiche Links</h3>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <a href="../MANUAL.md" target="_blank" class="flex items-center p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
            <svg class="h-8 w-8 text-blue-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
            </svg>
            <div>
                <div class="font-medium text-gray-900">Benutzerhandbuch</div>
                <div class="text-sm text-gray-600">Komplette Dokumentation</div>
            </div>
        </a>
        
        <a href="../ARCHITECTURE.md" target="_blank" class="flex items-center p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
            <svg class="h-8 w-8 text-green-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
            </svg>
            <div>
                <div class="font-medium text-gray-900">Architektur-Dokumentation</div>
                <div class="text-sm text-gray-600">Technische Details</div>
            </div>
        </a>
    </div>
</div>

<div class="flex justify-center pt-6 border-t">
    <a href="../login.php" class="inline-flex items-center px-8 py-4 border border-transparent text-lg font-semibold rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 shadow-lg transform hover:scale-105 transition-all">
        <svg class="mr-3 h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"/>
        </svg>
        Zur Anmeldung
    </a>
</div>

<div class="mt-8 text-center">
    <p class="text-sm text-gray-500">
        Vielen Dank für die Nutzung unserer Bibliotheksverwaltung!
    </p>
    <p class="text-xs text-gray-400 mt-2">
        Version 1.0 | © <?php echo date('Y'); ?> | <a href="mailto:support@bibliothek-software.at" class="text-blue-600 hover:underline">Support</a>
    </p>
</div>

<?php
// Clean up session
unset($_SESSION['install_db']);
unset($_SESSION['install_admin']);
unset($_SESSION['install_school']);
unset($_SESSION['installation_complete']);
?>
