<div class="mb-6">
    <h2 class="text-2xl font-bold text-gray-900 mb-2">Installation durchführen</h2>
    <p class="text-gray-600">Überprüfen Sie Ihre Eingaben und starten Sie die Installation.</p>
</div>

<!-- Summary of settings -->
<div class="space-y-4 mb-8">
    <div class="bg-gray-50 rounded-lg p-4">
        <h3 class="font-medium text-gray-900 mb-3">📊 Zusammenfassung</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
            <div>
                <span class="text-gray-600">Datenbank-Host:</span>
                <span class="ml-2 font-medium"><?php echo htmlspecialchars($_SESSION['install_db']['db_host'] ?? 'localhost'); ?></span>
            </div>
            <div>
                <span class="text-gray-600">Datenbank-Name:</span>
                <span class="ml-2 font-medium"><?php echo htmlspecialchars($_SESSION['install_db']['db_name'] ?? ''); ?></span>
            </div>
            <div>
                <span class="text-gray-600">Administrator:</span>
                <span class="ml-2 font-medium"><?php echo htmlspecialchars($_SESSION['install_admin']['first_name'] ?? '') . ' ' . htmlspecialchars($_SESSION['install_admin']['last_name'] ?? ''); ?></span>
            </div>
            <div>
                <span class="text-gray-600">Benutzername:</span>
                <span class="ml-2 font-medium"><?php echo htmlspecialchars($_SESSION['install_admin']['username'] ?? ''); ?></span>
            </div>
            <div>
                <span class="text-gray-600">E-Mail:</span>
                <span class="ml-2 font-medium"><?php echo htmlspecialchars($_SESSION['install_admin']['email'] ?? ''); ?></span>
            </div>
            <div>
                <span class="text-gray-600">Bibliotheksname:</span>
                <span class="ml-2 font-medium"><?php echo htmlspecialchars($_SESSION['install_school']['library_name'] ?? ''); ?></span>
            </div>
        </div>
    </div>

    <div class="bg-blue-50 border-l-4 border-blue-500 p-4">
        <div class="flex">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                </svg>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-blue-800">Was wird installiert?</h3>
                <div class="mt-2 text-sm text-blue-700">
                    <ul class="list-disc list-inside space-y-1">
                        <li>12 Datenbank-Tabellen mit Indizes</li>
                        <li>3 Datenbank-Views für schnelle Abfragen</li>
                        <li>Automatische Trigger für Statistiken</li>
                        <li>10 Standardkategorien (Belletristik, Sachbuch, etc.)</li>
                        <li>2 Benutzergruppen (Admin & User)</li>
                        <li>Ihr Administrator-Konto</li>
                        <li>System-Einstellungen (Standard-Werte)</li>
                        <li>Konfigurations-Datei (config.php)</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<form method="POST" action="wizard.php?step=5" id="installForm">
    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-6">
        <div class="flex">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                </svg>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-yellow-800">Wichtiger Hinweis</h3>
                <div class="mt-2 text-sm text-yellow-700">
                    <p>Die Installation wird jetzt alle notwendigen Tabellen und Daten erstellen. Dieser Vorgang dauert ca. 30-60 Sekunden.</p>
                    <p class="mt-2 font-semibold">⚠️ Schließen Sie das Browser-Fenster NICHT während der Installation!</p>
                </div>
            </div>
        </div>
    </div>

    <div id="installProgress" class="hidden mb-6">
        <div class="bg-white border-2 border-blue-500 rounded-lg p-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-gray-900">Installation läuft...</h3>
                <div class="animate-spin rounded-full h-8 w-8 border-b-2 border-blue-600"></div>
            </div>
            
            <div class="space-y-3" id="progressSteps">
                <div class="flex items-center text-sm">
                    <div class="flex-shrink-0 w-6 h-6 rounded-full bg-blue-100 flex items-center justify-center mr-3">
                        <div class="animate-spin rounded-full h-4 w-4 border-b-2 border-blue-600"></div>
                    </div>
                    <span class="text-gray-700">Datenbank-Tabellen werden erstellt...</span>
                </div>
            </div>
            
            <div class="mt-4 w-full bg-gray-200 rounded-full h-2">
                <div id="progressBar" class="bg-blue-600 h-2 rounded-full transition-all duration-500" style="width: 0%"></div>
            </div>
        </div>
    </div>

    <div class="flex justify-between items-center pt-6 border-t">
        <a href="wizard.php?step=4" class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-md hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
            <svg class="mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 17l-5-5m0 0l5-5m-5 5h12"/>
            </svg>
            Zurück
        </a>
        
        <button type="submit" id="installBtn" class="inline-flex items-center px-8 py-4 border border-transparent text-lg font-medium rounded-md text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 shadow-lg">
            <svg class="mr-2 h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
            </svg>
            Jetzt installieren
        </button>
    </div>
</form>

<script>
document.getElementById('installForm').addEventListener('submit', function(e) {
    // Show progress
    document.getElementById('installProgress').classList.remove('hidden');
    document.getElementById('installBtn').disabled = true;
    document.getElementById('installBtn').classList.add('opacity-50', 'cursor-not-allowed');
    
    // Simulate installation progress (visual feedback)
    const steps = [
        { time: 500, progress: 20, text: 'Datenbank-Tabellen erstellen...' },
        { time: 1000, progress: 40, text: 'Views und Indizes erstellen...' },
        { time: 1500, progress: 60, text: 'Trigger einrichten...' },
        { time: 2000, progress: 80, text: 'Standard-Daten einfügen...' },
        { time: 2500, progress: 90, text: 'Administrator-Konto erstellen...' },
        { time: 3000, progress: 95, text: 'Konfigurations-Datei erstellen...' }
    ];
    
    const progressSteps = document.getElementById('progressSteps');
    const progressBar = document.getElementById('progressBar');
    
    steps.forEach((step, index) => {
        setTimeout(() => {
            // Update progress bar
            progressBar.style.width = step.progress + '%';
            
            // Update step text
            if (index > 0) {
                const prevStep = progressSteps.children[index - 1];
                const prevIcon = prevStep.querySelector('div');
                prevIcon.innerHTML = '<svg class="h-4 w-4 text-green-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/></svg>';
                prevIcon.classList.remove('bg-blue-100', 'animate-spin', 'border-b-2', 'border-blue-600');
                prevIcon.classList.add('bg-green-100');
                prevStep.querySelector('span').classList.remove('text-gray-700');
                prevStep.querySelector('span').classList.add('text-green-700', 'line-through');
            }
            
            // Add current step
            if (index < steps.length) {
                const newStep = document.createElement('div');
                newStep.className = 'flex items-center text-sm';
                newStep.innerHTML = `
                    <div class="flex-shrink-0 w-6 h-6 rounded-full bg-blue-100 flex items-center justify-center mr-3">
                        <div class="animate-spin rounded-full h-4 w-4 border-b-2 border-blue-600"></div>
                    </div>
                    <span class="text-gray-700">${step.text}</span>
                `;
                progressSteps.appendChild(newStep);
            }
        }, step.time);
    });
});
</script>
