<div class="mb-6">
    <h2 class="text-2xl font-bold text-gray-900 mb-2">Schulinformationen</h2>
    <p class="text-gray-600">Diese Informationen werden in der Anwendung angezeigt.</p>
</div>

<form method="POST" action="wizard.php?step=4" class="space-y-6">
    <div>
        <label for="library_name" class="block text-sm font-medium text-gray-700 mb-2">
            Name der Bibliothek <span class="text-red-500">*</span>
        </label>
        <input type="text" 
               id="library_name" 
               name="library_name" 
               value="<?php echo isset($_SESSION['install_school']['library_name']) ? htmlspecialchars($_SESSION['install_school']['library_name']) : ''; ?>"
               required
               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
               placeholder="HLW Leoben - Bibliothek">
        <p class="mt-1 text-sm text-gray-500">Wird im Header der Anwendung angezeigt</p>
    </div>

    <div>
        <label for="library_email" class="block text-sm font-medium text-gray-700 mb-2">
            E-Mail-Adresse der Bibliothek <span class="text-red-500">*</span>
        </label>
        <input type="email" 
               id="library_email" 
               name="library_email" 
               value="<?php echo isset($_SESSION['install_school']['library_email']) ? htmlspecialchars($_SESSION['install_school']['library_email']) : ''; ?>"
               required
               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
               placeholder="bibliothek@hlw-leoben.at">
        <p class="mt-1 text-sm text-gray-500">Absender-Adresse für System-E-Mails (Mahnungen, Benachrichtigungen)</p>
    </div>

    <div>
        <label for="footer_text" class="block text-sm font-medium text-gray-700 mb-2">
            Footer-Text <span class="text-red-500">*</span>
        </label>
        <input type="text" 
               id="footer_text" 
               name="footer_text" 
               value="<?php echo isset($_SESSION['install_school']['footer_text']) ? htmlspecialchars($_SESSION['install_school']['footer_text']) : 'Schulbibliothek | © ' . date('Y'); ?>"
               required
               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
               placeholder="HLW Leoben | © <?php echo date('Y'); ?>">
        <p class="mt-1 text-sm text-gray-500">Wird am unteren Rand jeder Seite angezeigt</p>
    </div>

    <div class="bg-blue-50 rounded-lg p-6">
        <h3 class="text-sm font-medium text-blue-900 mb-4">Vorschau</h3>
        <div class="bg-white rounded-lg border-2 border-blue-200 overflow-hidden">
            <!-- Header Preview -->
            <div class="bg-blue-600 text-white px-6 py-4">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-3">
                        <svg class="h-8 w-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                        </svg>
                        <span id="preview_name" class="text-xl font-semibold">
                            <?php echo isset($_SESSION['install_school']['library_name']) ? htmlspecialchars($_SESSION['install_school']['library_name']) : 'Schulbibliothek'; ?>
                        </span>
                    </div>
                </div>
            </div>
            
            <!-- Content Preview -->
            <div class="px-6 py-8 text-center text-gray-500">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                </svg>
                <p class="mt-2 text-sm">Seiten-Inhalt</p>
            </div>
            
            <!-- Footer Preview -->
            <div class="bg-gray-100 px-6 py-3 text-center text-sm text-gray-600 border-t">
                <span id="preview_footer">
                    <?php echo isset($_SESSION['install_school']['footer_text']) ? htmlspecialchars($_SESSION['install_school']['footer_text']) : 'Schulbibliothek | © ' . date('Y'); ?>
                </span>
            </div>
        </div>
    </div>

    <div class="flex justify-between items-center pt-6 border-t">
        <a href="wizard.php?step=3" class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-md hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
            <svg class="mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 17l-5-5m0 0l5-5m-5 5h12"/>
            </svg>
            Zurück
        </a>
        
        <button type="submit" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
            Weiter
            <svg class="ml-2 -mr-1 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
            </svg>
        </button>
    </div>
</form>

<script>
// Live preview update
document.getElementById('library_name')?.addEventListener('input', function(e) {
    document.getElementById('preview_name').textContent = e.target.value || 'Schulbibliothek';
});

document.getElementById('footer_text')?.addEventListener('input', function(e) {
    document.getElementById('preview_footer').textContent = e.target.value || 'Schulbibliothek | © <?php echo date('Y'); ?>';
});
</script>
