<div class="mb-6">
    <h2 class="text-2xl font-bold text-gray-900 mb-2">Administrator-Konto erstellen</h2>
    <p class="text-gray-600">Erstellen Sie Ihren ersten Administrator-Account für die Bibliotheksverwaltung.</p>
</div>

<div class="bg-green-50 border-l-4 border-green-500 p-4 mb-6">
    <div class="flex">
        <div class="flex-shrink-0">
            <svg class="h-5 w-5 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
            </svg>
        </div>
        <div class="ml-3">
            <p class="text-sm text-green-700">
                ✅ Datenbankverbindung erfolgreich getestet!
            </p>
        </div>
    </div>
</div>

<form method="POST" action="wizard.php?step=3" class="space-y-6" onsubmit="return validatePassword()">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="first_name" class="block text-sm font-medium text-gray-700 mb-2">
                Vorname <span class="text-red-500">*</span>
            </label>
            <input type="text" 
                   id="first_name" 
                   name="first_name" 
                   value="<?php echo isset($_SESSION['install_admin']['first_name']) ? htmlspecialchars($_SESSION['install_admin']['first_name']) : ''; ?>"
                   required
                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                   placeholder="Maria">
        </div>

        <div>
            <label for="last_name" class="block text-sm font-medium text-gray-700 mb-2">
                Nachname <span class="text-red-500">*</span>
            </label>
            <input type="text" 
                   id="last_name" 
                   name="last_name" 
                   value="<?php echo isset($_SESSION['install_admin']['last_name']) ? htmlspecialchars($_SESSION['install_admin']['last_name']) : ''; ?>"
                   required
                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                   placeholder="Musterfrau">
        </div>
    </div>

    <div>
        <label for="username" class="block text-sm font-medium text-gray-700 mb-2">
            Benutzername <span class="text-red-500">*</span>
        </label>
        <input type="text" 
               id="username" 
               name="username" 
               value="<?php echo isset($_SESSION['install_admin']['username']) ? htmlspecialchars($_SESSION['install_admin']['username']) : ''; ?>"
               required
               pattern="[a-zA-Z0-9._-]+"
               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
               placeholder="admin">
        <p class="mt-1 text-sm text-gray-500">Nur Buchstaben, Zahlen, Punkt, Unterstrich und Bindestrich erlaubt</p>
    </div>

    <div>
        <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
            E-Mail-Adresse <span class="text-red-500">*</span>
        </label>
        <input type="email" 
               id="email" 
               name="email" 
               value="<?php echo isset($_SESSION['install_admin']['email']) ? htmlspecialchars($_SESSION['install_admin']['email']) : ''; ?>"
               required
               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
               placeholder="bibliothek@ihre-schule.at">
        <p class="mt-1 text-sm text-gray-500">Wird für Systembenachrichtigungen verwendet</p>
    </div>

    <div>
        <label for="password" class="block text-sm font-medium text-gray-700 mb-2">
            Passwort <span class="text-red-500">*</span>
        </label>
        <input type="password" 
               id="password" 
               name="password" 
               required
               minlength="8"
               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
               placeholder="••••••••"
               oninput="checkPasswordStrength()">
        <div id="password-strength" class="mt-2 hidden">
            <div class="flex items-center space-x-2">
                <div class="flex-1 bg-gray-200 rounded-full h-2">
                    <div id="strength-bar" class="h-2 rounded-full transition-all duration-300"></div>
                </div>
                <span id="strength-text" class="text-sm font-medium"></span>
            </div>
        </div>
    </div>

    <div>
        <label for="password_confirm" class="block text-sm font-medium text-gray-700 mb-2">
            Passwort wiederholen <span class="text-red-500">*</span>
        </label>
        <input type="password" 
               id="password_confirm" 
               name="password_confirm" 
               required
               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
               placeholder="••••••••">
    </div>

    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4">
        <div class="flex">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
            </svg>
        </div>
        <div class="ml-3">
            <h3 class="text-sm font-medium text-yellow-800">Passwort-Anforderungen</h3>
            <div class="mt-2 text-sm text-yellow-700">
                <ul class="list-disc list-inside space-y-1">
                    <li>Mindestens 8 Zeichen</li>
                    <li>Mindestens 1 Großbuchstabe</li>
                    <li>Mindestens 1 Kleinbuchstabe</li>
                    <li>Mindestens 1 Zahl</li>
                    <li>Mindestens 1 Sonderzeichen (!@#$%^&*)</li>
                </ul>
            </div>
        </div>
    </div>

    <div class="flex justify-between items-center pt-6 border-t">
        <a href="wizard.php?step=2" class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-md hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
            <svg class="mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 17l-5-5m0 0l5-5m-5 5h12"/>
            </svg>
            Zurück
        </a>
        
        <button type="submit" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
            Weiter
            <svg class="ml-2 -mr-1 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
            </svg>
        </button>
    </div>
</form>

<script>
function checkPasswordStrength() {
    const password = document.getElementById('password').value;
    const strengthBar = document.getElementById('strength-bar');
    const strengthText = document.getElementById('strength-text');
    const strengthDiv = document.getElementById('password-strength');
    
    if (password.length === 0) {
        strengthDiv.classList.add('hidden');
        return;
    }
    
    strengthDiv.classList.remove('hidden');
    
    let strength = 0;
    if (password.length >= 8) strength++;
    if (/[a-z]/.test(password)) strength++;
    if (/[A-Z]/.test(password)) strength++;
    if (/[0-9]/.test(password)) strength++;
    if (/[^A-Za-z0-9]/.test(password)) strength++;
    
    const colors = ['bg-red-500', 'bg-orange-500', 'bg-yellow-500', 'bg-lime-500', 'bg-green-500'];
    const texts = ['Sehr schwach', 'Schwach', 'Mittel', 'Stark', 'Sehr stark'];
    const widths = ['20%', '40%', '60%', '80%', '100%'];
    
    strengthBar.className = 'h-2 rounded-full transition-all duration-300 ' + colors[strength - 1];
    strengthBar.style.width = widths[strength - 1];
    strengthText.textContent = texts[strength - 1];
}

function validatePassword() {
    const password = document.getElementById('password').value;
    const confirm = document.getElementById('password_confirm').value;
    
    if (password !== confirm) {
        alert('Die Passwörter stimmen nicht überein!');
        return false;
    }
    
    const checks = [
        [password.length >= 8, 'mindestens 8 Zeichen'],
        [/[A-Z]/.test(password), 'einen Großbuchstaben'],
        [/[a-z]/.test(password), 'einen Kleinbuchstaben'],
        [/[0-9]/.test(password), 'eine Zahl'],
        [/[^A-Za-z0-9]/.test(password), 'ein Sonderzeichen']
    ];
    
    for (let [valid, msg] of checks) {
        if (!valid) {
            alert('Passwort muss ' + msg + ' enthalten!');
            return false;
        }
    }
    
    return true;
}
</script>
