<div class="mb-6">
    <h2 class="text-2xl font-bold text-gray-900 mb-2">Datenbankverbindung</h2>
    <p class="text-gray-600">Geben Sie die Zugangsdaten für Ihre MySQL-Datenbank ein.</p>
</div>

<form method="POST" action="wizard.php?step=2" class="space-y-6">
    <div>
        <label for="db_host" class="block text-sm font-medium text-gray-700 mb-2">
            Datenbank-Host <span class="text-red-500">*</span>
        </label>
        <input type="text" 
               id="db_host" 
               name="db_host" 
               value="<?php echo isset($_SESSION['install_db']['db_host']) ? htmlspecialchars($_SESSION['install_db']['db_host']) : 'localhost'; ?>"
               required
               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
               placeholder="localhost">
        <p class="mt-1 text-sm text-gray-500">Meist "localhost". Bei externem Server: z.B. "db.ihre-schule.at"</p>
    </div>

    <div>
        <label for="db_name" class="block text-sm font-medium text-gray-700 mb-2">
            Datenbankname <span class="text-red-500">*</span>
        </label>
        <input type="text" 
               id="db_name" 
               name="db_name" 
               value="<?php echo isset($_SESSION['install_db']['db_name']) ? htmlspecialchars($_SESSION['install_db']['db_name']) : ''; ?>"
               required
               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
               placeholder="z.B. bibliothek, bib_db, my_library">
        <p class="mt-1 text-sm text-gray-500">Name der vorher erstellten Datenbank (frei wählbar)</p>
    </div>

    <div>
        <label for="db_user" class="block text-sm font-medium text-gray-700 mb-2">
            Datenbank-Benutzername <span class="text-red-500">*</span>
        </label>
        <input type="text" 
               id="db_user" 
               name="db_user" 
               value="<?php echo isset($_SESSION['install_db']['db_user']) ? htmlspecialchars($_SESSION['install_db']['db_user']) : ''; ?>"
               required
               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
               placeholder="root">
        <p class="mt-1 text-sm text-gray-500">MySQL-Benutzername (z.B. "root" oder "bib_user")</p>
    </div>

    <div>
        <label for="db_pass" class="block text-sm font-medium text-gray-700 mb-2">
            Datenbank-Passwort
        </label>
        <input type="password" 
               id="db_pass" 
               name="db_pass" 
               value="<?php echo isset($_SESSION['install_db']['db_pass']) ? htmlspecialchars($_SESSION['install_db']['db_pass']) : ''; ?>"
               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
               placeholder="••••••••">
        <p class="mt-1 text-sm text-gray-500">Lassen Sie das Feld leer, falls kein Passwort gesetzt ist</p>
    </div>

    <div class="bg-blue-50 border-l-4 border-blue-500 p-4">
        <div class="flex">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                </svg>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-blue-800">Tipp: Datenbank erstellen</h3>
                <div class="mt-2 text-sm text-blue-700">
                    <p class="mb-2">Falls Sie die Datenbank noch nicht erstellt haben (ersetzen Sie <strong>bibliothek</strong> durch Ihren gewünschten Namen):</p>
                    <code class="block bg-white p-2 rounded text-xs mt-2">
                        CREATE DATABASE <strong>bibliothek</strong> CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
                    </code>
                </div>
            </div>
        </div>
    </div>

    <div class="flex justify-between items-center pt-6 border-t">
        <a href="wizard.php?step=1" class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-md hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
            <svg class="mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 17l-5-5m0 0l5-5m-5 5h12"/>
            </svg>
            Zurück
        </a>
        
        <button type="submit" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
            Verbindung testen
            <svg class="ml-2 -mr-1 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
            </svg>
        </button>
    </div>
</form>
