<div class="text-center">
    <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-blue-100 mb-4">
        <svg class="h-10 w-10 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
        </svg>
    </div>
    
    <h2 class="text-3xl font-bold text-gray-900 mb-4">
        Willkommen zur Installation
    </h2>
    
    <p class="text-lg text-gray-600 mb-8">
        Bibliotheksverwaltungssystem v1.0
    </p>
</div>

<div class="bg-blue-50 border-l-4 border-blue-500 p-4 mb-6">
    <div class="flex">
        <div class="flex-shrink-0">
            <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
            </svg>
        </div>
        <div class="ml-3">
            <h3 class="text-sm font-medium text-blue-800">Vor der Installation</h3>
            <div class="mt-2 text-sm text-blue-700">
                <p class="mb-2">Stellen Sie sicher, dass Sie folgende Informationen bereit haben:</p>
                <ul class="list-disc list-inside space-y-1 ml-4">
                    <li>Datenbank-Zugangsdaten (Host, Name, Benutzer, Passwort)</li>
                    <li>E-Mail-Adresse für den Administrator-Account</li>
                    <li>Schulname und Footer-Text</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<div class="space-y-4 mb-8">
    <h3 class="text-lg font-semibold text-gray-900">Systemanforderungen</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div class="bg-gray-50 rounded-lg p-4">
            <h4 class="font-medium text-gray-900 mb-2">✅ Server</h4>
            <ul class="text-sm text-gray-600 space-y-1">
                <li>• PHP 8.1 oder höher</li>
                <li>• MySQL 8.0 oder höher</li>
                <li>• Apache/Nginx Webserver</li>
                <li>• 500 MB Festplattenspeicher</li>
            </ul>
        </div>
        
        <div class="bg-gray-50 rounded-lg p-4">
            <h4 class="font-medium text-gray-900 mb-2">✅ PHP-Erweiterungen</h4>
            <ul class="text-sm text-gray-600 space-y-1">
                <li>• pdo_mysql</li>
                <li>• mbstring</li>
                <li>• curl</li>
                <li>• gd oder imagick</li>
            </ul>
        </div>
    </div>
</div>

<div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-8">
    <div class="flex">
        <div class="flex-shrink-0">
            <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
            </svg>
        </div>
        <div class="ml-3">
            <h3 class="text-sm font-medium text-yellow-800">Wichtiger Hinweis</h3>
            <div class="mt-2 text-sm text-yellow-700">
                <p>Die Installation wird eine neue Datenbank erstellen. Falls bereits eine Datenbank existiert, stellen Sie sicher, dass Sie ein Backup haben!</p>
            </div>
        </div>
    </div>
</div>

<div class="flex justify-between items-center pt-6 border-t">
    <div class="text-sm text-gray-500">
        Installations-Assistent
    </div>
    <a href="wizard.php?step=2" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors">
        Installation starten
        <svg class="ml-2 -mr-1 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
        </svg>
    </a>
</div>
