<?php
/**
 * Index - Main Entry Point
 * Redirects to appropriate page based on installation/login status
 */

// Check if installed
if (!file_exists(__DIR__ . '/includes/config.php')) {
    // Not installed - redirect to installation wizard
    header('Location: install/wizard.php');
    exit;
}

require_once __DIR__ . '/includes/config.php';

// Check if installation is complete
if (!defined('INSTALLED') || !INSTALLED) {
    header('Location: install/wizard.php');
    exit;
}

require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/includes/session.php';

// Check if user is logged in
if (!is_logged_in()) {
    // Not logged in - redirect to login
    header('Location: ' . BASE_URL . '/login.php');
    exit;
}

// Logged in - redirect to dashboard
header('Location: ' . BASE_URL . '/dashboard.php');
exit;
