<?php
/**
 * Session Management
 * Secure session handling with timeout
 */

// Session configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_samesite', 'Strict');
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
    ini_set('session.cookie_secure', 1);
}

// Start session with custom name
session_name('BIB_SESSION');
session_start();

// Session timeout: read from DB settings if available, else 60 minutes default
if (function_exists('getSetting')) {
    $session_timeout_minutes = (int)getSetting('session_timeout_minutes', 60);
    $session_timeout_minutes = max(5, min(480, $session_timeout_minutes));
    define('SESSION_TIMEOUT', $session_timeout_minutes * 60);
} else {
    define('SESSION_TIMEOUT', 3600);
}

// Check session timeout
if (isset($_SESSION['last_activity'])) {
    $elapsed = time() - $_SESSION['last_activity'];
    if ($elapsed > SESSION_TIMEOUT) {
        session_unset();
        session_destroy();
        if (basename($_SERVER['PHP_SELF']) !== 'login.php') {
            $root = defined('BASE_URL') ? BASE_URL : '';
            header('Location: ' . $root . '/login.php?timeout=1');
            exit;
        }
    }
}

// Update last activity
$_SESSION['last_activity'] = time();

// Session fixation prevention
if (!isset($_SESSION['initiated'])) {
    session_regenerate_id(true);
    $_SESSION['initiated'] = true;
}

// Set language from session; if not yet in session, read from DB setting
if (!isset($_SESSION['language'])) {
    if (function_exists('getSetting')) {
        try {
            $_SESSION['language'] = getSetting('language', 'de');
        } catch (Exception $e) {
            $_SESSION['language'] = 'de';
        }
    } else {
        $_SESSION['language'] = 'de';
    }
}
