<?php
/**
 * English Language File
 * All translatable strings
 */

return [
    // Login
    'login_title' => 'Login',
    'login_subtitle' => 'Sign in to continue',
    'login_username' => 'Username or Email',
    'login_username_placeholder' => 'admin',
    'login_password' => 'Password',
    'login_password_placeholder' => '••••••••',
    'login_remember' => 'Remember me',
    'login_button' => 'Sign in',
    'login_error' => 'Invalid username or password',
    'session_expired' => 'Your session has expired. Please sign in again.',
    'ldap_enabled_notice' => 'LDAP authentication enabled',
    
    // Dashboard
    'dashboard_title' => 'Dashboard',
    'dashboard_welcome' => 'Welcome back',
    'dashboard_search_placeholder' => 'Search by title, author, ISBN...',
    'dashboard_new_books' => 'New Books',
    'dashboard_popular_books' => 'Most Popular',
    'dashboard_my_loans' => 'My Loans',
    'dashboard_my_reservations' => 'My Reservations',
    'dashboard_no_loans' => 'You have no current loans',
    'dashboard_no_reservations' => 'You have no active reservations',
    
    // Navigation
    'nav_dashboard' => 'Dashboard',
    'nav_search' => 'Search Books',
    'nav_my_account' => 'My Account',
    'nav_admin_area' => 'Admin Area',
    'nav_logout' => 'Logout',
    'nav_profile' => 'Profile',
    'nav_settings' => 'Settings',
    
    // Books
    'book_title' => 'Title',
    'book_author' => 'Author',
    'book_isbn' => 'ISBN',
    'book_publisher' => 'Publisher',
    'book_year' => 'Year',
    'book_category' => 'Category',
    'book_language' => 'Language',
    'book_available' => 'Available',
    'book_unavailable' => 'On loan',
    'book_copies_available' => '{count} of {total} available',
    'book_reserve' => 'Reserve',
    'book_details' => 'View details',
    
    // Loans
    'loan_due_date' => 'Due',
    'loan_loaned_on' => 'Borrowed on',
    'loan_extend' => 'Extend',
    'loan_return' => 'Return',
    'loan_overdue' => 'Overdue',
    'loan_days_left' => '{days} days',
    'loan_today' => 'Today',
    'loan_tomorrow' => 'Tomorrow',
    
    // Reservations
    'reservation_position' => 'Position {position}',
    'reservation_ready' => 'Ready for pickup',
    'reservation_waiting' => 'Waiting',
    'reservation_until' => 'Pick up by',
    'reservation_cancel' => 'Cancel',
    
    // Admin
    'admin_dashboard' => 'Admin Dashboard',
    'admin_books' => 'Inventory Management',
    'admin_lending' => 'Lending Management',
    'admin_users' => 'User Management',
    'admin_reports' => 'Reports',
    'admin_settings' => 'Settings',
    
    // Common
    'save' => 'Save',
    'cancel' => 'Cancel',
    'delete' => 'Delete',
    'edit' => 'Edit',
    'add' => 'Add',
    'search' => 'Search',
    'filter' => 'Filter',
    'back' => 'Back',
    'next' => 'Next',
    'previous' => 'Previous',
    'close' => 'Close',
    'yes' => 'Yes',
    'no' => 'No',
    'loading' => 'Loading...',
    'error' => 'Error',
    'success' => 'Success',
    'warning' => 'Warning',
    'info' => 'Information',
    
    // Messages
    'msg_saved_successfully' => 'Saved successfully',
    'msg_deleted_successfully' => 'Deleted successfully',
    'msg_error_occurred' => 'An error occurred',
    'msg_confirm_delete' => 'Are you sure you want to delete this?',
    'msg_no_results' => 'No results found',
    
    // Date & Time
    'date_today' => 'Today',
    'date_yesterday' => 'Yesterday',
    'date_tomorrow' => 'Tomorrow',
    'time_minutes_ago' => '{minutes} minutes ago',
    'time_hours_ago' => '{hours} hours ago',
    'time_days_ago' => '{days} days ago',
    
    // Dashboard
    'welcome' => 'Welcome',
    'dashboard_subtitle' => 'Here is an overview of your library activities',
    'current_loans' => 'Current Loans',
    'overdue_loans' => 'Overdue',
    'total_loans' => 'Total Borrowed',
    'quick_search' => 'Quick Search',
    'search_placeholder' => 'Title, Author, ISBN...',
    'my_loans' => 'My Loans',
    'my_reservations' => 'My Reservations',
    'no_active_loans' => 'No active loans',
    'no_active_reservations' => 'No active reservations',
    'days_overdue' => 'days overdue',
    'days_remaining' => 'days remaining',
    'book_number' => 'Book No.',
    'view_all_loans' => 'View all loans',
    'view_all_reservations' => 'View all reservations',
    'position' => 'Position',
    'new_books' => 'New Books',
    'popular_books' => 'Popular Books',
    'no_new_books' => 'No new books',
    'no_popular_books' => 'No data available',
    'available' => 'Available',
    
    // Navigation
    'nav_dashboard' => 'Dashboard',
    'nav_search' => 'Search',
    'nav_admin_area' => 'Admin',
    'nav_profile' => 'Profile',
    'nav_logout' => 'Logout',
    
    // Admin Area
    'admin_area' => 'Admin Area',
    'admin_dashboard' => 'Dashboard',
    'admin_inventory_mgmt' => 'Inventory Management',
    'admin_add_book' => 'Add Book',
    'admin_edit_books' => 'Edit Books',
    'admin_delete_books' => 'Remove Books',
    'admin_print_labels' => 'Print Labels',
    'admin_users_overview' => 'Overview',
    'admin_sokrates_import' => 'Sokrates Import',
    'admin_settings_general' => 'General',
    'user_dashboard' => 'User Dashboard',
    'admin_categories' => 'Categories',
    'admin_lending_mgmt' => 'Lending Management',
    'admin_checkout' => 'Check Out',
    'admin_return' => 'Return',
    'admin_active_loans' => 'Active Loans',
    'admin_reminders' => 'Reminders',
    'admin_reservations' => 'Reservations',
    'admin_inventory' => 'Inventory',
    'admin_inventory_start' => 'Start Inventory',
    'admin_inventory_ongoing' => 'Ongoing Inventory',
    'admin_inventory_history' => 'Inventory History',
    'admin_user_mgmt' => 'User Management',
    'admin_create_user' => 'Create User',
    'admin_ldap_sync' => 'LDAP Sync',
    'admin_reports' => 'Statistics & Reports',
    'admin_lending_stats' => 'Lending Statistics',
    'admin_inventory_overview' => 'Inventory Overview',
    'admin_report_generator' => 'Report Generator',
    'admin_settings' => 'Settings',
    'admin_system_settings' => 'System Settings',
    'admin_backup' => 'Data Backup',
    'admin_import' => 'Data Import',
    'back_to_dashboard' => 'Back to Dashboard',
    
    // Admin Dashboard
    'admin_total_books' => 'Total Books',
    'admin_available' => 'Available',
    'admin_overdue' => 'Overdue',
    'admin_quick_actions' => 'Quick Actions',
    'admin_add_book_desc' => 'Add new book',
    'admin_checkout_desc' => 'Check out book',
    'admin_return_desc' => 'Return book',
    'admin_overdue_loans' => 'Overdue Loans',
    'admin_no_overdue' => 'No overdue loans',
    'admin_pending_reservations' => 'Pending Reservations',
    'admin_no_reservations' => 'No pending reservations',
    'admin_recent_activity' => 'Recent Activity',
    'admin_no_activity' => 'No activity',
    'days_waiting' => 'days waiting',
    'view_all' => 'View all',
    
    // Footer Settings (Phase 5)
    'footer_text_label' => 'Footer Text',
    'footer_text_help' => 'Text displayed in the footer',
    
    // User Management (Phase 4)
    'create_user' => 'Create User',
    'edit_user' => 'Edit User',
    'user_list' => 'User List',
    'users' => 'Users',
    'username' => 'Username',
    'email' => 'Email',
    'first_name' => 'First Name',
    'last_name' => 'Last Name',
    'user_group' => 'User Group',
    'status' => 'Status',
    'status_active' => 'Active',
    'status_blocked' => 'Blocked',
    'status_inactive' => 'Inactive',
    'class_name' => 'Class',
    'student_id' => 'Student ID',
    'password' => 'Password',
    'password_confirm' => 'Confirm Password',
    'change_password' => 'Change Password',
    'password_leave_empty' => 'Leave empty to keep current password',
    'password_requirements' => 'Minimum 8 characters',
    'update_user' => 'Update User',
    'all_groups' => 'All Groups',
    'all_statuses' => 'All Statuses',
    'filter' => 'Filter',
    'name' => 'Name',
    'group' => 'Group',
    'auth_method' => 'Auth',
    'actions' => 'Actions',
    'edit' => 'Edit',
    'delete' => 'Delete',
    'no_users_found' => 'No users found',
    'cancel' => 'Cancel',
    'search_placeholder' => 'Search...',
    'showing' => 'Showing',
    'to' => 'to',
    'of' => 'of',
    'results' => 'results',
    'previous' => 'Previous',
    'next' => 'Next',
    
    // User Management Errors
    'error_username_required' => 'Username is required',
    'error_email_required' => 'Email is required',
    'error_email_invalid' => 'Invalid email address',
    'error_password_required' => 'Password is required',
    'error_password_mismatch' => 'Passwords do not match',
    'error_password_too_short' => 'Password must be at least 8 characters long',
    'error_first_name_required' => 'First name is required',
    'error_last_name_required' => 'Last name is required',
    'error_username_exists' => 'Username already exists',
    'error_email_exists' => 'Email address already exists',
    'error_user_create_failed' => 'Failed to create user',
    'error_user_update_failed' => 'Failed to update user',
    'error_user_delete_failed' => 'Failed to delete user',
    'error_user_has_loans' => 'User has %d active loans and cannot be deleted',
    
    // User Management Success
    'success_user_created' => 'User "%s" was successfully created',
    'success_user_updated' => 'User "%s" was successfully updated',
    'success_user_deleted' => 'User "%s" was successfully deleted',
    'confirm_delete_user' => 'Do you really want to delete this user?',
    
    // LDAP Sync
    'ldap_status' => 'LDAP Status',
    'ldap_status_desc' => 'Current LDAP configuration and sync status',
    'enabled' => 'Enabled',
    'disabled' => 'Disabled',
    'ldap_users' => 'LDAP Users',
    'ldap_configuration' => 'LDAP Configuration',
    'ldap_configuration_desc' => 'Configure connection to LDAP/Active Directory',
    'enable_ldap' => 'Enable LDAP authentication',
    'ldap_connection_settings' => 'Connection Settings',
    'ldap_host' => 'LDAP Server',
    'ldap_host_help' => 'Hostname or IP address of LDAP server',
    'ldap_port' => 'Port',
    'ldap_port_help' => 'Default: 389 (LDAP) or 636 (LDAPS)',
    'ldap_base_dn' => 'Base DN',
    'ldap_base_dn_help' => 'Base DN for user search',
    'ldap_bind_dn' => 'Bind DN',
    'ldap_bind_dn_help' => 'DN of user account for LDAP search',
    'ldap_bind_password' => 'Bind Password',
    'ldap_bind_password_help' => 'Password for Bind DN',
    'leave_empty_to_keep' => 'Leave empty to keep current',
    'ldap_user_mapping' => 'User Mapping',
    'ldap_user_filter' => 'User Filter',
    'ldap_user_filter_help' => 'LDAP filter for user search',
    'ldap_username_attr' => 'Username Attribute',
    'ldap_email_attr' => 'Email Attribute',
    'ldap_firstname_attr' => 'First Name Attribute',
    'ldap_lastname_attr' => 'Last Name Attribute',
    'ldap_group_attr' => 'Group Attribute',
    'ldap_group_attr_help' => 'Attribute for group membership (not yet implemented)',
    'test_connection' => 'Test Connection',
    'save_configuration' => 'Save Configuration',
    'ldap_sync_actions' => 'Synchronization',
    'ldap_sync_desc' => 'Import users from LDAP/Active Directory',
    'ldap_sync_info' => 'Sync imports all users from LDAP. Existing LDAP users will be updated, local users remain unchanged.',
    'ldap_current_users' => 'Current LDAP Users',
    'start_sync' => 'Start Sync',
    'ldap_disabled_notice' => 'LDAP is disabled. Please enable LDAP in the configuration above to use synchronization.',
    
    // LDAP Errors
    'error_ldap_not_available' => 'LDAP extension is not available. Please install PHP LDAP module.',
    'error_ldap_connection_failed' => 'LDAP connection failed. Please check host and port.',
    'error_ldap_bind_failed' => 'LDAP bind failed. Please check Bind DN and password.',
    'error_ldap_not_enabled' => 'LDAP is not enabled',
    'error_ldap_search_failed' => 'LDAP search failed',
    
    // LDAP Success
    'success_ldap_config_saved' => 'LDAP configuration saved',
    'success_ldap_connection' => 'LDAP connection successful!',
    'success_ldap_sync' => 'LDAP sync completed: %d found, %d created, %d updated, %d skipped',
    'confirm_ldap_sync' => 'Do you want to start LDAP synchronization? This may take several minutes.',
    'errors' => 'Errors',

    // Label Print (Barcode Label Printing)
    'label_print_title'               => 'Print Signature Labels',
    'label_settings_heading'          => 'Settings',
    'label_format'                    => 'Label Format',
    'label_format_avery3651'          => 'AVERY 3651 (52.5 × 29.7 mm · 4×10 / A4)',
    'label_format_avery3657'          => 'AVERY 3657 (48.5 × 25.4 mm · 4×12 / A4)',
    'label_format_brother_ql'         => 'Brother QL-810W (62 × 29 mm · 1 label/page)',
    'label_copies_selection'          => 'Copies',
    'label_start_position'            => 'Start Position',
    'label_start_position_empty_hint' => 'empty positions at the start',
    'label_start_position_used_sheets'=> 'For partially used sheets',
    'label_start_position_help'       => 'Skip the first N label positions on the sheet (for partially used sheets)',
    'label_print_button'              => 'Print',
    'label_preview'                   => 'Preview',
    'label_preview_hint'              => 'Shows the first 2 rows (not to scale)',
    'label_select_all'                => 'All',
    'label_deselect_all'              => 'None',
    'label_no_copies'                 => 'No copies found.',
    'label_no_copies_url_hint'        => 'Please provide <code>book_id</code>, <code>copy_id</code> or <code>copy_ids</code> as a URL parameter.',
    'label_print_hint'                => 'Select "Actual Size" (no scaling) and margins = 0 in the print dialog.',
    'label_print_brother_hint'        => 'Select paper size 62 mm × 29 mm without margins in the print dialog.',
    'label_copies_per_exemplar'       => 'Copies per copy',
    'label_js_none_selected'          => 'No copies selected',
    'label_js_select_min_one'         => 'Please select at least one copy.',
    'label_js_count_showing'          => 'Showing %d of %d labels (%d copies)',
    'label_js_count_total'            => '%d label(s) (%d copy/copies)',
    'print_label'                     => 'Print label',
    'label_search_heading'            => 'Find book',
    'label_search_placeholder'        => 'Title, author or ISBN…',
    'label_search_btn'                => 'Search',
    'label_book_number_heading'       => 'or enter book number directly',
    'label_book_number_placeholder'   => 'e.g. 14613…',
    'label_book_number_btn'           => 'Print label',
    'label_search_no_results'         => 'No books found for',
    'label_search_copies_count'       => 'copy/copies',
    'label_print_all_btn'             => 'Print all labels',

    // Books - Add Copy (books-add-copy.php)
    'add_copy'               => 'Add Copy',
    'invalid_book_id'        => 'Invalid Book ID',
    'book_not_found'         => 'Book not found',
    'book_label'             => 'Book',
    'copies_existing'        => 'copy on file',
    'copies_existing_plural' => 'copies on file',
    'copy_added_success'     => 'Copy added successfully',
    'book_number_required'   => 'Book number is required',
    'book_number_taken'      => 'Book number is already in use',
    'new_copy_form'          => 'Register New Copy',
    'book_number_field'      => 'Book Number',
    'suggested'              => 'Suggested',
    'signature'              => 'Signature',
    'location'               => 'Location',
    'acquired_at'            => 'Date Acquired',
    'condition_note'         => 'Condition / Note',
    'save_copy'              => 'Save Copy',
    'to_book'                => 'To Book',
    'add_another_copy'       => 'Add Another Copy',
    'number_available'       => 'Available',
    'number_taken'           => 'Already taken',

    // Books - Edit List (books-edit.php)
    'books'                  => 'Books',
    'books_total'            => 'books total',
    'books_found'            => 'books found',
    'add_new_book'           => 'New Book',
    'fulltext_search_label'  => 'Full-text search (title, author, ISBN, keywords, description, location, book number…)',
    'search_input_hint'      => 'Enter search term…',
    'per_page'               => 'Per page',
    'reset_filter'           => 'Reset',
    'book_abbr_nr'           => 'BookNo',
    'author_abbr'            => 'Short',
    'subtitle'               => 'Subtitle',
    'no_copies'              => 'no copies',
    'all_on_loan'            => 'all on loan',
    'available_of'           => 'available',
    'no_books_found'         => 'No books found for',
    'no_books_in_db'         => 'No books in the database.',
    'fulltext_label'         => 'Full-text',
    'hits'                   => 'hits',
    'search_label'           => 'Search',

    // Books - Delete (books-delete.php)
    'delete_book'            => 'Delete Book',
    'confirm_delete_book'    => 'Really delete book?',
    'back_to_overview'       => 'Back to overview',
    'book_info'              => 'Book Info',
    'book_number_ids'        => 'Book Numbers',
    'cannot_delete_book'     => 'Book cannot be deleted!',
    'copies_still_loaned'    => 'copy/copies still on loan. Please return all copies first.',
    'warning_irreversible'   => 'Warning: This action cannot be undone!',
    'book_permanently_deleted' => 'The book will be permanently deleted',
    'all_copies_deleted'     => 'All copies will be deleted',
    'loan_history_deleted'   => 'The loan history will be deleted',
    'confirm_delete_final'   => 'Yes, permanently delete book',
    'back_to_book_list'      => 'Back to book list',
    'copies_count_label'     => 'Copy',
    'copies_count_plural'    => 'Copies',
    'loan_history_entries'   => 'entries',
    'year_label'             => 'Year',

    // Books - Remove / Discard (books-remove.php)
    'remove_book'                      => 'Discard Books',
    'no_copies_selected'               => 'No copies selected.',
    'enter_book_numbers'               => 'Enter Book Numbers',
    'enter_book_numbers_help'          => 'Enter the book numbers of the copies to discard — separate multiple numbers with comma, semicolon or space.',
    'book_numbers_label'               => 'Book Numbers',
    'show_preview'                     => 'Show Preview',
    'preview_heading'                  => 'Preview',
    'copies_discard_label'             => 'copy to discard',
    'copies_discard_plural'            => 'copies to discard',
    'status_discarded'                 => 'discarded',
    'book_data_preserved'              => 'Book data will be preserved.',
    'book_nr_col'                      => 'Book No.',
    'title_col'                        => 'Title',
    'author_col'                       => 'Author',
    'check_list_warning'               => 'Please review the list carefully.',
    'discarded_cannot_loan'            => 'Discarded copies can no longer be borrowed. The book numbers remain in the database.',
    'confirm_remove'                   => 'Permanently Discard',
    'number_not_found'                 => 'not found.',
    'already_discarded'                => 'is already discarded.',
    'currently_on_loan'                => 'is currently on loan.',
    'copies_removed_success'           => 'successfully discarded.',
    'copies_still_on_loan_err'         => 'copy/copies still on loan and cannot be discarded.',
    'to_book_list'                     => 'To Book List',

    // Books - Littera Import (books-littera-import.php)
    'littera_import'           => 'Littera Import',
    'littera_import_subtitle'  => 'Import your legacy stock from the Littera database (CSV export via mdbtools)',
    'step_analysis'            => 'Analysis',
    'step_preview'             => 'Preview',
    'step_import'              => 'Import',
    'step_result'              => 'Result',
    'upload_csv_files'         => 'Upload CSV Files',
    'file_present'             => 'present',
    'file_missing'             => 'missing',
    'upload_files_btn'         => 'Upload Files',
    'file_status_label'        => 'Status in',
    'missing_files_label'      => 'Missing files',
    'missing_files_help'       => 'Upload files or export with mdbtools and copy to uploads/littera/csv_export/.',
    'analyze_start'            => 'Start Analysis',
    'go_to_preview'            => 'Continue to Preview',
    'step1_title'              => 'Step 1: Data Analysis',
    'step1_subtitle'           => 'Analyse CSV files from uploads/littera/csv_export/',
    'step2_title'              => 'Step 2: Data Preview',
    'step2_subtitle'           => 'First 15 entries with all transformations',
    'step3_title'              => 'Step 3: Run Import',
    'step4_title'              => 'Step 4: Result',
    'load_preview_btn'         => 'Load Preview',
    'go_back_btn'              => 'Back',
    'go_to_import_btn'         => 'Continue to Import',
    'import_mode'              => 'Import Mode',
    'import_mode_test'         => 'Test Import (10 titles)',
    'import_mode_small'        => 'Small Import (50 titles)',
    'import_mode_full'         => 'Full Import (all titles)',
    'import_running'           => 'Import running...',
    'import_running_wait'      => 'This may take several minutes. Please do not close the window.',
    'import_start_btn'         => 'Start Import',
    'reset_data_btn'           => 'Reset Data',
    'import_warning_title'     => 'Note',
    'import_duplicates_note'   => 'Duplicates are detected by ISBN and skipped',
    'import_no_isbn_note'      => 'For books without ISBN: duplicate detection via title + author',
    'import_exemplar_note'     => 'Copies with the same inventory number are skipped',
    'titles_label'             => 'Titles',
    'copies_label'             => 'Copies',
    'total_label'              => 'Total',
    'imported_label'           => 'Imported',
    'duplicates_label'         => 'Duplicates',
    'errors_label'             => 'Errors',
    'skipped_label'            => 'Skipped',
    'no_title_label'           => 'Without Title',
    'duration_label'           => 'Duration',
    'seconds_label'            => 'seconds',
    'show_error_details'       => 'Show error details',
    'error_type_col'           => 'Type',
    'error_id_col'             => 'ID',
    'error_msg_col'            => 'Error',
    'to_dashboard'             => 'To Dashboard',
    'show_book_list'           => 'Show Book List',
    'new_import'               => 'New Import',
    'no_import_yet'            => 'No import performed yet. Start the import in the previous step.',
    'click_load_preview'       => 'Click "Load Preview" to see the data.',
    'copies_abbr'              => 'copies',

    // User Management - Users pages (users-list, users-add, users-edit, users-sokrates-import)
    'user_management'            => 'User Management',
    'user_overview'              => 'User Overview',
    'new_user'                   => 'New User',
    'create_new_user'            => 'Create New User',
    'create_user_local'          => 'Create Local User',
    'local_user_desc'            => 'For teachers, external users and guests (without Active Directory).',
    'create_via_ldap'            => 'Create User via LDAP/Active Directory',
    'via_ldap_ad'                => 'Via LDAP/AD',
    'create_manually'            => 'Create Manually',
    'to_user_list'               => 'To User List',
    'create_user_subtitle'       => 'Create user manually or via LDAP',
    'search_name_email'          => 'Name, username, e-mail...',
    'phone'                      => 'Phone',
    'address'                    => 'Address',
    'birthday'                   => 'Date of Birth',
    'username_optional_hint'     => 'Optional (for login)',
    'password_min_hint'          => 'Minimum 8 characters, upper/lowercase, number and special character',
    'master_data'                => 'Master Data',
    'status_and_block'           => 'Status & Block',
    'block_reason'               => 'Block Reason',
    'blocked_until'              => 'Blocked Until',
    'blocked_until_empty'        => 'Empty = permanently blocked',
    'save_changes'               => 'Save Changes',
    'set_password'               => 'Set Password',
    'new_password'               => 'New Password',
    'user_info'                  => 'Info',
    'last_login'                 => 'Last Login',
    'created_at_label'           => 'Created',
    'loans_sidebar'              => 'Loans',
    'loans_active'               => 'Active',
    'loans_total'                => 'Total',
    'danger_zone'                => 'Danger Zone',
    'user_has_active_loans_msg'  => 'User has %d active loan(s) – cannot be deleted.',
    'delete_user'                => 'Delete User',
    'ldap_username_ad'           => 'Username (AD)',
    'ldap_search_label'          => 'Search Name',
    'ldap_search_placeholder'    => 'Last name or first name (min. 2 characters)...',
    'ldap_search_btn'            => 'Search',
    'ldap_create_user_panel'     => 'Create User',
    'ldap_no_results'            => 'No results found in Active Directory.',
    'ldap_not_enabled_msg'       => 'LDAP/Active Directory is not enabled.',
    'ldap_system_settings_link'  => 'Go to System Settings',
    'ldap_cannot_change_username'=> 'LDAP user – username cannot be changed',
    'security_error'             => 'Security error',
    'user_not_found'             => 'User not found',
    'invalid_user_id'            => 'Invalid user ID',
    'user_saved'                 => 'User saved successfully',
    'password_changed_success'   => 'Password changed successfully',
    'local_auth'                 => 'Local',
    'role'                       => 'Role',

    // Sokrates Import (users-sokrates-import.php)
    'sokrates_import_title'      => 'Sokrates Import',
    'sokrates_import_desc'       => 'Import student data from the Sokrates school management system',
    'sokrates_step_upload'       => 'Upload',
    'sokrates_step_preview'      => 'Preview',
    'sokrates_step_result'       => 'Result',
    'sokrates_step1_title'       => 'Step 1: Upload CSV File',
    'sokrates_step1_desc'        => 'Export the student list from Sokrates as a CSV file (semicolon-delimited).',
    'sokrates_step2_title'       => 'Step 2: Data Preview',
    'sokrates_step3_title'       => 'Step 3: Import Complete',
    'csv_file'                   => 'CSV File',
    'csv_expected_columns'       => 'Expected CSV Columns (Sokrates Export):',
    'csv_encoding_info'          => 'Encoding: UTF-8 or Windows-1252 detected automatically. Delimiter: semicolon.',
    'deactivate_missing_label'   => 'Set school leavers inactive:',
    'deactivate_missing_desc'    => 'Students present in the database but not in the CSV will be set to "inactive" status.',
    'upload_and_continue'        => 'Upload file and continue',
    'load_preview_sokrates'      => 'Load Preview',
    'start_import_sokrates'      => 'Start Import',
    'cancel_new_file'            => 'Cancel / New File',
    'sokrates_import_running'    => 'Import running...',
    'sokrates_import_running_desc' => 'Please do not close this window.',
    'total_in_csv'               => 'Total in CSV',
    'newly_created'              => 'Newly Created',
    'updated_label'              => 'Updated',
    'deactivated_label'          => 'Set Inactive',
    'unchanged_label'            => 'Unchanged',
    'warnings_label'             => 'Warnings',
    'new_import_sokrates'        => 'New Import',
    'import_action'              => 'Import',
    'preview_label'              => 'Preview',
    'map_columns'                => 'Map Columns',
    'skipped'                    => 'Skipped',
    'created_label'              => 'Created',
    'sokrates_reset_confirm'     => 'Reset wizard and delete file?',
    'sokrates_confirm_import'    => 'Start import now? Users will be created or updated.',
    'click_load_preview_sokrates'=> 'Click "Load Preview" to check the first 20 entries.',
    'deactivate_missing_badge'   => 'School leavers will be set inactive',

    // Settings – General (settings-general.php)
    'settings_general_title'     => 'Settings: General',
    'settings_general_subtitle'  => 'General Settings',
    'tab_general'                => 'General',
    'tab_data_management'        => 'Data Management',
    'tab_data_backup'            => 'Data Backup',
    'library_name'               => 'Library Name',
    'library_email'              => 'Library Email',
    'language'                   => 'Language',
    'language_in_preparation'    => 'Language switching in preparation',
    'footer_text'                => 'Footer Text',
    'session_section'            => 'Session',
    'session_timeout_minutes'    => 'Session Timeout (Minutes)',
    'session_timeout_help'       => 'Valid values: 5–480 min.',
    'save_settings'              => 'Save Settings',
    'data_management'            => 'Data Management',
    'data_management_desc'       => 'Retention periods and archiving',
    'activity_log_retention'     => 'Activity Log Retention (Years)',
    'activity_log_retention_help'=> 'Older entries are deleted automatically',
    'loan_history_archive'       => 'Loan History Archiving (Years)',
    'loan_history_archive_help'  => 'Older entries are moved to archive table',
    'data_backup'                => 'Data Backup',
    'db_size'                    => 'Database Size',
    'tables'                     => 'Tables',
    'last_backup'                => 'Last Backup',
    'create_backup'              => 'Create Backup',
    'create_backup_desc'         => 'SQL dump of the complete database',
    'method'                     => 'Method',
    'method_auto'                => 'Automatic',
    'mysqldump_available'        => 'mysqldump available',
    'php_fallback'               => 'PHP Fallback',
    'mysqldump_preferred'        => 'mysqldump preferred, PHP export as fallback',
    'php_export_pdo'             => 'PHP Export (PDO)',
    'php_export_no_tool'         => 'No external tool required',
    'options'                    => 'Options',
    'gzip_compression'           => 'gzip Compression',
    'gzip_smaller_file'          => 'Smaller file (.sql.gz)',
    'create_and_save_backup'     => 'Create & Save Backup',
    'saved_backups'              => 'Saved Backups',
    'no_backups_yet'             => 'No backups yet.',
    'filename'                   => 'Filename',
    'file_size'                  => 'Size',
    'created_col'                => 'Created',
    'newest'                     => 'newest',
    'download'                   => 'Download',
    'restore_database'           => 'Restore Database',
    'expand'                     => 'expand',
    'restore_warning'            => 'Warning! Restoration will overwrite all current data irreversibly. Make sure to create a current backup first.',
    'backup_file_label'          => 'Backup File',
    'confirm_restore_label'      => 'Confirmation: Enter YES',

    // Settings – Inventory (settings-inventory.php)
    'settings_inventory_title'   => 'Settings: Inventory Management',
    'settings_inventory_desc'    => 'Barcodes, ISBN API, Categories and Littera Import',
    'barcode_print_in_prep'      => 'Barcode printing is in preparation',
    'barcode_print_not_impl'     => 'Direct printing of barcode labels from the browser is not yet implemented. The following settings will be saved and used when barcode printing is rolled out.',
    'barcode_settings'           => 'Barcode Settings',
    'barcode_format'             => 'Barcode Format',
    'barcode_format_help'        => 'Code 128 recommended — supports all book numbers.',
    'label_format_label'         => 'Label Format',
    'isbn_api_desc'              => 'Automatic retrieval of book data when adding new books',
    'isbn_api_sources'           => 'Available Sources',
    'isbn_primary_api'           => 'Primary API',
    'isbn_primary_help'          => '(queried first)',
    'isbn_second_api'            => 'Second API',
    'isbn_second_help'           => '(supplements missing fields)',
    'isbn_use_both'              => 'Query both APIs',
    'isbn_use_both_help'         => 'Recommended: Each API provides different fields. DNB = metadata & keywords, Google/ISBN.de = cover & price. Together they produce a more complete record.',
    'isbn_timeout_label'         => 'Timeout per API (Seconds)',
    'isbn_timeout_help'          => 'When both APIs are enabled, the timeout applies per request.',
    'category_new'               => 'New Category',
    'category_edit'              => 'Edit Category',
    'category_create'            => 'Create',
    'no_categories'              => 'No categories found',
    'sort_order'                 => 'Sort Order',
    'active'                     => 'Active',
    'yes_short'                  => 'yes',
    'no_short'                   => 'no',
    'confirm_delete_category'    => 'Really delete category?',
    'littera_settings_title'     => 'Littera Import',
    'littera_settings_desc'      => 'Import books and copies from the legacy system Littera (Microsoft Access / Jet database). The import wizard guides you through several steps — from checking the CSV source files to importing into the database.',
    'littera_requirements'       => 'Requirements',
    'littera_required_files'     => 'Required files:',
    'go_to_littera_import'       => 'Go to Littera Import Wizard',
    'subcategories_tab'          => 'Subcategories',
    'subcategory_new'            => 'New Subcategory',
    'subcategory_edit'           => 'Edit Subcategory',
    'no_entries'                 => 'No entries',
    'confirm_delete_subcategory' => 'Really delete subcategory?',

    // Settings – Users (settings-users.php)
    'settings_users_title'       => 'Settings: User Management',
    'settings_users_desc'        => 'User groups and LDAP/Active Directory',
    'user_groups'                => 'User Groups',
    'tab_user_groups'            => 'User Groups',
    'tab_ldap'                   => 'LDAP / Active Directory',
    'groups_inline_edit_hint'    => 'Make changes directly in the table and confirm with',
    'max_loans_short'            => 'Max. Loans',
    'loan_duration_days'         => 'Loan Duration (Days)',
    'extend'                     => 'Extend',
    'max_extensions'             => 'Max. Extensions',
    'reserve'                    => 'Reserve',
    'users_count'                => 'Users',
    'unlimited_hint'             => 'empty = unlimited',
    'description'                => 'Description',
    'no_groups'                  => 'No groups found',
    'create_new_group'           => 'Create New Group',
    'extend_allowed'             => 'Extension allowed',
    'reserve_allowed'            => 'Reservation allowed',
    'create_group'               => 'Create Group',
    'ldap_ad_title'              => 'LDAP / Active Directory',
    'ldap_ad_desc'               => 'Authentication against Active Directory',
    'ldap_on_demand_title'       => 'On-Demand User Creation',
    'ldap_on_demand_desc'        => 'LDAP users are not bulk-synchronized. They are automatically created in the database on the first loan transaction, or merged with an existing Sokrates import record.',
    'connection_settings'        => 'Connection Settings',
    'user_attributes'            => 'User Attributes',
    'group_has_users'            => 'Group has assigned users',
    'confirm_delete_group'       => 'Really delete group? This action cannot be undone.',
    'confirm'                    => 'confirm',
    'groups_heading'             => 'Groups',
    'description_optional'      => 'Description (optional)',
    'name_required'              => 'Name is required.',
    'name_already_taken'         => 'Name is already taken.',
    'group_saved'                => 'Group saved.',
    'group_created'              => 'Group created.',
    'group_deleted'              => 'Group deleted.',
    'group_delete_has_users'     => 'Group cannot be deleted: %d users assigned.',
    'ldap_settings_saved'        => 'LDAP settings saved.',
    'testing'                    => 'Testing...',
    'ldap_test_error'            => 'Connection test error.',
    'smtp_port_label'            => 'Port',

    // Settings – Lending (settings-lending.php)
    'settings_lending_title'     => 'Settings: Lending Management',
    'settings_lending_desc'      => 'Loan parameters and Email / SMTP configuration',
    'tab_loans'                  => 'Loans',
    'tab_email_smtp'             => 'Email / SMTP',
    'loan_settings'              => 'Loan Settings',
    'loan_settings_desc'         => 'System-wide defaults. Different values can be set per user group.',
    'default_loan_duration'      => 'Default Loan Duration (Days)',
    'default_loan_duration_help' => 'Fallback when group has no own duration',
    'max_extensions_default'     => 'Max. Extensions (Default)',
    'max_loans_default'          => 'Max. Loans per User (Default)',
    'reminders'                  => 'Reminders',
    'reminders_enabled'          => 'Reminders enabled',
    'reminder_after_days'        => 'Reminder after X days overdue',
    'reminder_after_days_help'   => 'Days after loan period expires',
    'reminder_frequency'         => 'Repeat Frequency',
    'frequency_daily'            => 'Daily',
    'frequency_weekly'           => 'Weekly',
    'frequency_monthly'          => 'Monthly',
    'email_smtp'                 => 'Email / SMTP',
    'email_smtp_desc'            => 'Configuration for email sending (reminders, notifications)',
    'smtp_enable'                => 'Enable SMTP',
    'smtp_host'                  => 'SMTP Server',
    'smtp_port_help'             => '587 (STARTTLS) or 465 (SSL)',
    'smtp_username'              => 'Username',
    'smtp_password_label'        => 'Password',
    'sender_email'               => 'Sender Email',
    'sender_name'                => 'Sender Name',
    'test_email_section'         => 'Test Email',
    'test_email_desc'            => 'Sends a test email to the library email address configured under Settings → General',
    'not_configured_yet'         => '(not yet configured)',
    'send_test_email'            => 'Send Test Email',
    'loan_settings_saved'        => 'Loan settings saved.',
    'smtp_settings_saved'        => 'Email settings saved.',
    'sending'                    => 'Sending...',
    'network_error_test'         => 'Network error during test.',
    'security_error_retry'       => 'Security error. Please try again.',
    'invalid_input'              => 'Invalid input.',

    // Books - Edit Detail (books-edit-detail.php)
    'title_data'               => 'Title Data',
    'subtitle_field'           => 'Subtitle',
    'title_sort_field'         => 'Sort Form',
    'title_sort_hint'          => 'Title without article',
    'involved_persons'         => 'Involved Persons',
    'author_name_placeholder'  => 'Last Name First Name',
    'author_abbr_field'        => 'Abbreviation (Author)',
    'author_abbr_placeholder'  => 'e.g. Boe',
    'additional_authors'       => 'Additional Authors',
    'comma_separated'          => 'comma-separated',
    'show_extra_fields'        => '+ Editor, Translator, Illustrators…',
    'hide_extra_fields'        => '− Collapse extra fields',
    'editor_field'             => 'Editor',
    'translator_field'         => 'Translator',
    'illustrator_field'        => 'Illustrator',
    'photographer_field'       => 'Photographer',
    'graphic_artist_field'     => 'Graphic Artist',
    'other_persons_field'      => 'Other',
    'publication'              => 'Publication',
    'place_of_publication'     => 'Place of Publication',
    'edition_field'            => 'Edition',
    'edition_placeholder'      => 'e.g. 3rd ed.',
    'page_count'               => 'Pages',
    'price_field'              => 'Price (€)',
    'price_placeholder'        => 'e.g. 24.90',
    'series_volume_field'      => 'Series / Volume',
    'series'                   => 'Series',
    'volume_abbr'              => 'Vol.',
    'category_and_content'     => 'Category & Content',
    'choose_category'          => '— Choose category —',
    'subgroup_field'           => 'Subgroup',
    'choose_subgroup'          => '— Choose subgroup —',
    'no_subgroups'             => '— no subgroups —',
    'keywords'                 => 'Keywords',
    'keywords_placeholder'     => 'e.g. Novel, Austria, 20th century',
    'cover_image'              => 'Cover Image',
    'no_cover'                 => 'No Cover',
    'cover_url'                => 'Cover URL',
    'copies'                   => 'Copies',
    'print_all_labels'         => 'Print all labels',
    'add_new_copy'             => 'New',
    'copy_number_abbr'         => 'No.',
    'no_copies_available'      => 'No copies available',
    'due_date_prefix'          => 'due',
    'metadata'                 => 'Metadata',
    'book_id_field'            => 'Book ID',
    'created_field'            => 'Created',
    'created_by_prefix'        => 'by',
    'last_modified'            => 'Last Modified',
    'cover_search_enter_isbn'  => 'Please enter an ISBN first.',
    'cover_search_running'     => 'Searching…',
    'cover_found'              => 'Cover found.',
    'cover_not_found'          => 'No cover found.',
    'cover_search_error'       => 'Error during lookup.',

    // Books - Add Book (books-add.php)
    'book_saved_success'         => 'Book saved successfully',
    'book_saved_id'              => 'The book was created with ID #%s.',
    'add_next_book'              => 'Add next book',
    'view_edit_book'             => 'View / edit book',
    'isbn_scan_enter'            => 'Scan / enter ISBN',
    'isbn_placeholder'           => 'Scan or enter ISBN…',
    'isbn_clear_form'            => 'Clear form',
    'isbn_searching'             => 'Searching…',
    'isbn_duplicate_notice'      => 'This book is already in the collection — an additional copy will be added',
    'isbn_cancel_clear'          => 'Cancel / Clear form',
    'isbn_test_label'            => 'Test:',
    'isbn_auto_filled'           => 'Filled automatically',
    'copy_section'               => 'Copy',
    'category_choose'            => 'Choose category',
    'subcategory_label'          => 'Subgroup',
    'subcategory_choose_first'   => 'choose category first',
    'subcategory_choose'         => 'Choose subgroup',
    'subcategory_no_subcats'     => 'no subgroups',
    'location_placeholder'       => 'e.g. Shelf A3',
    'title_data_section'         => 'Title Data',
    'title_sort_label'           => 'Sort Form',
    'title_sort_help'            => 'Title without article for sorting',
    'persons_section'            => 'Involved Persons',
    'author_placeholder'         => 'Last Name First Name',
    'author_short_label'         => 'Abbreviation',
    'author_short_placeholder'   => 'e.g. Boe',
    'show_extra_persons'         => 'Editor, Translator, Illustrators…',
    'hide_extra_persons'         => 'Collapse extra fields',
    'editor_label'               => 'Editor',
    'translator_label'           => 'Translator',
    'illustrator_label'          => 'Illustrator',
    'photographer_label'         => 'Photographer',
    'graphic_artist_label'       => 'Graphic Artist',
    'other_persons_label'        => 'Other',
    'publication_section'        => 'Publication',
    'place_of_publication_label' => 'Place of Publication',
    'edition_label'              => 'Edition',
    'pages_label'                => 'Pages',
    'lang_other'                 => 'Other',
    'price_label'                => 'Price (€)',
    'series_volume_label'        => 'Series / Volume',
    'series_placeholder'         => 'Series',
    'series_volume_placeholder'  => 'Vol.',
    'content_section'            => 'Content & Indexing',
    'keywords_label'             => 'Keywords',
    'description_label'          => 'Description',
    'save_book_btn'              => 'Save book',
    'save_hint_prefix'           => 'The book will be saved with book number',
    'save_hint_suffix'           => 'as the first copy.',
    'cover_source_link'          => 'Open cover source',

    // Lending – Reservations (lending-reservations.php)
    'reservations_title'              => 'Reservations',
    'reservations_subtitle'           => 'Manage and edit book reservations',
    'new_reservation_btn'             => '+ New Reservation',
    'new_reservation_panel_title'     => 'Create New Reservation',
    'res_user_label'                  => 'User',
    'res_user_placeholder'            => 'Name, class or ID card no....',
    'res_book_label'                  => 'Book',
    'res_book_placeholder'            => 'Title, author or ISBN...',
    'res_switch_user'                 => 'change',
    'res_switch_book'                 => 'change',
    'res_create_btn'                  => 'Create Reservation',
    'res_stat_active_waiting'         => 'Actively waiting',
    'res_stat_ready_pickup'           => 'Ready for pickup',
    'res_stat_completed'              => 'Completed',
    'res_tab_all'                     => 'Active & Ready',
    'res_tab_waiting'                 => 'Waiting',
    'res_tab_ready'                   => 'Ready',
    'res_tab_history'                 => 'History',
    'res_col_user'                    => 'User',
    'res_col_book'                    => 'Book',
    'res_col_reserved_date'           => 'Reserved',
    'res_col_position'                => 'Position / Note',
    'res_notified_label'              => 'Notified:',
    'res_badge_waiting'               => 'waiting',
    'res_badge_ready'                 => 'ready',
    'res_badge_picked_up'             => 'picked up',
    'res_badge_expired'               => 'expired',
    'res_badge_cancelled'             => 'cancelled',
    'res_position_label'              => 'Position',
    'res_copy_assigned'               => 'Copy assigned',
    'res_completed_label'             => 'completed',
    'res_checkout_btn'                => 'Check out',
    'res_not_picked_up_btn'           => 'Not picked up',
    'res_count_singular'              => 'reservation shown',
    'res_count_plural'                => 'reservations shown',
    'res_none_found'                  => 'No reservations found.',
    'res_modal_title'                 => 'Check Out from Reservation',
    'res_modal_note_label'            => 'Note (optional)',
    'res_modal_note_placeholder'      => 'e.g. book condition...',
    'res_success_created_available'   => 'Reservation created – copy available immediately!',
    'res_success_created_waiting'     => 'Reservation created – user is waiting in the queue.',
    'res_js_booked'                   => 'Loan #%s booked – due by %s',
    'res_js_confirm_cancel'           => 'Really cancel reservation?',
    'res_js_confirm_expire'           => 'Mark reservation as "not picked up" / expired?',
    'res_js_error_prefix'             => 'Error:',
    'res_js_network_error'            => 'Network error:',
    'res_js_booking'                  => 'Processing...',
    'res_js_searching'                => 'Searching...',
    'res_js_no_results'               => 'No results',
    'res_js_available_count'          => 'available',
    'res_js_all_loaned'               => 'all on loan',
];
