<?php
/**
 * German Language File
 * All translatable strings
 */

return [
    // Login
    'login_title' => 'Anmelden',
    'login_subtitle' => 'Melden Sie sich an, um fortzufahren',
    'login_username' => 'Benutzername oder E-Mail',
    'login_username_placeholder' => 'admin',
    'login_password' => 'Passwort',
    'login_password_placeholder' => '••••••••',
    'login_remember' => 'Angemeldet bleiben',
    'login_button' => 'Anmelden',
    'login_error' => 'Benutzername oder Passwort falsch',
    'session_expired' => 'Ihre Sitzung ist abgelaufen. Bitte melden Sie sich erneut an.',
    'ldap_enabled_notice' => 'LDAP-Anmeldung aktiviert',
    
    // Dashboard
    'dashboard_title' => 'Dashboard',
    'dashboard_welcome' => 'Willkommen zurück',
    'dashboard_search_placeholder' => 'Suche nach Titel, Autor, ISBN...',
    'dashboard_new_books' => 'Neue Bücher',
    'dashboard_popular_books' => 'Beliebteste Bücher',
    'dashboard_my_loans' => 'Meine Ausleihen',
    'dashboard_my_reservations' => 'Meine Vormerkungen',
    'dashboard_no_loans' => 'Sie haben aktuell keine ausgeliehenen Bücher',
    'dashboard_no_reservations' => 'Sie haben keine aktiven Vormerkungen',
    
    // Navigation
    'nav_dashboard' => 'Dashboard',
    'nav_search' => 'Bücher suchen',
    'nav_my_account' => 'Mein Konto',
    'nav_admin_area' => 'Admin-Bereich',
    'nav_logout' => 'Abmelden',
    'nav_profile' => 'Profil',
    'nav_settings' => 'Einstellungen',
    
    // Books
    'book_title' => 'Titel',
    'book_author' => 'Autor',
    'book_isbn' => 'ISBN',
    'book_publisher' => 'Verlag',
    'book_year' => 'Jahr',
    'book_category' => 'Kategorie',
    'book_language' => 'Sprache',
    'book_available' => 'Verfügbar',
    'book_unavailable' => 'Ausgeliehen',
    'book_copies_available' => '{count} von {total} verfügbar',
    'book_reserve' => 'Vormerken',
    'book_details' => 'Details anzeigen',
    
    // Loans
    'loan_due_date' => 'Fällig am',
    'loan_loaned_on' => 'Ausgeliehen am',
    'loan_extend' => 'Verlängern',
    'loan_return' => 'Zurückgeben',
    'loan_overdue' => 'Überfällig',
    'loan_days_left' => '{days} Tage',
    'loan_today' => 'Heute',
    'loan_tomorrow' => 'Morgen',
    
    // Reservations
    'reservation_position' => 'Position {position}',
    'reservation_ready' => 'Bereit zur Abholung',
    'reservation_waiting' => 'Wartend',
    'reservation_until' => 'Abholen bis',
    'reservation_cancel' => 'Stornieren',
    
    // Admin
    'admin_dashboard' => 'Admin-Dashboard',
    'admin_books' => 'Bestandsverwaltung',
    'admin_lending' => 'Verleihverwaltung',
    'admin_users' => 'Benutzerverwaltung',
    'admin_reports' => 'Berichte',
    'admin_settings' => 'Einstellungen',
    
    // Common
    'save' => 'Speichern',
    'cancel' => 'Abbrechen',
    'delete' => 'Löschen',
    'edit' => 'Bearbeiten',
    'add' => 'Hinzufügen',
    'search' => 'Suchen',
    'filter' => 'Filtern',
    'back' => 'Zurück',
    'next' => 'Weiter',
    'previous' => 'Zurück',
    'close' => 'Schließen',
    'yes' => 'Ja',
    'no' => 'Nein',
    'loading' => 'Lädt...',
    'error' => 'Fehler',
    'success' => 'Erfolgreich',
    'warning' => 'Warnung',
    'info' => 'Information',
    
    // Messages
    'msg_saved_successfully' => 'Erfolgreich gespeichert',
    'msg_deleted_successfully' => 'Erfolgreich gelöscht',
    'msg_error_occurred' => 'Ein Fehler ist aufgetreten',
    'msg_confirm_delete' => 'Möchten Sie dies wirklich löschen?',
    'msg_no_results' => 'Keine Ergebnisse gefunden',
    
    // Date & Time
    'date_today' => 'Heute',
    'date_yesterday' => 'Gestern',
    'date_tomorrow' => 'Morgen',
    'time_minutes_ago' => 'vor {minutes} Minuten',
    'time_hours_ago' => 'vor {hours} Stunden',
    'time_days_ago' => 'vor {days} Tagen',
    
    // Dashboard
    'welcome' => 'Willkommen',
    'dashboard_subtitle' => 'Hier ist eine Übersicht über Ihre Bibliotheksaktivitäten',
    'current_loans' => 'Aktuelle Ausleihen',
    'overdue_loans' => 'Überfällig',
    'total_loans' => 'Gesamt ausgeliehen',
    'quick_search' => 'Schnellsuche',
    'search_placeholder' => 'Titel, Autor, ISBN...',
    'my_loans' => 'Meine Ausleihen',
    'my_reservations' => 'Meine Vormerkungen',
    'no_active_loans' => 'Keine aktiven Ausleihen',
    'no_active_reservations' => 'Keine aktiven Vormerkungen',
    'days_overdue' => 'Tage überfällig',
    'days_remaining' => 'Tage verbleibend',
    'book_number' => 'Buchnr.',
    'view_all_loans' => 'Alle Ausleihen anzeigen',
    'view_all_reservations' => 'Alle Vormerkungen anzeigen',
    'position' => 'Position',
    'new_books' => 'Neue Bücher',
    'popular_books' => 'Beliebte Bücher',
    'no_new_books' => 'Keine neuen Bücher',
    'no_popular_books' => 'Keine Daten verfügbar',
    'available' => 'Verfügbar',
    
    // Navigation
    'nav_dashboard' => 'Dashboard',
    'nav_search' => 'Suchen',
    'nav_admin_area' => 'Admin',
    'nav_profile' => 'Profil',
    'nav_logout' => 'Abmelden',
    
    // Admin Area
    'admin_area' => 'Admin-Bereich',
    'admin_dashboard' => 'Dashboard',
    'admin_inventory_mgmt' => 'Bestandsverwaltung',
    'admin_add_book' => 'Buch erfassen',
    'admin_edit_books' => 'Bücher bearbeiten',
    'admin_delete_books' => 'Bücher ausscheiden',
    'admin_print_labels' => 'Etiketten drucken',
    'admin_users_overview' => 'Übersicht',
    'admin_sokrates_import' => 'Sokrates Import',
    'admin_settings_general' => 'Allgemein',
    'user_dashboard' => 'User-Dashboard',
    'admin_categories' => 'Kategorien',
    'admin_lending_mgmt' => 'Verleihverwaltung',
    'admin_checkout' => 'Ausleihe',
    'admin_return' => 'Rückgabe',
    'admin_active_loans' => 'Aktive Ausleihen',
    'admin_reminders' => 'Mahnungen',
    'admin_reservations' => 'Vormerkungen',
    'admin_inventory' => 'Inventur',
    'admin_inventory_start' => 'Inventur starten',
    'admin_inventory_ongoing' => 'Laufende Inventur',
    'admin_inventory_history' => 'Inventurhistorie',
    'admin_user_mgmt' => 'Benutzerverwaltung',
    'admin_create_user' => 'Benutzer anlegen',
    'admin_ldap_sync' => 'LDAP-Sync',
    'admin_reports' => 'Statistiken & Berichte',
    'admin_lending_stats' => 'Ausleihstatistik',
    'admin_inventory_overview' => 'Bestandsübersicht',
    'admin_report_generator' => 'Reportgenerator',
    'admin_settings' => 'Einstellungen',
    'admin_system_settings' => 'Systemeinstellungen',
    'admin_backup' => 'Datenbackup',
    'admin_import' => 'Datenimport',
    'back_to_dashboard' => 'Zurück zum Dashboard',
    
    // Admin Dashboard
    'admin_total_books' => 'Bücher Gesamt',
    'admin_available' => 'Verfügbar',
    'admin_overdue' => 'Überfällig',
    'admin_quick_actions' => 'Schnellzugriff',
    'admin_add_book_desc' => 'Neues Buch hinzufügen',
    'admin_checkout_desc' => 'Buch ausleihen',
    'admin_return_desc' => 'Buch zurücknehmen',
    'admin_overdue_loans' => 'Überfällige Ausleihen',
    'admin_no_overdue' => 'Keine überfälligen Ausleihen',
    'admin_pending_reservations' => 'Wartende Vormerkungen',
    'admin_no_reservations' => 'Keine wartenden Vormerkungen',
    'admin_recent_activity' => 'Letzte Aktivitäten',
    'admin_no_activity' => 'Keine Aktivitäten',
    'days_waiting' => 'Tage wartend',
    'view_all' => 'Alle anzeigen',
    
    // Footer Settings (Phase 5)
    'footer_text_label' => 'Fußtzeilen-Text',
    'footer_text_help' => 'Text der in der Fußzeile angezeigt wird',
    
    // User Management (Phase 4)
    'create_user' => 'Benutzer anlegen',
    'edit_user' => 'Benutzer bearbeiten',
    'user_list' => 'Benutzerliste',
    'users' => 'Benutzer',
    'username' => 'Benutzername',
    'email' => 'E-Mail',
    'first_name' => 'Vorname',
    'last_name' => 'Nachname',
    'user_group' => 'Benutzergruppe',
    'status' => 'Status',
    'status_active' => 'Aktiv',
    'status_blocked' => 'Gesperrt',
    'status_inactive' => 'Inaktiv',
    'class_name' => 'Klasse',
    'student_id' => 'Schüler-ID',
    'password' => 'Passwort',
    'password_confirm' => 'Passwort bestätigen',
    'change_password' => 'Passwort ändern',
    'password_leave_empty' => 'Leer lassen um Passwort nicht zu ändern',
    'password_requirements' => 'Mindestens 8 Zeichen',
    'update_user' => 'Benutzer aktualisieren',
    'all_groups' => 'Alle Gruppen',
    'all_statuses' => 'Alle Status',
    'filter' => 'Filtern',
    'name' => 'Name',
    'group' => 'Gruppe',
    'auth_method' => 'Auth',
    'actions' => 'Aktionen',
    'edit' => 'Bearbeiten',
    'delete' => 'Löschen',
    'no_users_found' => 'Keine Benutzer gefunden',
    'cancel' => 'Abbrechen',
    'search_placeholder' => 'Suche...',
    'showing' => 'Zeige',
    'to' => 'bis',
    'of' => 'von',
    'results' => 'Ergebnissen',
    'previous' => 'Zurück',
    'next' => 'Weiter',
    
    // User Management Errors
    'error_username_required' => 'Benutzername erforderlich',
    'error_email_required' => 'E-Mail erforderlich',
    'error_email_invalid' => 'Ungültige E-Mail-Adresse',
    'error_password_required' => 'Passwort erforderlich',
    'error_password_mismatch' => 'Passwörter stimmen nicht überein',
    'error_password_too_short' => 'Passwort muss mindestens 8 Zeichen lang sein',
    'error_first_name_required' => 'Vorname erforderlich',
    'error_last_name_required' => 'Nachname erforderlich',
    'error_username_exists' => 'Benutzername existiert bereits',
    'error_email_exists' => 'E-Mail-Adresse existiert bereits',
    'error_user_create_failed' => 'Fehler beim Anlegen des Benutzers',
    'error_user_update_failed' => 'Fehler beim Aktualisieren des Benutzers',
    'error_user_delete_failed' => 'Fehler beim Löschen des Benutzers',
    'error_user_has_loans' => 'Benutzer hat noch %d aktive Ausleihen und kann nicht gelöscht werden',
    
    // User Management Success
    'success_user_created' => 'Benutzer "%s" wurde erfolgreich angelegt',
    'success_user_updated' => 'Benutzer "%s" wurde erfolgreich aktualisiert',
    'success_user_deleted' => 'Benutzer "%s" wurde erfolgreich gelöscht',
    'confirm_delete_user' => 'Möchten Sie diesen Benutzer wirklich löschen?',
    
    // LDAP Sync
    'ldap_status' => 'LDAP-Status',
    'ldap_status_desc' => 'Aktuelle LDAP-Konfiguration und Sync-Status',
    'enabled' => 'Aktiviert',
    'disabled' => 'Deaktiviert',
    'ldap_users' => 'LDAP-Benutzer',
    'ldap_configuration' => 'LDAP-Konfiguration',
    'ldap_configuration_desc' => 'Verbindung zu LDAP/Active Directory konfigurieren',
    'enable_ldap' => 'LDAP-Authentifizierung aktivieren',
    'ldap_connection_settings' => 'Verbindungseinstellungen',
    'ldap_host' => 'LDAP-Server',
    'ldap_host_help' => 'Hostname oder IP-Adresse des LDAP-Servers',
    'ldap_port' => 'Port',
    'ldap_port_help' => 'Standard: 389 (LDAP) oder 636 (LDAPS)',
    'ldap_base_dn' => 'Base DN',
    'ldap_base_dn_help' => 'Basis-DN für die Benutzersuche',
    'ldap_bind_dn' => 'Bind DN',
    'ldap_bind_dn_help' => 'DN des Benutzerkontos für die LDAP-Suche',
    'ldap_bind_password' => 'Bind Passwort',
    'ldap_bind_password_help' => 'Passwort für Bind-DN',
    'leave_empty_to_keep' => 'Leer lassen um beizubehalten',
    'ldap_user_mapping' => 'Benutzer-Mapping',
    'ldap_user_filter' => 'Benutzer-Filter',
    'ldap_user_filter_help' => 'LDAP-Filter für Benutzersuche',
    'ldap_username_attr' => 'Benutzername-Attribut',
    'ldap_email_attr' => 'E-Mail-Attribut',
    'ldap_firstname_attr' => 'Vorname-Attribut',
    'ldap_lastname_attr' => 'Nachname-Attribut',
    'ldap_group_attr' => 'Gruppen-Attribut',
    'ldap_group_attr_help' => 'Attribut für Gruppenmitgliedschaft (noch nicht implementiert)',
    'test_connection' => 'Verbindung testen',
    'save_configuration' => 'Konfiguration speichern',
    'ldap_sync_actions' => 'Synchronisierung',
    'ldap_sync_desc' => 'Benutzer aus LDAP/Active Directory importieren',
    'ldap_sync_info' => 'Der Sync importiert alle Benutzer aus LDAP. Bestehende LDAP-Benutzer werden aktualisiert, lokale Benutzer bleiben unverändert.',
    'ldap_current_users' => 'Aktuelle LDAP-Benutzer',
    'start_sync' => 'Sync starten',
    'ldap_disabled_notice' => 'LDAP ist deaktiviert. Bitte aktivieren Sie LDAP in der Konfiguration oben, um die Synchronisierung zu nutzen.',
    
    // LDAP Errors
    'error_ldap_not_available' => 'LDAP-Extension ist nicht verfügbar. Bitte PHP LDAP-Modul installieren.',
    'error_ldap_connection_failed' => 'LDAP-Verbindung fehlgeschlagen. Bitte Host und Port prüfen.',
    'error_ldap_bind_failed' => 'LDAP-Bind fehlgeschlagen. Bitte Bind-DN und Passwort prüfen.',
    'error_ldap_not_enabled' => 'LDAP ist nicht aktiviert',
    'error_ldap_search_failed' => 'LDAP-Suche fehlgeschlagen',
    
    // LDAP Success
    'success_ldap_config_saved' => 'LDAP-Konfiguration wurde gespeichert',
    'success_ldap_connection' => 'LDAP-Verbindung erfolgreich!',
    'success_ldap_sync' => 'LDAP-Sync abgeschlossen: %d gefunden, %d erstellt, %d aktualisiert, %d übersprungen',
    'confirm_ldap_sync' => 'Möchten Sie die LDAP-Synchronisierung starten? Dies kann einige Minuten dauern.',
    'errors' => 'Fehler',

    // Label Print (Barcode-Etikettendruck)
    'label_print_title'               => 'Signatur-Etiketten drucken',
    'label_settings_heading'          => 'Einstellungen',
    'label_format'                    => 'Etikettenformat',
    'label_format_avery3651'          => 'AVERY 3651 (52,5 × 29,7 mm · 4×10 / A4)',
    'label_format_avery3657'          => 'AVERY 3657 (48,5 × 25,4 mm · 4×12 / A4)',
    'label_format_brother_ql'         => 'Brother QL-810W (62 × 29 mm · 1 Etikett/Seite)',
    'label_copies_selection'          => 'Exemplare',
    'label_start_position'            => 'Startposition',
    'label_start_position_empty_hint' => 'leere Felder am Anfang',
    'label_start_position_used_sheets'=> 'Für bereits teilweise verwendete Bögen',
    'label_start_position_help'       => 'Überspringt die ersten N Felder auf dem Bogen (für bereits teilweise verwendete Bögen)',
    'label_print_button'              => 'Drucken',
    'label_preview'                   => 'Vorschau',
    'label_preview_hint'              => 'Zeigt die ersten 2 Reihen (nicht maßstabsgetreu)',
    'label_select_all'                => 'Alle',
    'label_deselect_all'              => 'Keine',
    'label_no_copies'                 => 'Keine Exemplare gefunden.',
    'label_no_copies_url_hint'        => 'Bitte <code>book_id</code>, <code>copy_id</code> oder <code>copy_ids</code> als URL-Parameter angeben.',
    'label_print_hint'                => 'Im Druckdialog "Tatsächliche Größe" (kein Skalieren) und Ränder = 0 wählen.',
    'label_print_brother_hint'        => 'Im Druckdialog Papierformat 62 mm × 29 mm ohne Seitenränder wählen.',
    'label_copies_per_exemplar'       => 'Kopien je Exemplar',
    'label_js_none_selected'          => 'Keine Exemplare ausgewählt',
    'label_js_select_min_one'         => 'Bitte mindestens ein Exemplar ausw\u00e4hlen.',
    'label_js_count_showing'          => 'Zeige %d von %d Etiketten (%d Exemplare)',
    'label_js_count_total'            => '%d Etikett(en) (%d Exemplar(e))',
    'print_label'                     => 'Etikett drucken',
    'label_search_heading'            => 'Buch suchen',
    'label_search_placeholder'        => 'Titel, Autor oder ISBN…',
    'label_search_btn'                => 'Suchen',
    'label_book_number_heading'       => 'oder Buchungsnummer direkt eingeben',
    'label_book_number_placeholder'   => 'z.B. 14613…',
    'label_book_number_btn'           => 'Etikett drucken',
    'label_search_no_results'         => 'Keine Bücher gefunden für',
    'label_search_copies_count'       => 'Exemplar(e)',
    'label_print_all_btn'             => 'Alle Etiketten',

    // Books - Add Copy (books-add-copy.php)
    'add_copy'               => 'Exemplar hinzufügen',
    'invalid_book_id'        => 'Ungültige Buch-ID',
    'book_not_found'         => 'Buch nicht gefunden',
    'book_label'             => 'Buch',
    'copies_existing'        => 'Exemplar vorhanden',
    'copies_existing_plural' => 'Exemplare vorhanden',
    'copy_added_success'     => 'Exemplar erfolgreich hinzugefügt',
    'book_number_required'   => 'Buchungsnummer ist ein Pflichtfeld',
    'book_number_taken'      => 'Buchungsnummer ist bereits vergeben',
    'new_copy_form'          => 'Neues Exemplar erfassen',
    'book_number_field'      => 'Buchungsnummer',
    'suggested'              => 'Vorgeschlagen',
    'signature'              => 'Signatur',
    'location'               => 'Standort',
    'acquired_at'            => 'Zugangsdatum',
    'condition_note'         => 'Zustand / Notiz',
    'save_copy'              => 'Exemplar speichern',
    'to_book'                => 'Zum Buch',
    'add_another_copy'       => 'Weiteres Exemplar',
    'number_available'       => 'Verfügbar',
    'number_taken'           => 'Bereits vergeben',

    // Books - Edit List (books-edit.php)
    'books'                  => 'Bücher',
    'books_total'            => 'Bücher insgesamt',
    'books_found'            => 'Bücher gefunden',
    'add_new_book'           => 'Neues Buch',
    'fulltext_search_label'  => 'Volltextsuche (Titel, Autor, ISBN, Schlagworte, Beschreibung, Standort, Buchnummer…)',
    'search_input_hint'      => 'Suchbegriff eingeben…',
    'per_page'               => 'Pro Seite',
    'reset_filter'           => 'Zurücksetzen',
    'book_abbr_nr'           => 'BuchNr',
    'author_abbr'            => 'Kürzel',
    'subtitle'               => 'Untertitel',
    'no_copies'              => 'kein Exemplar',
    'all_on_loan'            => 'alle ausgeliehen',
    'available_of'           => 'verfügbar',
    'no_books_found'         => 'Keine Bücher gefunden für',
    'no_books_in_db'         => 'Keine Bücher in der Datenbank.',
    'fulltext_label'         => 'Volltext',
    'hits'                   => 'Treffer',
    'search_label'           => 'Suche',

    // Books - Delete (books-delete.php)
    'delete_book'            => 'Buch löschen',
    'confirm_delete_book'    => 'Buch wirklich löschen?',
    'back_to_overview'       => 'Zurück zur Übersicht',
    'book_info'              => 'Buchinfo',
    'book_number_ids'        => 'Buchungsnummern',
    'cannot_delete_book'     => 'Buch kann nicht gelöscht werden!',
    'copies_still_loaned'    => 'Exemplar(e) sind noch ausgeliehen. Bitte erst alle Exemplare zurückbuchen.',
    'warning_irreversible'   => 'Achtung: Diese Aktion kann nicht rückgängig gemacht werden!',
    'book_permanently_deleted' => 'Das Buch wird unwiderruflich gelöscht',
    'all_copies_deleted'     => 'Alle Exemplare werden gelöscht',
    'loan_history_deleted'   => 'Der Ausleih-Verlauf wird gelöscht',
    'confirm_delete_final'   => 'Ja, Buch endgültig löschen',
    'back_to_book_list'      => 'Zurück zur Bücherliste',
    'copies_count_label'     => 'Exemplar',
    'copies_count_plural'    => 'Exemplare',
    'loan_history_entries'   => 'Einträge',
    'year_label'             => 'Jahr',

    // Books - Remove / Discard (books-remove.php)
    'remove_book'                      => 'Bücher ausscheiden',
    'no_copies_selected'               => 'Keine Exemplare ausgewählt.',
    'enter_book_numbers'               => 'Buchungsnummern eingeben',
    'enter_book_numbers_help'          => 'Tragen Sie die Buchungsnummern der auszuscheidenden Exemplare ein — mehrere Nummern durch Komma, Strichpunkt oder Leerzeichen trennen.',
    'book_numbers_label'               => 'Buchungsnummern',
    'show_preview'                     => 'Vorschau anzeigen',
    'preview_heading'                  => 'Vorschau',
    'copies_discard_label'             => 'Exemplar ausscheiden',
    'copies_discard_plural'            => 'Exemplare ausscheiden',
    'status_discarded'                 => 'ausgeschieden',
    'book_data_preserved'              => 'Die Buchdaten bleiben erhalten.',
    'book_nr_col'                      => 'Buchungsnr.',
    'title_col'                        => 'Titel',
    'author_col'                       => 'Autor',
    'check_list_warning'               => 'Bitte prüfen Sie die Liste sorgfältig.',
    'discarded_cannot_loan'            => 'Ausgeschiedene Exemplare können nicht mehr ausgeliehen werden. Die Buchungsnummern bleiben in der Datenbank erhalten.',
    'confirm_remove'                   => 'Endgültig ausscheiden',
    'number_not_found'                 => 'nicht gefunden.',
    'already_discarded'                => 'ist bereits ausgeschieden.',
    'currently_on_loan'                => 'ist derzeit ausgeliehen.',
    'copies_removed_success'           => 'erfolgreich ausgeschieden.',
    'copies_still_on_loan_err'         => 'Exemplar(e) sind noch ausgeliehen und können nicht ausgeschieden werden.',
    'to_book_list'                     => 'Zur Bücherliste',

    // Books - Littera Import (books-littera-import.php)
    'littera_import'           => 'Littera-Import',
    'littera_import_subtitle'  => 'Importieren Sie Ihren Altbestand aus der Littera-Datenbank (CSV-Export via mdbtools)',
    'step_analysis'            => 'Analyse',
    'step_preview'             => 'Vorschau',
    'step_import'              => 'Import',
    'step_result'              => 'Ergebnis',
    'upload_csv_files'         => 'CSV-Dateien hochladen',
    'file_present'             => 'vorhanden',
    'file_missing'             => 'fehlt',
    'upload_files_btn'         => 'Dateien hochladen',
    'file_status_label'        => 'Status in',
    'missing_files_label'      => 'Fehlende Dateien',
    'missing_files_help'       => 'Dateien hochladen oder mit mdbtools exportieren und nach uploads/littera/csv_export/ kopieren.',
    'analyze_start'            => 'Analyse starten',
    'go_to_preview'            => 'Weiter zur Vorschau',
    'step1_title'              => 'Schritt 1: Datenanalyse',
    'step1_subtitle'           => 'CSV-Dateien aus uploads/littera/csv_export/ analysieren',
    'step2_title'              => 'Schritt 2: Datenvorschau',
    'step2_subtitle'           => 'Erste 15 Einträge mit allen Transformationen',
    'step3_title'              => 'Schritt 3: Import durchführen',
    'step4_title'              => 'Schritt 4: Ergebnis',
    'load_preview_btn'         => 'Vorschau laden',
    'go_back_btn'              => 'Zurück',
    'go_to_import_btn'         => 'Weiter zum Import',
    'import_mode'              => 'Import-Modus',
    'import_mode_test'         => 'Test-Import (10 Titel)',
    'import_mode_small'        => 'Kleiner Import (50 Titel)',
    'import_mode_full'         => 'Vollimport (alle Titel)',
    'import_running'           => 'Import läuft...',
    'import_running_wait'      => 'Dies kann einige Minuten dauern. Bitte das Fenster nicht schließen.',
    'import_start_btn'         => 'Import starten',
    'reset_data_btn'           => 'Daten zurücksetzen',
    'import_warning_title'     => 'Hinweis',
    'import_duplicates_note'   => 'Duplikate werden per ISBN erkannt und übersprungen',
    'import_no_isbn_note'      => 'Bei Bücher ohne ISBN: Duplikaterkennung über Titel + Autor',
    'import_exemplar_note'     => 'Exemplare mit gleicher Inventarnummer werden übersprungen',
    'titles_label'             => 'Titel',
    'copies_label'             => 'Exemplare',
    'total_label'              => 'Gesamt',
    'imported_label'           => 'Importiert',
    'duplicates_label'         => 'Duplikate',
    'errors_label'             => 'Fehler',
    'skipped_label'            => 'Übersprungen',
    'no_title_label'           => 'Ohne Titel',
    'duration_label'           => 'Dauer',
    'seconds_label'            => 'Sekunden',
    'show_error_details'       => 'Fehlerdetails anzeigen',
    'error_type_col'           => 'Typ',
    'error_id_col'             => 'ID',
    'error_msg_col'            => 'Fehler',
    'to_dashboard'             => 'Zum Dashboard',
    'show_book_list'           => 'Bücherliste anzeigen',
    'new_import'               => 'Neuer Import',
    'no_import_yet'            => 'Noch kein Import durchgeführt. Starten Sie den Import im vorherigen Schritt.',
    'click_load_preview'       => 'Klicken Sie "Vorschau laden" um die Daten zu sehen.',

    // User Management - Users pages (users-list, users-add, users-edit, users-sokrates-import)
    'user_management'            => 'Benutzerverwaltung',
    'user_overview'              => 'Benutzerübersicht',
    'new_user'                   => 'Neuer Benutzer',
    'create_new_user'            => 'Neuen Benutzer anlegen',
    'create_user_local'          => 'Lokalen Benutzer anlegen',
    'local_user_desc'            => 'Für Lehrer, Externe und Gäste (ohne Active Directory).',
    'create_via_ldap'            => 'Benutzer via LDAP/Active Directory anlegen',
    'via_ldap_ad'                => 'Via LDAP/AD',
    'create_manually'            => 'Manuell anlegen',
    'to_user_list'               => 'Zur Benutzerliste',
    'create_user_subtitle'       => 'Benutzer manuell oder via LDAP anlegen',
    'search_name_email'          => 'Name, Benutzername, E-Mail...',
    'phone'                      => 'Telefon',
    'address'                    => 'Adresse',
    'birthday'                   => 'Geburtsdatum',
    'username_optional_hint'     => 'Optional (für Login)',
    'password_min_hint'          => 'Mindestens 8 Zeichen, Groß-/Kleinbuchstaben, Zahl und Sonderzeichen',
    'master_data'                => 'Stammdaten',
    'status_and_block'           => 'Status & Sperren',
    'block_reason'               => 'Sperrgrund',
    'blocked_until'              => 'Gesperrt bis',
    'blocked_until_empty'        => 'Leer = dauerhaft gesperrt',
    'save_changes'               => 'Änderungen speichern',
    'set_password'               => 'Passwort setzen',
    'new_password'               => 'Neues Passwort',
    'user_info'                  => 'Info',
    'last_login'                 => 'Letzter Login',
    'created_at_label'           => 'Erstellt',
    'loans_sidebar'              => 'Ausleihen',
    'loans_active'               => 'Aktiv',
    'loans_total'                => 'Gesamt',
    'danger_zone'                => 'Gefahrenzone',
    'user_has_active_loans_msg'  => 'Benutzer hat %d aktive Ausleihe(n) – Löschen nicht möglich.',
    'delete_user'                => 'Benutzer löschen',
    'ldap_username_ad'           => 'Benutzername (AD)',
    'ldap_search_label'          => 'Name suchen',
    'ldap_search_placeholder'    => 'Nachname oder Vorname (mind. 2 Zeichen)...',
    'ldap_search_btn'            => 'Suchen',
    'ldap_create_user_panel'     => 'Benutzer anlegen',
    'ldap_no_results'            => 'Keine Treffer im Active Directory.',
    'ldap_not_enabled_msg'       => 'LDAP/Active Directory ist nicht aktiviert.',
    'ldap_system_settings_link'  => 'Zu den Systemeinstellungen',
    'ldap_cannot_change_username'=> 'LDAP-Benutzer – Benutzername nicht änderbar',
    'security_error'             => 'Sicherheitsfehler',
    'user_not_found'             => 'Benutzer nicht gefunden',
    'invalid_user_id'            => 'Ungültige Benutzer-ID',
    'user_saved'                 => 'Benutzer erfolgreich gespeichert',
    'password_changed_success'   => 'Passwort erfolgreich geändert',
    'local_auth'                 => 'Lokal',
    'role'                       => 'Rolle',

    // Sokrates Import (users-sokrates-import.php)
    'sokrates_import_title'      => 'Sokrates-Import',
    'sokrates_import_desc'       => 'Schülerdaten aus dem Schulverwaltungssystem Sokrates importieren',
    'sokrates_step_upload'       => 'Upload',
    'sokrates_step_preview'      => 'Vorschau',
    'sokrates_step_result'       => 'Ergebnis',
    'sokrates_step1_title'       => 'Schritt 1: CSV-Datei hochladen',
    'sokrates_step1_desc'        => 'Exportieren Sie die Schülerliste aus Sokrates als CSV-Datei (Semikolon-getrennt).',
    'sokrates_step2_title'       => 'Schritt 2: Datenvorschau',
    'sokrates_step3_title'       => 'Schritt 3: Import abgeschlossen',
    'csv_file'                   => 'CSV-Datei',
    'csv_expected_columns'       => 'Erwartete CSV-Spalten (Sokrates-Export):',
    'csv_encoding_info'          => 'Encoding: UTF-8 oder Windows-1252 wird automatisch erkannt. Trennzeichen: Semikolon.',
    'deactivate_missing_label'   => 'Schulabgänger inaktiv setzen:',
    'deactivate_missing_desc'    => 'Schüler die in der Datenbank vorhanden sind, aber nicht in der CSV, werden auf Status "inaktiv" gesetzt.',
    'upload_and_continue'        => 'Datei hochladen und weiter',
    'load_preview_sokrates'      => 'Vorschau laden',
    'start_import_sokrates'      => 'Import starten',
    'cancel_new_file'            => 'Abbrechen / Neue Datei',
    'sokrates_import_running'    => 'Import läuft...',
    'sokrates_import_running_desc' => 'Bitte Fenster nicht schließen.',
    'total_in_csv'               => 'Gesamt in CSV',
    'newly_created'              => 'Neu angelegt',
    'updated_label'              => 'Aktualisiert',
    'deactivated_label'          => 'Inaktiv gesetzt',
    'unchanged_label'            => 'Unverändert',
    'warnings_label'             => 'Warnungen',
    'new_import_sokrates'        => 'Neuer Import',
    'import_action'              => 'Importieren',
    'preview_label'              => 'Vorschau',
    'map_columns'                => 'Spalten zuordnen',
    'skipped'                    => 'Übersprungen',
    'created_label'              => 'Erstellt',
    'sokrates_reset_confirm'     => 'Wizard zurücksetzen und Datei löschen?',
    'sokrates_confirm_import'    => 'Import jetzt starten? Benutzer werden angelegt oder aktualisiert.',
    'click_load_preview_sokrates'=> 'Klicken Sie "Vorschau laden" um die ersten 20 Einträge zu prüfen.',
    'deactivate_missing_badge'   => 'Schulabgänger werden inaktiv gesetzt',
    'copies_abbr'                => 'Ex.',

    // Settings – General (settings-general.php)
    'settings_general_title'     => 'Einstellungen: Allgemein',
    'settings_general_subtitle'  => 'Allgemeine Einstellungen',
    'tab_general'                => 'Allgemein',
    'tab_data_management'        => 'Datenverwaltung',
    'tab_data_backup'            => 'Datenbackup',
    'library_name'               => 'Bibliotheksname',
    'library_email'              => 'Bibliotheks-E-Mail',
    'language'                   => 'Sprache',
    'language_in_preparation'    => 'Sprachumschaltung in Vorbereitung',
    'footer_text'                => 'Footer-Text',
    'session_section'            => 'Session',
    'session_timeout_minutes'    => 'Session-Timeout (Minuten)',
    'session_timeout_help'       => 'Gültige Werte: 5–480 Min.',
    'save_settings'              => 'Einstellungen speichern',
    'data_management'            => 'Datenverwaltung',
    'data_management_desc'       => 'Aufbewahrungsfristen und Archivierung',
    'activity_log_retention'     => 'Activity-Log Aufbewahrung (Jahre)',
    'activity_log_retention_help'=> 'Ältere Einträge werden automatisch gelöscht',
    'loan_history_archive'       => 'Ausleihhistorie Archivierung (Jahre)',
    'loan_history_archive_help'  => 'Ältere Einträge werden in Archiv-Tabelle verschoben',
    'data_backup'                => 'Datenbackup',
    'db_size'                    => 'Datenbankgröße',
    'tables'                     => 'Tabellen',
    'last_backup'                => 'Letztes Backup',
    'create_backup'              => 'Backup erstellen',
    'create_backup_desc'         => 'SQL-Dump der kompletten Datenbank',
    'method'                     => 'Methode',
    'method_auto'                => 'Automatisch',
    'mysqldump_available'        => 'mysqldump verfügbar',
    'php_fallback'               => 'PHP-Fallback',
    'mysqldump_preferred'        => 'mysqldump bevorzugt, PHP-Export als Fallback',
    'php_export_pdo'             => 'PHP-Export (PDO)',
    'php_export_no_tool'         => 'Kein externes Tool benötigt',
    'options'                    => 'Optionen',
    'gzip_compression'           => 'gzip-Komprimierung',
    'gzip_smaller_file'          => 'Kleinere Datei (.sql.gz)',
    'create_and_save_backup'     => 'Backup erstellen & speichern',
    'saved_backups'              => 'Gespeicherte Backups',
    'no_backups_yet'             => 'Noch keine Backups vorhanden.',
    'filename'                   => 'Dateiname',
    'file_size'                  => 'Größe',
    'created_col'                => 'Erstellt',
    'newest'                     => 'neuestes',
    'download'                   => 'Download',
    'restore_database'           => 'Datenbank wiederherstellen',
    'expand'                     => 'aufklappen',
    'restore_warning'            => 'Achtung! Die Wiederherstellung überschreibt alle aktuellen Daten unwiderruflich. Erstellen Sie vorher unbedingt ein aktuelles Backup.',
    'backup_file_label'          => 'Backup-Datei',
    'confirm_restore_label'      => 'Bestätigung: Geben Sie JA ein',

    // Settings – Inventory (settings-inventory.php)
    'settings_inventory_title'   => 'Einstellungen: Bestandsverwaltung',
    'settings_inventory_desc'    => 'Barcodes, ISBN-API, Kategorien und Littera-Import',
    'barcode_print_in_prep'      => 'Barcode-Druck ist in Vorbereitung',
    'barcode_print_not_impl'     => 'Das direkte Drucken von Barcode-Etiketten aus dem Browser ist noch nicht implementiert. Die folgenden Einstellungen werden gespeichert und beim Rollout des Barcode-Drucks verwendet.',
    'barcode_settings'           => 'Barcode-Einstellungen',
    'barcode_format'             => 'Barcode-Format',
    'barcode_format_help'        => 'Code 128 empfohlen — unterstützt alle Buchungsnummern.',
    'label_format_label'         => 'Etiketten-Format',
    'isbn_api_desc'              => 'Automatischer Abruf von Buchdaten beim Erfassen neuer Bücher',
    'isbn_api_sources'           => 'Verfügbare Quellen',
    'isbn_primary_api'           => 'Primäre API',
    'isbn_primary_help'          => '(wird zuerst abgefragt)',
    'isbn_second_api'            => 'Zweite API',
    'isbn_second_help'           => '(ergänzt fehlende Felder)',
    'isbn_use_both'              => 'Beide APIs abfragen',
    'isbn_use_both_help'         => 'Empfohlen: Jede API liefert andere Felder. DNB = Metadaten & Schlagworte, Google/ISBN.de = Cover & Preis. Zusammen ergibt sich ein vollständigerer Datensatz.',
    'isbn_timeout_label'         => 'Timeout pro API (Sekunden)',
    'isbn_timeout_help'          => 'Bei aktivierten beiden APIs gilt der Timeout jeweils pro Anfrage.',
    'category_new'               => 'Neue Kategorie',
    'category_edit'              => 'Kategorie bearbeiten',
    'category_create'            => 'Anlegen',
    'no_categories'              => 'Keine Kategorien vorhanden',
    'sort_order'                 => 'Sortierung',
    'active'                     => 'Aktiv',
    'yes_short'                  => 'ja',
    'no_short'                   => 'nein',
    'confirm_delete_category'    => 'Kategorie wirklich löschen?',
    'littera_settings_title'     => 'Littera-Import',
    'littera_settings_desc'      => 'Importiert Bücher und Exemplare aus dem Legacy-System Littera (Microsoft Access / Jet-Datenbank). Der Import-Assistent führt Sie in mehreren Schritten durch den Prozess — von der Prüfung der CSV-Quelldateien bis zur Übernahme in die Datenbank.',
    'littera_requirements'       => 'Voraussetzungen',
    'littera_required_files'     => 'Benötigte Dateien:',
    'go_to_littera_import'       => 'Zum Littera-Import-Assistenten',
    'subcategories_tab'          => 'Unterkategorien',
    'subcategory_new'            => 'Neue Untergruppe',
    'subcategory_edit'           => 'Untergruppe bearbeiten',
    'no_entries'                 => 'Keine Einträge',
    'confirm_delete_subcategory' => 'Untergruppe wirklich löschen?',

    // Settings – Users (settings-users.php)
    'settings_users_title'       => 'Einstellungen: Benutzerverwaltung',
    'settings_users_desc'        => 'Benutzergruppen und LDAP/Active Directory',
    'user_groups'                => 'Benutzergruppen',
    'tab_user_groups'            => 'Benutzergruppen',
    'tab_ldap'                   => 'LDAP / Active Directory',
    'groups_inline_edit_hint'    => 'Änderungen direkt in der Tabelle vornehmen und mit',
    'max_loans_short'            => 'Max. Ausleihen',
    'loan_duration_days'         => 'Ausleihdauer (Tage)',
    'extend'                     => 'Verlängern',
    'max_extensions'             => 'Max. Verlängerungen',
    'reserve'                    => 'Vormerken',
    'users_count'                => 'Nutzer',
    'unlimited_hint'             => 'leer = unbegrenzt',
    'description'                => 'Beschreibung',
    'no_groups'                  => 'Keine Gruppen vorhanden',
    'create_new_group'           => 'Neue Gruppe anlegen',
    'extend_allowed'             => 'Verlängern erlaubt',
    'reserve_allowed'            => 'Vormerken erlaubt',
    'create_group'               => 'Gruppe anlegen',
    'ldap_ad_title'              => 'LDAP / Active Directory',
    'ldap_ad_desc'               => 'Authentifizierung gegen Active Directory',
    'ldap_on_demand_title'       => 'On-Demand User Creation',
    'ldap_on_demand_desc'        => 'LDAP-Benutzer werden nicht massenweise synchronisiert. Sie werden automatisch beim ersten Ausleihvorgang in der Datenbank angelegt bzw. mit einem vorhandenen Sokrates-Import-Datensatz zusammengeführt.',
    'connection_settings'        => 'Verbindungseinstellungen',
    'user_attributes'            => 'Benutzer-Attribute',
    'group_has_users'            => 'Gruppe hat zugewiesene Benutzer',
    'confirm_delete_group'       => 'Gruppe wirklich löschen? Diese Aktion kann nicht rückgängig gemacht werden.',
    'confirm'                    => 'bestätigen',
    'groups_heading'             => 'Gruppen',
    'description_optional'      => 'Beschreibung (optional)',
    'name_required'              => 'Name ist ein Pflichtfeld.',
    'name_already_taken'         => 'Name ist bereits vergeben.',
    'group_saved'                => 'Gruppe gespeichert.',
    'group_created'              => 'Gruppe angelegt.',
    'group_deleted'              => 'Gruppe gelöscht.',
    'group_delete_has_users'     => 'Gruppe kann nicht gelöscht werden: %d Benutzer zugewiesen.',
    'ldap_settings_saved'        => 'LDAP-Einstellungen gespeichert.',
    'testing'                    => 'Teste...',
    'ldap_test_error'            => 'Fehler beim Verbindungstest.',
    'smtp_port_label'            => 'Port',

    // Settings – Lending (settings-lending.php)
    'settings_lending_title'     => 'Einstellungen: Verleihverwaltung',
    'settings_lending_desc'      => 'Ausleih-Parameter und E-Mail / SMTP-Konfiguration',
    'tab_loans'                  => 'Ausleihen',
    'tab_email_smtp'             => 'E-Mail / SMTP',
    'loan_settings'              => 'Ausleih-Einstellungen',
    'loan_settings_desc'         => 'Systemweite Standardwerte. Pro Benutzergruppe können abweichende Werte festgelegt werden.',
    'default_loan_duration'      => 'Standard-Ausleihdauer (Tage)',
    'default_loan_duration_help' => 'Fallback, wenn Gruppe keine eigene Dauer hat',
    'max_extensions_default'     => 'Max. Verlängerungen (Standard)',
    'max_loans_default'          => 'Max. Ausleihen pro Benutzer (Standard)',
    'reminders'                  => 'Mahnungen',
    'reminders_enabled'          => 'Mahnungen aktiviert',
    'reminder_after_days'        => 'Mahnung nach X Tagen Überfälligkeit',
    'reminder_after_days_help'   => 'Tage nach Ablauf der Leihfrist',
    'reminder_frequency'         => 'Wiederholungsfrequenz',
    'frequency_daily'            => 'Täglich',
    'frequency_weekly'           => 'Wöchentlich',
    'frequency_monthly'          => 'Monatlich',
    'email_smtp'                 => 'E-Mail / SMTP',
    'email_smtp_desc'            => 'Konfiguration für E-Mail-Versand (Mahnungen, Benachrichtigungen)',
    'smtp_enable'                => 'SMTP aktivieren',
    'smtp_host'                  => 'SMTP-Server',
    'smtp_port_help'             => '587 (STARTTLS) oder 465 (SSL)',
    'smtp_username'              => 'Benutzername',
    'smtp_password_label'        => 'Passwort',
    'sender_email'               => 'Absender-E-Mail',
    'sender_name'                => 'Absender-Name',
    'test_email_section'         => 'Test-E-Mail',
    'test_email_desc'            => 'Sendet eine Test-E-Mail an die unter Einstellungen → Allgemein hinterlegte Bibliotheks-E-Mail-Adresse',
    'not_configured_yet'         => '(noch nicht konfiguriert)',
    'send_test_email'            => 'Test-E-Mail senden',
    'loan_settings_saved'        => 'Ausleih-Einstellungen gespeichert.',
    'smtp_settings_saved'        => 'E-Mail-Einstellungen gespeichert.',
    'sending'                    => 'Sende...',
    'network_error_test'         => 'Netzwerkfehler beim Test.',
    'security_error_retry'       => 'Sicherheitsfehler. Bitte versuchen Sie es erneut.',
    'invalid_input'              => 'Ungültige Eingabe.',

    // Books - Edit Detail (books-edit-detail.php)
    'title_data'               => 'Titeldaten',
    'subtitle_field'           => 'Untertitel',
    'title_sort_field'         => 'Sortierform',
    'title_sort_hint'          => 'Titel ohne Artikel',
    'involved_persons'         => 'Beteiligte Personen',
    'author_name_placeholder'  => 'Nachname Vorname',
    'author_abbr_field'        => 'Kürzel (Autor)',
    'author_abbr_placeholder'  => 'z.B. Böl',
    'additional_authors'       => 'Weitere Autoren',
    'comma_separated'          => 'kommagetrennt',
    'show_extra_fields'        => '+ Herausgeber, Übersetzer, Illustratoren…',
    'hide_extra_fields'        => '− Zusatzfelder einklappen',
    'editor_field'             => 'Herausgeber',
    'translator_field'         => 'Übersetzer',
    'illustrator_field'        => 'Illustrator',
    'photographer_field'       => 'Fotograf',
    'graphic_artist_field'     => 'Grafiker',
    'other_persons_field'      => 'Sonstige',
    'publication'              => 'Publikation',
    'place_of_publication'     => 'Erscheinungsort',
    'edition_field'            => 'Auflage',
    'edition_placeholder'      => 'z.B. 3. Aufl.',
    'page_count'               => 'Seiten',
    'price_field'              => 'Preis (€)',
    'price_placeholder'        => 'z.B. 24.90',
    'series_volume_field'      => 'Reihe / Band',
    'series'                   => 'Reihe',
    'volume_abbr'              => 'Bd.',
    'category_and_content'     => 'Kategorie & Inhalt',
    'choose_category'          => '— Kategorie wählen —',
    'subgroup_field'           => 'Untergruppe',
    'choose_subgroup'          => '— Untergruppe wählen —',
    'no_subgroups'             => '— keine Untergruppen —',
    'keywords'                 => 'Schlagworte',
    'keywords_placeholder'     => 'z.B. Roman, Österreich, 20. Jahrhundert',
    'cover_image'              => 'Coverbild',
    'no_cover'                 => 'Kein Cover',
    'cover_url'                => 'Cover-URL',
    'copies'                   => 'Exemplare',
    'print_all_labels'         => 'Alle Etiketten drucken',
    'add_new_copy'             => 'Neu',
    'copy_number_abbr'         => 'Nr.',
    'no_copies_available'      => 'Keine Exemplare vorhanden',
    'due_date_prefix'          => 'fällig',
    'metadata'                 => 'Metadaten',
    'book_id_field'            => 'Buch-ID',
    'created_field'            => 'Erstellt',
    'created_by_prefix'        => 'von',
    'last_modified'            => 'Letzte Änderung',
    'cover_search_enter_isbn'  => 'Bitte zuerst eine ISBN eingeben.',
    'cover_search_running'     => 'Suche läuft…',
    'cover_found'              => 'Cover gefunden.',
    'cover_not_found'          => 'Kein Cover gefunden.',
    'cover_search_error'       => 'Fehler bei der Abfrage.',

    // Books - Add Book (books-add.php)
    'book_saved_success'         => 'Buch erfolgreich gespeichert',
    'book_saved_id'              => 'Das Buch wurde mit ID #%s angelegt.',
    'add_next_book'              => 'Nächstes Buch erfassen',
    'view_edit_book'             => 'Buch anzeigen / bearbeiten',
    'isbn_scan_enter'            => 'ISBN scannen / eingeben',
    'isbn_placeholder'           => 'ISBN scannen oder eingeben…',
    'isbn_clear_form'            => 'Formular leeren',
    'isbn_searching'             => 'Suche läuft…',
    'isbn_duplicate_notice'      => 'Dieses Buch ist bereits im Bestand — weiteres Exemplar wird hinzugefügt',
    'isbn_cancel_clear'          => 'Abbrechen / Formular leeren',
    'isbn_test_label'            => 'Test:',
    'isbn_auto_filled'           => 'Automatisch befüllt',
    'copy_section'               => 'Exemplar',
    'category_choose'            => 'Kategorie wählen',
    'subcategory_label'          => 'Untergruppe',
    'subcategory_choose_first'   => 'erst Kategorie wählen',
    'subcategory_choose'         => 'Untergruppe wählen',
    'subcategory_no_subcats'     => 'keine Untergruppen',
    'location_placeholder'       => 'z.B. Regal A3',
    'title_data_section'         => 'Titeldaten',
    'title_sort_label'           => 'Sortierform',
    'title_sort_help'            => 'Titel ohne Artikel für Sortierung',
    'persons_section'            => 'Beteiligte Personen',
    'author_placeholder'         => 'Nachname Vorname',
    'author_short_label'         => 'Kürzel',
    'author_short_placeholder'   => 'z.B. Böl',
    'show_extra_persons'         => 'Herausgeber, Übersetzer, Illustratoren…',
    'hide_extra_persons'         => 'Zusatzfelder einklappen',
    'editor_label'               => 'Herausgeber',
    'translator_label'           => 'Übersetzer',
    'illustrator_label'          => 'Illustrator',
    'photographer_label'         => 'Fotograf',
    'graphic_artist_label'       => 'Grafiker',
    'other_persons_label'        => 'Sonstige',
    'publication_section'        => 'Publikation',
    'place_of_publication_label' => 'Erscheinungsort',
    'edition_label'              => 'Auflage',
    'pages_label'                => 'Seiten',
    'lang_other'                 => 'Andere',
    'price_label'                => 'Preis (€)',
    'series_volume_label'        => 'Reihe / Band',
    'series_placeholder'         => 'Reihe',
    'series_volume_placeholder'  => 'Bd.',
    'content_section'            => 'Inhalt & Erschließung',
    'keywords_label'             => 'Schlagworte',
    'description_label'          => 'Inhaltsbeschreibung',
    'save_book_btn'              => 'Buch speichern',
    'save_hint_prefix'           => 'Das Buch wird mit Buchungsnummer',
    'save_hint_suffix'           => 'als erstes Exemplar gespeichert.',
    'cover_source_link'          => 'Cover-Quelle öffnen',

    // Lending – Reservations (lending-reservations.php)
    'reservations_title'              => 'Vormerkungen',
    'reservations_subtitle'           => 'Buchvormerkungen verwalten und bearbeiten',
    'new_reservation_btn'             => '+ Neue Vormerkung',
    'new_reservation_panel_title'     => 'Neue Vormerkung anlegen',
    'res_user_label'                  => 'Benutzer',
    'res_user_placeholder'            => 'Name, Klasse oder Ausweis-Nr....',
    'res_book_label'                  => 'Buch',
    'res_book_placeholder'            => 'Titel, Autor oder ISBN...',
    'res_switch_user'                 => 'wechseln',
    'res_switch_book'                 => 'wechseln',
    'res_create_btn'                  => 'Vormerkung anlegen',
    'res_stat_active_waiting'         => 'Aktiv wartend',
    'res_stat_ready_pickup'           => 'Bereit zur Abholung',
    'res_stat_completed'              => 'Abgeschlossen',
    'res_tab_all'                     => 'Aktiv & Bereit',
    'res_tab_waiting'                 => 'Wartend',
    'res_tab_ready'                   => 'Bereit',
    'res_tab_history'                 => 'Verlauf',
    'res_col_user'                    => 'Benutzer',
    'res_col_book'                    => 'Buch',
    'res_col_reserved_date'           => 'Vorgemerkt',
    'res_col_position'                => 'Position / Notiz',
    'res_notified_label'              => 'Benachrichtigt:',
    'res_badge_waiting'               => 'wartend',
    'res_badge_ready'                 => 'bereit',
    'res_badge_picked_up'             => 'abgeholt',
    'res_badge_expired'               => 'abgelaufen',
    'res_badge_cancelled'             => 'storniert',
    'res_position_label'              => 'Position',
    'res_copy_assigned'               => 'Exemplar zugewiesen',
    'res_completed_label'             => 'abgeschlossen',
    'res_checkout_btn'                => 'Ausleihe buchen',
    'res_not_picked_up_btn'           => 'Nicht abgeholt',
    'res_count_singular'              => 'Vormerkung angezeigt',
    'res_count_plural'                => 'Vormerkungen angezeigt',
    'res_none_found'                  => 'Keine Vormerkungen gefunden.',
    'res_modal_title'                 => 'Ausleihe aus Vormerkung',
    'res_modal_note_label'            => 'Notiz (optional)',
    'res_modal_note_placeholder'      => 'z.B. Buchzustand...',
    'res_success_created_available'   => 'Vormerkung angelegt – Exemplar sofort verfügbar!',
    'res_success_created_waiting'     => 'Vormerkung angelegt – Benutzer wartet in der Warteschlange.',
    'res_js_booked'                   => 'Ausleihe #%s gebucht – Rückgabe bis %s',
    'res_js_confirm_cancel'           => 'Vormerkung wirklich stornieren?',
    'res_js_confirm_expire'           => 'Vormerkung als "nicht abgeholt" / abgelaufen markieren?',
    'res_js_error_prefix'             => 'Fehler:',
    'res_js_network_error'            => 'Netzwerkfehler:',
    'res_js_booking'                  => 'Wird gebucht...',
    'res_js_searching'                => 'Suche...',
    'res_js_no_results'               => 'Keine Treffer',
    'res_js_available_count'          => 'verfügbar',
    'res_js_all_loaned'               => 'alle ausgeliehen',
];
