<?php
/**
 * Dashboard Header
 * Top navigation bar with user menu
 */

if (!defined('BASE_URL')) {
    die('Direct access not permitted');
}

// Get current user if not already set
if (!isset($current_user)) {
    $current_user = get_logged_in_user();
}

// Load language if not already loaded
if (!isset($lang)) {
    $lang = load_language();
}
?>
<!DOCTYPE html>
<html lang="<?php echo get_current_language(); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Dashboard'; ?> - <?php echo esc_html(getSetting('library_name', 'Bibliothek')); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/css/custom.css">
    <style>
        /* Smooth transitions */
        * { transition: all 0.2s ease; }
        
        /* Smooth hover effects */
        .hover-lift:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
    </style>
</head>
<body class="bg-gray-50 flex flex-col min-h-screen">
    <!-- Top Navigation -->
    <nav class="bg-gradient-to-r from-blue-600 to-blue-700 shadow-lg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <!-- Logo & Brand -->
                <div class="flex items-center">
                    <a href="<?php echo BASE_URL; ?>/dashboard.php" class="flex items-center space-x-3 text-white hover:text-blue-100">
                        <svg class="h-8 w-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                        </svg>
                        <span class="text-xl font-bold">
                            <?php echo esc_html(getSetting('library_name', 'Bibliothek')); ?>
                        </span>
                    </a>
                </div>

                <!-- Admin Button (only for admins) -->
                <div class="hidden md:flex md:items-center">
                    <?php if (is_admin()): ?>
                    <a href="<?php echo BASE_URL; ?>/admin/" 
                       class="px-4 py-2 rounded-md text-sm font-medium bg-blue-800 text-white hover:bg-blue-900">
                        <svg class="inline h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                        </svg>
                        <?php echo $lang['nav_admin_area'] ?? 'Admin'; ?>
                    </a>
                    <?php endif; ?>
                </div>

                <!-- User Info & Logout -->
                <div class="flex items-center space-x-4">
                    <!-- User Avatar & Name -->
                    <div class="flex items-center space-x-3">
                        <div class="h-8 w-8 rounded-full bg-blue-500 flex items-center justify-center">
                            <span class="text-sm font-medium text-white">
                                <?php echo strtoupper(substr($current_user['first_name'], 0, 1) . substr($current_user['last_name'], 0, 1)); ?>
                            </span>
                        </div>
                        <span class="hidden md:block text-sm font-medium text-white">
                            <?php echo esc_html($current_user['first_name'] . ' ' . $current_user['last_name']); ?>
                        </span>
                    </div>
                    
                    <!-- Logout Button -->
                    <a href="<?php echo BASE_URL; ?>/logout.php" 
                       class="px-3 py-2 rounded-md text-sm font-medium text-white hover:bg-red-600 transition-colors">
                        <?php echo $lang['nav_logout'] ?? 'Abmelden'; ?>
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Flash Messages -->
    <?php
    $flash = get_flash();
    if ($flash):
        $colors = [
            'success' => 'green',
            'error' => 'red',
            'warning' => 'yellow',
            'info' => 'blue'
        ];
        $color = $colors[$flash['type']] ?? 'gray';
    ?>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-4">
        <div class="flash-message bg-<?php echo $color; ?>-50 border-l-4 border-<?php echo $color; ?>-500 p-4 rounded" style="transition: opacity 0.3s ease;">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-<?php echo $color; ?>-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-<?php echo $color; ?>-700"><?php echo esc_html($flash['message']); ?></p>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Main Content Container -->
    <main class="flex-grow max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8 w-full">
