<?php
/**
 * BASE_URL Helper
 * Calculates the correct base URL for the application
 * Can be included in any file
 */

if (!defined('BASE_URL')) {
    // Find the base directory by looking for a marker file
    $script_path = $_SERVER['SCRIPT_NAME'];
    
    // Remove filename to get directory
    $current_dir = dirname($script_path);
    
    // Check if we're in admin or any subdirectory of admin
    // The base is always where index.php is located (root of app)
    if (strpos($current_dir, '/admin') !== false) {
        // We're somewhere in admin - find the base
        $parts = explode('/admin', $current_dir);
        $base_url = $parts[0];
    } elseif (basename($current_dir) === 'install' || basename($current_dir) === 'steps') {
        // Go up one level
        $base_url = dirname($current_dir);
    } else {
        $base_url = $current_dir;
    }
    
    // Handle root case
    if ($base_url === '/' || $base_url === '\\') {
        $base_url = '';
    }
    
    define('BASE_URL', $base_url);
}
