<?php
/**
 * Template
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/session.php';

require_admin();

$current_user = get_logged_in_user();
$page_title = 'Seitentitel';

// ─── HANDLE POST ───────────────────────────────────────────────────────────────
// if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
//     if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
//         set_flash('Sicherheitsfehler', 'error');
//         header('Location: ' . $_SERVER['PHP_SELF']);
//         exit;
//     }
//     // handle actions here ...
// }

// ─── DATA ──────────────────────────────────────────────────────────────────────
// $data = db_get_results("SELECT ...");

include __DIR__ . '/includes/header.php';
$flash = get_flash();
?>

<div class="flex-1 overflow-y-auto">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">

        <!-- Page Header -->
        <div class="mb-6">
            <h1 class="text-3xl font-bold text-gray-900"><?php echo esc_html($page_title); ?></h1>
        </div>

        <!-- Flash Message -->
        <?php if ($flash): ?>
            <?php
            $fc = ['success' => 'green', 'error' => 'red', 'warning' => 'yellow', 'info' => 'blue'];
            $c  = $fc[$flash['type']] ?? 'blue';
            ?>
            <div class="mb-6 bg-<?php echo $c; ?>-50 border-l-4 border-<?php echo $c; ?>-400 p-4 rounded">
                <p class="text-sm text-<?php echo $c; ?>-700"><?php echo $flash['message']; ?></p>
            </div>
        <?php endif; ?>

        <!-- Content -->
        <div class="bg-white rounded-lg shadow p-6">
            <p class="text-gray-500">Inhalt …</p>
        </div>

    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
