<?php
/**
 * Template - TAB
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/session.php';

require_admin();

$current_user = get_logged_in_user();
$page_title = 'Seitentitel';

// Active tab
$active_tab = $_GET['tab'] ?? 'tab1';

// ─── HANDLE POST ───────────────────────────────────────────────────────────────
// if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
//     if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
//         set_flash('Sicherheitsfehler', 'error');
//         header('Location: ' . $_SERVER['PHP_SELF'] . '?tab=' . $active_tab);
//         exit;
//     }
//     // handle actions here ...
// }

// ─── DATA ──────────────────────────────────────────────────────────────────────
// $data = db_get_results("SELECT ...");

include __DIR__ . '/includes/header.php';
$flash = get_flash();
?>

<div class="flex-1 overflow-y-auto">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">

        <!-- Page Header -->
        <div class="mb-6">
            <h1 class="text-3xl font-bold text-gray-900"><?php echo esc_html($page_title); ?></h1>
        </div>

        <!-- Flash Message -->
        <?php if ($flash): ?>
            <?php
            $fc = ['success' => 'green', 'error' => 'red', 'warning' => 'yellow', 'info' => 'blue'];
            $c  = $fc[$flash['type']] ?? 'blue';
            ?>
            <div class="mb-6 bg-<?php echo $c; ?>-50 border-l-4 border-<?php echo $c; ?>-400 p-4 rounded">
                <p class="text-sm text-<?php echo $c; ?>-700"><?php echo $flash['message']; ?></p>
            </div>
        <?php endif; ?>

        <!-- Tab Navigation -->
        <div class="mb-6 border-b border-gray-200">
            <nav class="-mb-px flex space-x-8">
                <a href="?tab=tab1"
                   class="tab-link border-b-2 py-4 px-1 text-sm font-medium
                          <?php echo $active_tab === 'tab1'
                              ? 'border-blue-500 text-blue-600'
                              : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?>">
                    Tab 1
                </a>
                <a href="?tab=tab2"
                   class="tab-link border-b-2 py-4 px-1 text-sm font-medium
                          <?php echo $active_tab === 'tab2'
                              ? 'border-blue-500 text-blue-600'
                              : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'; ?>">
                    Tab 2
                </a>
            </nav>
        </div>

        <!-- ══════════════════════════════════════════════════════════ -->
        <!-- TAB 1                                                      -->
        <!-- ══════════════════════════════════════════════════════════ -->
        <?php if ($active_tab === 'tab1'): ?>

            <div class="bg-white rounded-lg shadow p-6">
                <p class="text-gray-500">Inhalt Tab 1 …</p>
            </div>

        <?php endif; ?>

        <!-- ══════════════════════════════════════════════════════════ -->
        <!-- TAB 2                                                      -->
        <!-- ══════════════════════════════════════════════════════════ -->
        <?php if ($active_tab === 'tab2'): ?>

            <div class="bg-white rounded-lg shadow p-6">
                <p class="text-gray-500">Inhalt Tab 2 …</p>
            </div>

        <?php endif; ?>

    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
