<?php
/**
 * Admin Header with Sidebar Navigation - COMPLETE VERSION
 * FLAT STRUCTURE: All files in /admin/ root with prefixes
 */

if (!defined('BASE_URL')) {
    die('Direct access not permitted');
}

$current_user = get_logged_in_user();
$lang = load_language();

if (!is_admin()) {
    header('Location: ' . BASE_URL . '/dashboard.php');
    exit;
}

$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="<?php echo get_current_language(); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Admin'; ?> - <?php echo esc_html(getSetting('library_name', 'Bibliothek')); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        #sidebar { transition: transform 0.3s ease; }
        @media (max-width: 768px) {
            #sidebar.hidden { transform: translateX(-100%); }
        }
        .menu-item.active { background-color: #1e40af; border-left: 4px solid #60a5fa; }
        .menu-item:hover { background-color: #374151; }
        .menu-item.active:hover { background-color: #1e40af; }
        .menu-section-content { max-height: 0; overflow: hidden; transition: max-height 0.3s ease; }
        .menu-section-content.open { max-height: 1000px; }
        .menu-section-toggle { transition: transform 0.3s ease; }
        .menu-section-toggle.rotate { transform: rotate(180deg); }
    </style>
</head>
<body class="bg-gray-100 flex">
    <div class="md:hidden fixed top-4 left-4 z-50">
        <button id="mobile-menu-btn" class="bg-gray-800 text-white p-2 rounded-lg">
            <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
            </svg>
        </button>
    </div>

    <div id="sidebar" class="fixed left-0 top-0 h-full w-64 bg-gray-800 text-gray-100 overflow-y-auto z-40">
        <div class="p-6 border-b border-gray-700">
            <a href="<?php echo BASE_URL; ?>/admin/index.php" class="flex items-center space-x-3">
                <svg class="h-8 w-8 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
                <div>
                    <div class="text-sm font-bold"><?php echo $lang['admin_area']; ?></div>
                    <div class="text-xs text-gray-400"><?php echo esc_html($current_user['first_name']); ?></div>
                </div>
            </a>
        </div>

        <nav class="p-4">
            <!-- Admin-Dashboard -->
            <a href="<?php echo BASE_URL; ?>/admin/index.php"
               class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'index.php' ? 'active' : ''; ?>">
                <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                </svg>
                <span><?php echo $lang['admin_dashboard']; ?></span>
            </a>

            <!-- Bestandsverwaltung -->
            <div class="mt-6 mb-2">
                <button class="menu-section-header w-full flex items-center justify-between px-4 py-2 text-xs font-semibold text-gray-500 uppercase hover:text-gray-300" onclick="toggleSection('inventory-mgmt')">
                    <span><?php echo $lang['admin_inventory_mgmt']; ?></span>
                    <svg class="menu-section-toggle h-4 w-4" id="toggle-inventory-mgmt" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
            </div>
            <div class="menu-section-content" id="section-inventory-mgmt">
                <a href="<?php echo BASE_URL; ?>/admin/books-add.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'books-add.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                    <span><?php echo $lang['admin_add_book']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/books-edit.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'books-edit.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
                    <span><?php echo $lang['admin_edit_books']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/books-remove.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'books-remove.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                    <span><?php echo $lang['admin_delete_books']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/books-label-print.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'books-label-print.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/></svg>
                    <span><?php echo $lang['admin_print_labels']; ?></span>
                </a>
            </div>

            <!-- Verleihverwaltung -->
            <div class="mt-6 mb-2">
                <button class="menu-section-header w-full flex items-center justify-between px-4 py-2 text-xs font-semibold text-gray-500 uppercase hover:text-gray-300" onclick="toggleSection('lending-mgmt')">
                    <span><?php echo $lang['admin_lending_mgmt']; ?></span>
                    <svg class="menu-section-toggle h-4 w-4" id="toggle-lending-mgmt" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
            </div>
            <div class="menu-section-content" id="section-lending-mgmt">
                <a href="<?php echo BASE_URL; ?>/admin/lending-checkout.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'lending-checkout.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/></svg>
                    <span><?php echo $lang['admin_checkout']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/lending-return.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'lending-return.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"/></svg>
                    <span><?php echo $lang['admin_return']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/lending-active.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'lending-active.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg>
                    <span><?php echo $lang['admin_active_loans']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/lending-reminders.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'lending-reminders.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/></svg>
                    <span><?php echo $lang['admin_reminders']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/lending-reservations.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'lending-reservations.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 5a2 2 0 012-2h10a2 2 0 012 2v16l-7-3.5L5 21V5z"/></svg>
                    <span><?php echo $lang['admin_reservations']; ?></span>
                </a>
            </div>

            <!-- Benutzerverwaltung -->
            <div class="mt-6 mb-2">
                <button class="menu-section-header w-full flex items-center justify-between px-4 py-2 text-xs font-semibold text-gray-500 uppercase hover:text-gray-300" onclick="toggleSection('user-mgmt')">
                    <span><?php echo $lang['admin_user_mgmt']; ?></span>
                    <svg class="menu-section-toggle h-4 w-4" id="toggle-user-mgmt" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
            </div>
            <div class="menu-section-content" id="section-user-mgmt">
                <a href="<?php echo BASE_URL; ?>/admin/users-list.php?tab=list" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'users-list.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/></svg>
                    <span><?php echo $lang['admin_users_overview']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/users-add.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'users-add.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/></svg>
                    <span><?php echo $lang['admin_create_user']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/users-sokrates-import.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'users-sokrates-import.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/></svg>
                    <span><?php echo $lang['admin_sokrates_import']; ?></span>
                </a>
            </div>

            <!-- Inventur -->
            <div class="mt-6 mb-2">
                <button class="menu-section-header w-full flex items-center justify-between px-4 py-2 text-xs font-semibold text-gray-500 uppercase hover:text-gray-300" onclick="toggleSection('inventory')">
                    <span><?php echo $lang['admin_inventory']; ?></span>
                    <svg class="menu-section-toggle h-4 w-4" id="toggle-inventory" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
            </div>
            <div class="menu-section-content" id="section-inventory">
                <a href="<?php echo BASE_URL; ?>/admin/inventory-start.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'inventory-start.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                    <span><?php echo $lang['admin_inventory_start']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/inventory-ongoing.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'inventory-ongoing.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"/></svg>
                    <span><?php echo $lang['admin_inventory_ongoing']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/inventory-history.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'inventory-history.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    <span><?php echo $lang['admin_inventory_history']; ?></span>
                </a>
            </div>

            <!-- Statistiken & Berichte -->
            <div class="mt-6 mb-2">
                <button class="menu-section-header w-full flex items-center justify-between px-4 py-2 text-xs font-semibold text-gray-500 uppercase hover:text-gray-300" onclick="toggleSection('reports')">
                    <span><?php echo $lang['admin_reports']; ?></span>
                    <svg class="menu-section-toggle h-4 w-4" id="toggle-reports" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
            </div>
            <div class="menu-section-content" id="section-reports">
                <a href="<?php echo BASE_URL; ?>/admin/reports-lending.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'reports-lending.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/></svg>
                    <span><?php echo $lang['admin_lending_stats']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/reports-inventory.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'reports-inventory.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
                    <span><?php echo $lang['admin_inventory_overview']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/reports-generator.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'reports-generator.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
                    <span><?php echo $lang['admin_report_generator']; ?></span>
                </a>
            </div>

            <!-- Einstellungen -->
            <div class="mt-6 mb-2">
                <button class="menu-section-header w-full flex items-center justify-between px-4 py-2 text-xs font-semibold text-gray-500 uppercase hover:text-gray-300" onclick="toggleSection('settings')">
                    <span><?php echo $lang['admin_settings']; ?></span>
                    <svg class="menu-section-toggle h-4 w-4" id="toggle-settings" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                    </svg>
                </button>
            </div>
            <div class="menu-section-content" id="section-settings">
                <a href="<?php echo BASE_URL; ?>/admin/settings-general.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo in_array($current_page, ['settings-general.php','settings-system.php','settings-backup.php']) ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/></svg>
                    <span><?php echo $lang['admin_settings_general']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/settings-inventory.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo in_array($current_page, ['settings-inventory.php','books-settings.php']) ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                    <span><?php echo $lang['admin_inventory_mgmt']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/settings-users.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'settings-users.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                    <span><?php echo $lang['admin_user_mgmt']; ?></span>
                </a>
                <a href="<?php echo BASE_URL; ?>/admin/settings-lending.php" class="menu-item flex items-center space-x-3 px-4 py-3 rounded-lg mb-2 <?php echo $current_page === 'settings-lending.php' ? 'active' : ''; ?>">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"/></svg>
                    <span><?php echo $lang['admin_lending_mgmt']; ?></span>
                </a>
            </div>
        </nav>

        <div class="p-4 border-t border-gray-700">
            <a href="<?php echo BASE_URL; ?>/dashboard.php" class="flex items-center space-x-3 px-4 py-3 rounded-lg bg-gray-700 hover:bg-gray-600">
                <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                <span><?php echo $lang['user_dashboard']; ?></span>
            </a>
        </div>
    </div>

    <div class="md:ml-64 flex-1 flex flex-col min-h-screen">
        <div class="bg-white shadow-sm border-b">
            <div class="px-6 py-4 flex justify-between items-center">
                <h1 class="text-2xl font-bold text-gray-900"><?php echo $page_title ?? 'Admin'; ?></h1>
                <div class="flex items-center space-x-4">
                    <span class="text-sm text-gray-600"><?php echo esc_html($current_user['first_name'] . ' ' . $current_user['last_name']); ?></span>
                    <a href="<?php echo BASE_URL; ?>/logout.php" class="text-sm text-red-600 hover:text-red-800"><?php echo $lang['nav_logout']; ?></a>
                </div>
            </div>
        </div>

        <?php
        // Flash messages removed - using return.php for all messages
        ?>

        <div class="flex-grow p-6">

<script>
function toggleSection(sectionId) {
    const content = document.getElementById('section-' + sectionId);
    const toggle = document.getElementById('toggle-' + sectionId);
    if (content.classList.contains('open')) {
        content.classList.remove('open');
        toggle.classList.remove('rotate');
        localStorage.setItem('menu-' + sectionId, 'closed');
    } else {
        content.classList.add('open');
        toggle.classList.add('rotate');
        localStorage.setItem('menu-' + sectionId, 'open');
    }
}

document.addEventListener('DOMContentLoaded', function() {
    const currentPage = '<?php echo $current_page; ?>';
    const pageToSection = {
        'books-add.php': 'inventory-mgmt', 'books-edit.php': 'inventory-mgmt', 'books-edit-detail.php': 'inventory-mgmt', 'books-add-copy.php': 'inventory-mgmt', 'books-delete.php': 'inventory-mgmt', 'books-remove.php': 'inventory-mgmt', 'books-littera-import.php': 'inventory-mgmt', 'books-label-print.php': 'inventory-mgmt',
        'lending-checkout.php': 'lending-mgmt', 'lending-return.php': 'lending-mgmt', 'lending-active.php': 'lending-mgmt', 'lending-reminders.php': 'lending-mgmt', 'lending-reservations.php': 'lending-mgmt',
        'users-list.php': 'user-mgmt', 'users-add.php': 'user-mgmt', 'users-sokrates-import.php': 'user-mgmt',
        'inventory-start.php': 'inventory', 'inventory-ongoing.php': 'inventory', 'inventory-history.php': 'inventory',
        'reports-lending.php': 'reports', 'reports-inventory.php': 'reports', 'reports-generator.php': 'reports',
        'settings-general.php': 'settings', 'settings-inventory.php': 'settings', 'settings-users.php': 'settings', 'settings-lending.php': 'settings',
        'settings-backup.php': 'settings', 'settings-system.php': 'settings', 'books-settings.php': 'settings'
    };
    
    const activeSection = pageToSection[currentPage];
    if (activeSection && localStorage.getItem('menu-' + activeSection) !== 'closed') {
        const content = document.getElementById('section-' + activeSection);
        const toggle = document.getElementById('toggle-' + activeSection);
        if (content && toggle) {
            content.classList.add('open');
            toggle.classList.add('rotate');
        }
    }
    
    const mobileBtn = document.getElementById('mobile-menu-btn');
    const sidebar = document.getElementById('sidebar');
    if (mobileBtn && sidebar) {
        mobileBtn.addEventListener('click', function() { sidebar.classList.toggle('hidden'); });
    }
});
</script>
